/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.textservice.ITextServicesManager;
import java.util.Locale;

public class _Original_TextServicesManager {
    private static final String TAG = _Original_TextServicesManager.class.getSimpleName();
    private static final boolean DBG = false;
    private static _Original_TextServicesManager sInstance;
    private final ITextServicesManager mService = ITextServicesManager.Stub.asInterface(ServiceManager.getServiceOrThrow("textservices"));

    private _Original_TextServicesManager() throws ServiceManager.ServiceNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static _Original_TextServicesManager getInstance() {
        Class<_Original_TextServicesManager> clazz = _Original_TextServicesManager.class;
        synchronized (_Original_TextServicesManager.class) {
            if (sInstance == null) {
                try {
                    sInstance = new _Original_TextServicesManager();
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private static String parseLanguageFromLocaleString(String locale) {
        int idx = locale.indexOf(95);
        if (idx < 0) {
            return locale;
        }
        return locale.substring(0, idx);
    }

    public SpellCheckerSession newSpellCheckerSession(Bundle bundle, Locale locale, SpellCheckerSession.SpellCheckerSessionListener listener, boolean referToSpellCheckerLanguageSettings) {
        SpellCheckerInfo sci;
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!referToSpellCheckerLanguageSettings && locale == null) {
            throw new IllegalArgumentException("Locale should not be null if you don't refer settings.");
        }
        if (referToSpellCheckerLanguageSettings && !this.isSpellCheckerEnabled()) {
            return null;
        }
        try {
            sci = this.mService.getCurrentSpellChecker(null);
        }
        catch (RemoteException e) {
            return null;
        }
        if (sci == null) {
            return null;
        }
        SpellCheckerSubtype subtypeInUse = null;
        if (referToSpellCheckerLanguageSettings) {
            String subtypeLocale;
            String subtypeLanguage;
            subtypeInUse = this.getCurrentSpellCheckerSubtype(true);
            if (subtypeInUse == null) {
                return null;
            }
            if (!(locale == null || (subtypeLanguage = _Original_TextServicesManager.parseLanguageFromLocaleString(subtypeLocale = subtypeInUse.getLocale())).length() >= 2 && locale.getLanguage().equals(subtypeLanguage))) {
                return null;
            }
        } else {
            String localeStr = locale.toString();
            for (int i = 0; i < sci.getSubtypeCount(); ++i) {
                SpellCheckerSubtype subtype = sci.getSubtypeAt(i);
                String tempSubtypeLocale = subtype.getLocale();
                String tempSubtypeLanguage = _Original_TextServicesManager.parseLanguageFromLocaleString(tempSubtypeLocale);
                if (tempSubtypeLocale.equals(localeStr)) {
                    subtypeInUse = subtype;
                    break;
                }
                if (tempSubtypeLanguage.length() < 2 || !locale.getLanguage().equals(tempSubtypeLanguage)) continue;
                subtypeInUse = subtype;
            }
        }
        if (subtypeInUse == null) {
            return null;
        }
        SpellCheckerSession session = new SpellCheckerSession(sci, this.mService, listener);
        try {
            this.mService.getSpellCheckerService(sci.getId(), subtypeInUse.getLocale(), session.getTextServicesSessionListener(), session.getSpellCheckerSessionListener(), bundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return session;
    }

    public SpellCheckerInfo[] getEnabledSpellCheckers() {
        try {
            SpellCheckerInfo[] retval = this.mService.getEnabledSpellCheckers();
            return retval;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public SpellCheckerInfo getCurrentSpellChecker() {
        try {
            return this.mService.getCurrentSpellChecker(null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public SpellCheckerSubtype getCurrentSpellCheckerSubtype(boolean allowImplicitlySelectedSubtype) {
        try {
            return this.mService.getCurrentSpellCheckerSubtype(null, allowImplicitlySelectedSubtype);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSpellCheckerEnabled() {
        try {
            return this.mService.isSpellCheckerEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

