/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.util.TypedValue;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

class SmartSelectSprite {
    private static final int EXPAND_DURATION = 300;
    private static final int CORNER_DURATION = 150;
    private static final float STROKE_WIDTH_DP = 1.5f;
    private static final int DEFAULT_STROKE_COLOR = -13408298;
    private final Interpolator mExpandInterpolator;
    private final Interpolator mCornerInterpolator;
    private final float mStrokeWidth;
    private Animator mActiveAnimator = null;
    private final Runnable mInvalidator;
    private final int mStrokeColor;
    static final Comparator<RectF> RECTANGLE_COMPARATOR = Comparator.comparingDouble(e -> e.bottom).thenComparingDouble(e -> e.left);
    private Drawable mExistingDrawable = null;
    private RectangleList mExistingRectangleList = null;

    SmartSelectSprite(Context context, Runnable invalidator) {
        this.mExpandInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
        this.mCornerInterpolator = AnimationUtils.loadInterpolator(context, 17563663);
        this.mStrokeWidth = SmartSelectSprite.dpToPixel(context, 1.5f);
        this.mStrokeColor = SmartSelectSprite.getStrokeColor(context);
        this.mInvalidator = Preconditions.checkNotNull(invalidator);
    }

    public void startAnimation(PointF start, List<RectF> destinationRectangles, Runnable onAnimationEnd) throws IllegalArgumentException {
        this.cancelAnimation();
        ValueAnimator.AnimatorUpdateListener updateListener = valueAnimator -> this.mInvalidator.run();
        LinkedList<RoundedRectangleShape> shapes = new LinkedList<RoundedRectangleShape>();
        LinkedList<Animator> cornerAnimators = new LinkedList<Animator>();
        RectF centerRectangle = destinationRectangles.stream().filter(r -> SmartSelectSprite.contains(r, start)).findFirst().orElseThrow(() -> new IllegalArgumentException("Center point is not inside any of the rectangles!"));
        int startingOffset = 0;
        for (RectF rectangle : destinationRectangles) {
            if (rectangle.equals(centerRectangle)) break;
            startingOffset = (int)((float)startingOffset + rectangle.width());
        }
        startingOffset = (int)((float)startingOffset + (start.x - centerRectangle.left));
        float centerRectangleHalfHeight = centerRectangle.height() / 2.0f;
        float startingOffsetLeft = (float)startingOffset - centerRectangleHalfHeight;
        float startingOffsetRight = (float)startingOffset + centerRectangleHalfHeight;
        int[] expansionDirections = SmartSelectSprite.generateDirections(centerRectangle, destinationRectangles);
        int[] rectangleBorderTypes = SmartSelectSprite.generateBorderTypes(destinationRectangles);
        int index = 0;
        for (RectF rectangle : destinationRectangles) {
            RoundedRectangleShape shape = new RoundedRectangleShape(rectangle, expansionDirections[index], rectangleBorderTypes[index], this.mStrokeWidth);
            cornerAnimators.add(this.createCornerAnimator(shape, updateListener));
            shapes.add(shape);
            ++index;
        }
        RectangleList rectangleList = new RectangleList(shapes);
        ShapeDrawable shapeDrawable = new ShapeDrawable(rectangleList);
        Paint paint = shapeDrawable.getPaint();
        paint.setColor(this.mStrokeColor);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(this.mStrokeWidth);
        this.mExistingRectangleList = rectangleList;
        this.mExistingDrawable = shapeDrawable;
        this.mActiveAnimator = this.createAnimator(rectangleList, startingOffsetLeft, startingOffsetRight, cornerAnimators, updateListener, onAnimationEnd);
        this.mActiveAnimator.start();
    }

    private Animator createAnimator(RectangleList rectangleList, float startingOffsetLeft, float startingOffsetRight, List<Animator> cornerAnimators, ValueAnimator.AnimatorUpdateListener updateListener, Runnable onAnimationEnd) {
        ObjectAnimator rightBoundaryAnimator = ObjectAnimator.ofFloat((Object)rectangleList, "rightBoundary", startingOffsetRight, rectangleList.getTotalWidth());
        ObjectAnimator leftBoundaryAnimator = ObjectAnimator.ofFloat((Object)rectangleList, "leftBoundary", startingOffsetLeft, 0.0f);
        rightBoundaryAnimator.setDuration(300L);
        leftBoundaryAnimator.setDuration(300L);
        rightBoundaryAnimator.addUpdateListener(updateListener);
        leftBoundaryAnimator.addUpdateListener(updateListener);
        rightBoundaryAnimator.setInterpolator(this.mExpandInterpolator);
        leftBoundaryAnimator.setInterpolator(this.mExpandInterpolator);
        AnimatorSet cornerAnimator = new AnimatorSet();
        cornerAnimator.playTogether(cornerAnimators);
        AnimatorSet boundaryAnimator = new AnimatorSet();
        boundaryAnimator.playTogether(leftBoundaryAnimator, rightBoundaryAnimator);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playSequentially(boundaryAnimator, cornerAnimator);
        this.setUpAnimatorListener(animatorSet, onAnimationEnd);
        return animatorSet;
    }

    private void setUpAnimatorListener(Animator animator2, final Runnable onAnimationEnd) {
        animator2.addListener(new Animator.AnimatorListener(){

            @Override
            public void onAnimationStart(Animator animator2) {
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                SmartSelectSprite.this.mExistingRectangleList.setDisplayType(1);
                SmartSelectSprite.this.mInvalidator.run();
                onAnimationEnd.run();
            }

            @Override
            public void onAnimationCancel(Animator animator2) {
            }

            @Override
            public void onAnimationRepeat(Animator animator2) {
            }
        });
    }

    private ObjectAnimator createCornerAnimator(RoundedRectangleShape shape, ValueAnimator.AnimatorUpdateListener listener) {
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)shape, "roundRatio", shape.getRoundRatio(), 0.0f);
        animator2.setDuration(150L);
        animator2.addUpdateListener(listener);
        animator2.setInterpolator(this.mCornerInterpolator);
        return animator2;
    }

    private static int[] generateDirections(RectF centerRectangle, List<RectF> rectangles) {
        int i;
        int[] result = new int[rectangles.size()];
        int centerRectangleIndex = rectangles.indexOf(centerRectangle);
        for (i = 0; i < centerRectangleIndex - 1; ++i) {
            result[i] = 0;
        }
        result[centerRectangleIndex] = rectangles.size() == 1 ? 1 : (centerRectangleIndex == 0 ? 0 : (centerRectangleIndex == rectangles.size() - 1 ? 2 : 1));
        for (i = centerRectangleIndex + 1; i < result.length; ++i) {
            result[i] = 2;
        }
        return result;
    }

    private static int[] generateBorderTypes(List<RectF> rectangles) {
        int[] result = new int[rectangles.size()];
        for (int i = 1; i < result.length - 1; ++i) {
            result[i] = 1;
        }
        result[0] = 0;
        result[result.length - 1] = 0;
        return result;
    }

    private static float dpToPixel(Context context, float dp) {
        return TypedValue.applyDimension(1, dp, context.getResources().getDisplayMetrics());
    }

    private static int getStrokeColor(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray array2 = context.obtainStyledAttributes(typedValue.data, new int[]{16843818});
        int result = array2.getColor(0, -13408298);
        array2.recycle();
        return result;
    }

    private static boolean contains(RectF rectangle, PointF point) {
        float x = point.x;
        float y = point.y;
        return x >= rectangle.left && x <= rectangle.right && y >= rectangle.top && y <= rectangle.bottom;
    }

    private void removeExistingDrawables() {
        this.mExistingDrawable = null;
        this.mExistingRectangleList = null;
        this.mInvalidator.run();
    }

    public void cancelAnimation() {
        if (this.mActiveAnimator != null) {
            this.mActiveAnimator.cancel();
            this.mActiveAnimator = null;
            this.removeExistingDrawables();
        }
    }

    public void draw(Canvas canvas) {
        if (this.mExistingDrawable != null) {
            this.mExistingDrawable.draw(canvas);
        }
    }

    private static class RectangleList
    extends Shape {
        private static final String PROPERTY_RIGHT_BOUNDARY = "rightBoundary";
        private static final String PROPERTY_LEFT_BOUNDARY = "leftBoundary";
        private final List<RoundedRectangleShape> mRectangles;
        private final List<RoundedRectangleShape> mReversedRectangles;
        private final Path mOutlinePolygonPath;
        private int mDisplayType = 0;

        private RectangleList(List<RoundedRectangleShape> rectangles) {
            this.mRectangles = new LinkedList<RoundedRectangleShape>(rectangles);
            this.mReversedRectangles = new LinkedList<RoundedRectangleShape>(rectangles);
            Collections.reverse(this.mReversedRectangles);
            this.mOutlinePolygonPath = RectangleList.generateOutlinePolygonPath(rectangles);
        }

        private void setLeftBoundary(float leftBoundary) {
            float boundarySoFar = this.getTotalWidth();
            for (RoundedRectangleShape rectangle : this.mReversedRectangles) {
                float rectangleLeftBoundary = boundarySoFar - rectangle.getBoundingWidth();
                if (leftBoundary < rectangleLeftBoundary) {
                    rectangle.setLeftBoundary(0.0f);
                } else if (leftBoundary > boundarySoFar) {
                    rectangle.setLeftBoundary(rectangle.getBoundingWidth());
                } else {
                    rectangle.setLeftBoundary(rectangle.getBoundingWidth() - boundarySoFar + leftBoundary);
                }
                boundarySoFar = rectangleLeftBoundary;
            }
        }

        private void setRightBoundary(float rightBoundary) {
            float boundarySoFar = 0.0f;
            for (RoundedRectangleShape rectangle : this.mRectangles) {
                float rectangleRightBoundary = rectangle.getBoundingWidth() + boundarySoFar;
                if (rectangleRightBoundary < rightBoundary) {
                    rectangle.setRightBoundary(rectangle.getBoundingWidth());
                } else if (boundarySoFar > rightBoundary) {
                    rectangle.setRightBoundary(0.0f);
                } else {
                    rectangle.setRightBoundary(rightBoundary - boundarySoFar);
                }
                boundarySoFar = rectangleRightBoundary;
            }
        }

        void setDisplayType(int displayType) {
            this.mDisplayType = displayType;
        }

        private int getTotalWidth() {
            int sum = 0;
            for (RoundedRectangleShape rectangle : this.mRectangles) {
                sum = (int)((float)sum + rectangle.getBoundingWidth());
            }
            return sum;
        }

        @Override
        public void draw(Canvas canvas, Paint paint) {
            if (this.mDisplayType == 1) {
                this.drawPolygon(canvas, paint);
            } else {
                this.drawRectangles(canvas, paint);
            }
        }

        private void drawRectangles(Canvas canvas, Paint paint) {
            for (RoundedRectangleShape rectangle : this.mRectangles) {
                rectangle.draw(canvas, paint);
            }
        }

        private void drawPolygon(Canvas canvas, Paint paint) {
            canvas.drawPath(this.mOutlinePolygonPath, paint);
        }

        private static Path generateOutlinePolygonPath(List<RoundedRectangleShape> rectangles) {
            Path path = new Path();
            for (RoundedRectangleShape shape : rectangles) {
                Path rectanglePath = new Path();
                rectanglePath.addRect(shape.mBoundingRectangle, Path.Direction.CW);
                path.op(rectanglePath, Path.Op.UNION);
            }
            return path;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface DisplayType {
            public static final int RECTANGLES = 0;
            public static final int POLYGON = 1;
        }
    }

    private static class RoundedRectangleShape
    extends Shape {
        private static final String PROPERTY_ROUND_RATIO = "roundRatio";
        private final float mStrokeWidth;
        private final RectF mBoundingRectangle;
        private float mRoundRatio = 1.0f;
        private final int mExpansionDirection;
        private final int mRectangleBorderType;
        private final RectF mDrawRect = new RectF();
        private final RectF mClipRect = new RectF();
        private final Path mClipPath = new Path();
        private float mLeftBoundary = 0.0f;
        private float mRightBoundary = 0.0f;

        private RoundedRectangleShape(RectF boundingRectangle, int expansionDirection, int rectangleBorderType, float strokeWidth) {
            this.mBoundingRectangle = new RectF(boundingRectangle);
            this.mExpansionDirection = expansionDirection;
            this.mRectangleBorderType = rectangleBorderType;
            this.mStrokeWidth = strokeWidth;
            if (boundingRectangle.height() > boundingRectangle.width()) {
                this.setRoundRatio(0.0f);
            } else {
                this.setRoundRatio(1.0f);
            }
        }

        @Override
        public void draw(Canvas canvas, Paint paint) {
            float cornerRadius = this.getCornerRadius();
            float adjustedCornerRadius = this.getAdjustedCornerRadius();
            this.mDrawRect.set(this.mBoundingRectangle);
            this.mDrawRect.left = this.mBoundingRectangle.left + this.mLeftBoundary;
            this.mDrawRect.right = this.mBoundingRectangle.left + this.mRightBoundary;
            if (this.mRectangleBorderType == 1) {
                this.mDrawRect.left -= cornerRadius / 2.0f;
                this.mDrawRect.right -= cornerRadius / 2.0f;
            } else {
                switch (this.mExpansionDirection) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        this.mDrawRect.right += cornerRadius;
                        break;
                    }
                    case 2: {
                        this.mDrawRect.left -= cornerRadius;
                    }
                }
            }
            canvas.save();
            this.mClipRect.set(this.mBoundingRectangle);
            this.mClipRect.inset(-this.mStrokeWidth, -this.mStrokeWidth);
            canvas.clipRect(this.mClipRect);
            canvas.drawRoundRect(this.mDrawRect, adjustedCornerRadius, adjustedCornerRadius, paint);
            canvas.restore();
            canvas.save();
            this.mClipPath.reset();
            this.mClipPath.addRoundRect(this.mDrawRect, adjustedCornerRadius, adjustedCornerRadius, Path.Direction.CW);
            canvas.clipPath(this.mClipPath);
            canvas.drawRect(this.mBoundingRectangle, paint);
            canvas.restore();
        }

        public void setRoundRatio(float roundRatio) {
            this.mRoundRatio = roundRatio;
        }

        public float getRoundRatio() {
            return this.mRoundRatio;
        }

        private void setLeftBoundary(float leftBoundary) {
            this.mLeftBoundary = leftBoundary;
        }

        private void setRightBoundary(float rightBoundary) {
            this.mRightBoundary = rightBoundary;
        }

        private float getCornerRadius() {
            return Math.min(this.mBoundingRectangle.width(), this.mBoundingRectangle.height());
        }

        private float getAdjustedCornerRadius() {
            return this.getCornerRadius() * this.mRoundRatio;
        }

        private float getBoundingWidth() {
            if (this.mRectangleBorderType == 1) {
                return (int)(this.mBoundingRectangle.width() + this.getCornerRadius());
            }
            return this.mBoundingRectangle.width();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface RectangleBorderType {
            public static final int FIT = 0;
            public static final int OVERSHOOT = 1;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface ExpansionDirection {
            public static final int LEFT = 0;
            public static final int CENTER = 1;
            public static final int RIGHT = 2;
        }
    }
}

