/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParserException;

public class PowerProfile {
    public static final String POWER_NONE = "none";
    public static final String POWER_CPU_IDLE = "cpu.idle";
    public static final String POWER_CPU_AWAKE = "cpu.awake";
    @Deprecated
    public static final String POWER_CPU_ACTIVE = "cpu.active";
    public static final String POWER_WIFI_SCAN = "wifi.scan";
    public static final String POWER_WIFI_ON = "wifi.on";
    public static final String POWER_WIFI_ACTIVE = "wifi.active";
    public static final String POWER_WIFI_CONTROLLER_IDLE = "wifi.controller.idle";
    public static final String POWER_WIFI_CONTROLLER_RX = "wifi.controller.rx";
    public static final String POWER_WIFI_CONTROLLER_TX = "wifi.controller.tx";
    public static final String POWER_WIFI_CONTROLLER_TX_LEVELS = "wifi.controller.tx_levels";
    public static final String POWER_WIFI_CONTROLLER_OPERATING_VOLTAGE = "wifi.controller.voltage";
    public static final String POWER_BLUETOOTH_CONTROLLER_IDLE = "bluetooth.controller.idle";
    public static final String POWER_BLUETOOTH_CONTROLLER_RX = "bluetooth.controller.rx";
    public static final String POWER_BLUETOOTH_CONTROLLER_TX = "bluetooth.controller.tx";
    public static final String POWER_BLUETOOTH_CONTROLLER_OPERATING_VOLTAGE = "bluetooth.controller.voltage";
    public static final String POWER_MODEM_CONTROLLER_IDLE = "modem.controller.idle";
    public static final String POWER_MODEM_CONTROLLER_RX = "modem.controller.rx";
    public static final String POWER_MODEM_CONTROLLER_TX = "modem.controller.tx";
    public static final String POWER_MODEM_CONTROLLER_OPERATING_VOLTAGE = "modem.controller.voltage";
    public static final String POWER_GPS_ON = "gps.on";
    @Deprecated
    public static final String POWER_BLUETOOTH_ON = "bluetooth.on";
    @Deprecated
    public static final String POWER_BLUETOOTH_ACTIVE = "bluetooth.active";
    @Deprecated
    public static final String POWER_BLUETOOTH_AT_CMD = "bluetooth.at";
    public static final String POWER_SCREEN_ON = "screen.on";
    public static final String POWER_RADIO_ON = "radio.on";
    public static final String POWER_RADIO_SCANNING = "radio.scanning";
    public static final String POWER_RADIO_ACTIVE = "radio.active";
    public static final String POWER_SCREEN_FULL = "screen.full";
    public static final String POWER_AUDIO = "dsp.audio";
    public static final String POWER_VIDEO = "dsp.video";
    public static final String POWER_FLASHLIGHT = "camera.flashlight";
    public static final String POWER_MEMORY = "memory.bandwidths";
    public static final String POWER_CAMERA = "camera.avg";
    @Deprecated
    public static final String POWER_CPU_SPEEDS = "cpu.speeds";
    public static final String POWER_WIFI_BATCHED_SCAN = "wifi.batchedscan";
    public static final String POWER_BATTERY_CAPACITY = "battery.capacity";
    static final HashMap<String, Object> sPowerMap = new HashMap();
    private static final String TAG_DEVICE = "device";
    private static final String TAG_ITEM = "item";
    private static final String TAG_ARRAY = "array";
    private static final String TAG_ARRAYITEM = "value";
    private static final String ATTR_NAME = "name";
    private static final Object sLock = new Object();
    private CpuClusterKey[] mCpuClusters;
    private static final String POWER_CPU_CLUSTER_CORE_COUNT = "cpu.clusters.cores";
    private static final String POWER_CPU_CLUSTER_SPEED_PREFIX = "cpu.speeds.cluster";
    private static final String POWER_CPU_CLUSTER_ACTIVE_PREFIX = "cpu.active.cluster";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerProfile(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (sPowerMap.size() == 0) {
                this.readPowerValuesFromXml(context);
            }
            this.initCpuClusters();
        }
    }

    private void readPowerValuesFromXml(Context context) {
        int id2 = 0x1170010;
        Resources resources = context.getResources();
        XmlResourceParser parser = resources.getXml(id2);
        boolean parsingArray = false;
        ArrayList<Double> array2 = new ArrayList<Double>();
        String arrayName = null;
        try {
            XmlUtils.beginDocument(parser, TAG_DEVICE);
            while (true) {
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) break;
                if (parsingArray && !element.equals(TAG_ARRAYITEM)) {
                    sPowerMap.put(arrayName, array2.toArray(new Double[array2.size()]));
                    parsingArray = false;
                }
                if (element.equals(TAG_ARRAY)) {
                    parsingArray = true;
                    array2.clear();
                    arrayName = parser.getAttributeValue(null, ATTR_NAME);
                    continue;
                }
                if (!element.equals(TAG_ITEM) && !element.equals(TAG_ARRAYITEM)) continue;
                String name = null;
                if (!parsingArray) {
                    name = parser.getAttributeValue(null, ATTR_NAME);
                }
                if (parser.next() != 4) continue;
                String power = parser.getText();
                double value = 0.0;
                try {
                    value = Double.valueOf(power);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (element.equals(TAG_ITEM)) {
                    sPowerMap.put(name, value);
                    continue;
                }
                if (!parsingArray) continue;
                array2.add(value);
            }
            if (parsingArray) {
                sPowerMap.put(arrayName, array2.toArray(new Double[array2.size()]));
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            parser.close();
        }
        int[] configResIds = new int[]{17694738, 17694742, 17694743, 17694741, 17694908, 17694866, 17694916, 17694913};
        String[] configResIdKeys = new String[]{POWER_BLUETOOTH_CONTROLLER_IDLE, POWER_BLUETOOTH_CONTROLLER_RX, POWER_BLUETOOTH_CONTROLLER_TX, POWER_BLUETOOTH_CONTROLLER_OPERATING_VOLTAGE, POWER_WIFI_CONTROLLER_IDLE, POWER_WIFI_CONTROLLER_RX, POWER_WIFI_CONTROLLER_TX, POWER_WIFI_CONTROLLER_OPERATING_VOLTAGE};
        for (int i = 0; i < configResIds.length; ++i) {
            int value;
            String key = configResIdKeys[i];
            if (sPowerMap.containsKey(key) && (Double)sPowerMap.get(key) > 0.0 || (value = resources.getInteger(configResIds[i])) <= 0) continue;
            sPowerMap.put(key, value);
        }
    }

    private void initCpuClusters() {
        Object obj = sPowerMap.get(POWER_CPU_CLUSTER_CORE_COUNT);
        if (obj == null || !(obj instanceof Double[])) {
            this.mCpuClusters = new CpuClusterKey[1];
            this.mCpuClusters[0] = new CpuClusterKey(POWER_CPU_SPEEDS, POWER_CPU_ACTIVE, 1);
        } else {
            Double[] array2 = (Double[])obj;
            this.mCpuClusters = new CpuClusterKey[array2.length];
            for (int cluster = 0; cluster < array2.length; ++cluster) {
                int numCpusInCluster = (int)Math.round(array2[cluster]);
                this.mCpuClusters[cluster] = new CpuClusterKey(POWER_CPU_CLUSTER_SPEED_PREFIX + cluster, POWER_CPU_CLUSTER_ACTIVE_PREFIX + cluster, numCpusInCluster);
            }
        }
    }

    public int getNumCpuClusters() {
        return this.mCpuClusters.length;
    }

    public int getNumCoresInCpuCluster(int index) {
        return this.mCpuClusters[index].numCpus;
    }

    public int getNumSpeedStepsInCpuCluster(int index) {
        Object value = sPowerMap.get(this.mCpuClusters[index].timeKey);
        if (value != null && value instanceof Double[]) {
            return ((Double[])value).length;
        }
        return 1;
    }

    public double getAveragePowerForCpu(int cluster, int step) {
        if (cluster >= 0 && cluster < this.mCpuClusters.length) {
            return this.getAveragePower(this.mCpuClusters[cluster].powerKey, step);
        }
        return 0.0;
    }

    public int getNumElements(String key) {
        if (sPowerMap.containsKey(key)) {
            Object data = sPowerMap.get(key);
            if (data instanceof Double[]) {
                Double[] values = (Double[])data;
                return values.length;
            }
            return 1;
        }
        return 0;
    }

    public double getAveragePowerOrDefault(String type, double defaultValue) {
        if (sPowerMap.containsKey(type)) {
            Object data = sPowerMap.get(type);
            if (data instanceof Double[]) {
                return ((Double[])data)[0];
            }
            return (Double)sPowerMap.get(type);
        }
        return defaultValue;
    }

    public double getAveragePower(String type) {
        return this.getAveragePowerOrDefault(type, 0.0);
    }

    public double getAveragePower(String type, int level) {
        if (sPowerMap.containsKey(type)) {
            Object data = sPowerMap.get(type);
            if (data instanceof Double[]) {
                Double[] values = (Double[])data;
                if (values.length > level && level >= 0) {
                    return values[level];
                }
                if (level < 0 || values.length == 0) {
                    return 0.0;
                }
                return values[values.length - 1];
            }
            return (Double)data;
        }
        return 0.0;
    }

    public double getBatteryCapacity() {
        return this.getAveragePower(POWER_BATTERY_CAPACITY);
    }

    public static class CpuClusterKey {
        private final String timeKey;
        private final String powerKey;
        private final int numCpus;

        private CpuClusterKey(String timeKey, String powerKey, int numCpus) {
            this.timeKey = timeKey;
            this.powerKey = powerKey;
            this.numCpus = numCpus;
        }
    }
}

