/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;

public class AppCompatCallDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"AppCompatMethod", (String)"Using Wrong AppCompat Method", (String)"When using the appcompat library, there are some methods you should be calling instead of the normal ones; for example, `getSupportActionBar()` instead of `getActionBar()`. This lint check looks for calls to the wrong method.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(AppCompatCallDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/tools/support-library/index.html");
    private static final String GET_ACTION_BAR = "getActionBar";
    private static final String START_ACTION_MODE = "startActionMode";
    private static final String SET_PROGRESS_BAR_VIS = "setProgressBarVisibility";
    private static final String SET_PROGRESS_BAR_IN_VIS = "setProgressBarIndeterminateVisibility";
    private static final String SET_PROGRESS_BAR_INDETERMINATE = "setProgressBarIndeterminate";
    private static final String REQUEST_WINDOW_FEATURE = "requestWindowFeature";
    private boolean mDependsOnAppCompat;

    public void beforeCheckProject(Context context) {
        Boolean dependsOnAppCompat = context.getProject().dependsOn("com.android.support:appcompat-v7");
        this.mDependsOnAppCompat = dependsOnAppCompat != null && dependsOnAppCompat != false;
    }

    public List<String> getApplicableMethodNames() {
        return Arrays.asList(GET_ACTION_BAR, START_ACTION_MODE, SET_PROGRESS_BAR_VIS, SET_PROGRESS_BAR_IN_VIS, SET_PROGRESS_BAR_INDETERMINATE, REQUEST_WINDOW_FEATURE);
    }

    public void visitMethod(JavaContext context, UCallExpression node, PsiMethod method) {
        if (this.mDependsOnAppCompat && AppCompatCallDetector.isAppBarActivityCall(context, node, method)) {
            String name = method.getName();
            String replace = null;
            if (GET_ACTION_BAR.equals(name)) {
                replace = "getSupportActionBar";
            } else if (START_ACTION_MODE.equals(name)) {
                replace = "startSupportActionMode";
            } else if (SET_PROGRESS_BAR_VIS.equals(name)) {
                replace = "setSupportProgressBarVisibility";
            } else if (SET_PROGRESS_BAR_IN_VIS.equals(name)) {
                replace = "setSupportProgressBarIndeterminateVisibility";
            } else if (SET_PROGRESS_BAR_INDETERMINATE.equals(name)) {
                replace = "setSupportProgressBarIndeterminate";
            } else if (REQUEST_WINDOW_FEATURE.equals(name)) {
                replace = "supportRequestWindowFeature";
            }
            if (replace != null) {
                String message = String.format("Should use `%1$s` instead of `%2$s` name", replace, name);
                LintFix fix = this.fix().name("Replace with " + replace + "()").replace().text(name).with(replace).build();
                context.report(ISSUE, (UElement)node, context.getLocation((UElement)node), message, fix);
            }
        }
    }

    private static boolean isAppBarActivityCall(JavaContext context, UCallExpression node, PsiMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isMemberInSubClassOf((PsiMember)method, "android.app.Activity", false)) {
            UClass cls = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            return cls != null && evaluator.extendsClass((PsiClass)cls, "android.support.v7.app.ActionBarActivity", false);
        }
        return false;
    }
}

