/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UAnnotation;

public abstract class PermissionRequirement {
    public static final String ATTR_PROTECTION_LEVEL = "protectionLevel";
    public static final String VALUE_DANGEROUS = "dangerous";
    protected final UAnnotation annotation;
    private int firstApi;
    private int lastApi;
    public static final PermissionRequirement NONE = new PermissionRequirement(null){

        @Override
        public boolean isSatisfied(PermissionHolder available) {
            return true;
        }

        @Override
        public boolean appliesTo(PermissionHolder available) {
            return false;
        }

        @Override
        public boolean isConditional() {
            return false;
        }

        @Override
        public boolean isRevocable(PermissionHolder revocable) {
            return false;
        }

        public String toString() {
            return "None";
        }

        @Override
        protected void addMissingPermissions(PermissionHolder available, Set<String> result) {
        }

        @Override
        protected void addRevocablePermissions(Set<String> result, PermissionHolder revocable) {
        }

        @Override
        public IElementType getOperator() {
            return null;
        }

        @Override
        public Iterable<PermissionRequirement> getChildren() {
            return Collections.emptyList();
        }
    };
    static final String[] REVOCABLE_PERMISSION_NAMES = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ANSWER_PHONE_CALLS", "android.permission.BODY_SENSORS", "android.permission.CALL_PHONE", "android.permission.CAMERA", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.READ_CALENDAR", "android.permission.READ_CALL_LOG", "android.permission.READ_CELL_BROADCASTS", "android.permission.READ_CONTACTS", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_PHONE_NUMBERS", "android.permission.READ_PHONE_STATE", "android.permission.READ_SMS", "android.permission.RECEIVE_MMS", "android.permission.RECEIVE_SMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.RECORD_AUDIO", "android.permission.SEND_SMS", "android.permission.USE_SIP", "android.permission.WRITE_CALENDAR", "android.permission.WRITE_CALL_LOG", "android.permission.WRITE_CONTACTS", "android.permission.WRITE_EXTERNAL_STORAGE", "com.android.voicemail.permission.ADD_VOICEMAIL"};

    private PermissionRequirement(UAnnotation annotation) {
        this.annotation = annotation;
    }

    public static PermissionRequirement create(UAnnotation annotation) {
        String[] allOf;
        String value = UastLintUtils.getAnnotationStringValue((UAnnotation)annotation, (String)"value");
        if (value != null && !value.isEmpty()) {
            return new Single(annotation, value);
        }
        String[] anyOf = UastLintUtils.getAnnotationStringValues((UAnnotation)annotation, (String)"anyOf");
        if (anyOf != null) {
            if (anyOf.length > 1) {
                return new Many(annotation, JavaTokenType.OROR, anyOf);
            }
            if (anyOf.length == 1) {
                return new Single(annotation, anyOf[0]);
            }
        }
        if ((allOf = UastLintUtils.getAnnotationStringValues((UAnnotation)annotation, (String)"allOf")) != null) {
            if (allOf.length > 1) {
                return new Many(annotation, JavaTokenType.ANDAND, allOf);
            }
            if (allOf.length == 1) {
                return new Single(annotation, allOf[0]);
            }
        }
        return NONE;
    }

    protected boolean appliesTo(PermissionHolder available) {
        this.initializeRange();
        if (this.firstApi != -1) {
            AndroidVersion minSdkVersion = available.getMinSdkVersion();
            if (minSdkVersion.getFeatureLevel() > this.lastApi) {
                return false;
            }
            AndroidVersion targetSdkVersion = available.getTargetSdkVersion();
            if (targetSdkVersion.getFeatureLevel() < this.firstApi) {
                return false;
            }
        }
        return true;
    }

    public int getLastApplicableApi() {
        this.initializeRange();
        return this.lastApi;
    }

    public int getFirstApplicableApi() {
        this.initializeRange();
        return this.firstApi >= 1 ? this.firstApi : 1;
    }

    private void initializeRange() {
        if (this.firstApi == 0) {
            int index;
            this.firstApi = -1;
            this.lastApi = Integer.MAX_VALUE;
            String range = UastLintUtils.getAnnotationStringValue((UAnnotation)this.annotation, (String)"apis");
            if (range != null && (index = range.indexOf("..")) != -1) {
                try {
                    this.firstApi = index > 0 ? Integer.parseInt(range.substring(0, index)) : 1;
                    this.lastApi = index + 2 < range.length() ? Integer.parseInt(range.substring(index + 2)) : Integer.MAX_VALUE;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isConditional() {
        Boolean o = UastLintUtils.getAnnotationBooleanValue((UAnnotation)this.annotation, (String)"conditional");
        if (o != null) {
            return o;
        }
        return false;
    }

    public boolean isSingle() {
        return true;
    }

    public abstract boolean isSatisfied(PermissionHolder var1);

    public String describeMissingPermissions(PermissionHolder available) {
        return "";
    }

    public Set<String> getMissingPermissions(PermissionHolder available) {
        HashSet result = Sets.newHashSet();
        this.addMissingPermissions(available, result);
        return result;
    }

    protected abstract void addMissingPermissions(PermissionHolder var1, Set<String> var2);

    public Set<String> getRevocablePermissions(PermissionHolder revocable) {
        HashSet result = Sets.newHashSet();
        this.addRevocablePermissions(result, revocable);
        return result;
    }

    protected abstract void addRevocablePermissions(Set<String> var1, PermissionHolder var2);

    public abstract boolean isRevocable(PermissionHolder var1);

    public abstract IElementType getOperator();

    public abstract Iterable<PermissionRequirement> getChildren();

    protected static void appendOperator(StringBuilder sb, IElementType operator) {
        sb.append(' ');
        if (operator == JavaTokenType.ANDAND) {
            sb.append("and");
        } else if (operator == JavaTokenType.OROR) {
            sb.append("or");
        } else {
            assert (operator == JavaTokenType.XOR) : operator;
            sb.append("xor");
        }
        sb.append(' ');
    }

    public static boolean isRevocableSystemPermission(String name) {
        return Arrays.binarySearch(REVOCABLE_PERMISSION_NAMES, name) >= 0;
    }

    private static class Many
    extends PermissionRequirement {
        public final IElementType operator;
        public final List<PermissionRequirement> permissions;

        public Many(UAnnotation annotation, IElementType operator, String[] names) {
            super(annotation);
            assert (operator == JavaTokenType.OROR || operator == JavaTokenType.ANDAND) : operator;
            assert (names.length >= 2);
            this.operator = operator;
            this.permissions = Lists.newArrayListWithExpectedSize((int)names.length);
            for (String name : names) {
                this.permissions.add(new Single(annotation, name));
            }
        }

        @Override
        public boolean isSingle() {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.permissions.get(0));
            for (int i = 1; i < this.permissions.size(); ++i) {
                Many.appendOperator(sb, this.operator);
                sb.append(this.permissions.get(i));
            }
            return sb.toString();
        }

        @Override
        public boolean isSatisfied(PermissionHolder available) {
            if (this.operator == JavaTokenType.ANDAND) {
                for (PermissionRequirement requirement : this.permissions) {
                    if (requirement.isSatisfied(available) || !requirement.appliesTo(available)) continue;
                    return false;
                }
                return true;
            }
            assert (this.operator == JavaTokenType.OROR) : this.operator;
            for (PermissionRequirement requirement : this.permissions) {
                if (!requirement.isSatisfied(available) && requirement.appliesTo(available)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String describeMissingPermissions(PermissionHolder available) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (PermissionRequirement requirement : this.permissions) {
                if (requirement.isSatisfied(available)) continue;
                if (first) {
                    first = false;
                } else {
                    Many.appendOperator(sb, this.operator);
                }
                sb.append(requirement.describeMissingPermissions(available));
            }
            return sb.toString();
        }

        @Override
        protected void addMissingPermissions(PermissionHolder available, Set<String> missing) {
            for (PermissionRequirement requirement : this.permissions) {
                if (requirement.isSatisfied(available)) continue;
                requirement.addMissingPermissions(available, missing);
            }
        }

        @Override
        protected void addRevocablePermissions(Set<String> result, PermissionHolder revocable) {
            for (PermissionRequirement requirement : this.permissions) {
                requirement.addRevocablePermissions(result, revocable);
            }
        }

        @Override
        public boolean isRevocable(PermissionHolder revocable) {
            for (PermissionRequirement requirement : this.permissions) {
                if (!requirement.isRevocable(revocable)) continue;
                return true;
            }
            return false;
        }

        @Override
        public IElementType getOperator() {
            return this.operator;
        }

        @Override
        public Iterable<PermissionRequirement> getChildren() {
            return this.permissions;
        }
    }

    private static class Single
    extends PermissionRequirement {
        public final String name;

        public Single(UAnnotation annotation, String name) {
            super(annotation);
            this.name = name;
        }

        @Override
        public boolean isRevocable(PermissionHolder revocable) {
            return revocable.isRevocable(this.name) || Single.isRevocableSystemPermission(this.name);
        }

        @Override
        public IElementType getOperator() {
            return null;
        }

        @Override
        public Iterable<PermissionRequirement> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public boolean isSingle() {
            return true;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public boolean isSatisfied(PermissionHolder available) {
            return available.hasPermission(this.name) || !this.appliesTo(available);
        }

        @Override
        public String describeMissingPermissions(PermissionHolder available) {
            return this.isSatisfied(available) ? "" : this.name;
        }

        @Override
        protected void addMissingPermissions(PermissionHolder available, Set<String> missing) {
            if (!this.isSatisfied(available)) {
                missing.add(this.name);
            }
        }

        @Override
        protected void addRevocablePermissions(Set<String> result, PermissionHolder revocable) {
            if (this.isRevocable(revocable)) {
                result.add(this.name);
            }
        }
    }
}

