/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.JavaScriptDebuggerEvaluator;
import com.intellij.javascript.trace.debugger.TraceSessionEvaluator;
import com.intellij.javascript.trace.debugger.values.TraceObjectWithLength;
import com.intellij.javascript.trace.debugger.values.TraceValueManager;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.IndexedPsiFile;
import com.intellij.javascript.trace.execution.common.PropertyMetadata;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationRequest;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.BasicDebuggerViewSupport;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueType;

public class ExpressionEvaluator
implements VariableContext,
EvaluateContext,
TraceSessionEvaluator {
    private final String myFilePath;
    private final TraceSession mySession;
    private ExpressionEvaluationResult myCachedResult;
    private final IndexedPsiFile myFile;
    private static final Logger LOG = Logger.getInstance(ExpressionEvaluator.class);

    public ExpressionEvaluator(TraceSession session, IndexedPsiFile file, String url) {
        this.myFile = file;
        this.mySession = session;
        this.myFilePath = url;
    }

    @Nullable
    public Vm getVm() {
        return null;
    }

    @Override
    public void cache(ExpressionEvaluationResult result) {
        this.myCachedResult = result;
    }

    @Override
    public Promise<ExpressionEvaluationResult> evaluateExpression(ExpressionEvaluationRequest request) {
        if (this.myCachedResult != null) {
            LOG.info("Cached evaluation result returned");
            return Promise.resolve((Object)this.myCachedResult);
        }
        Integer function = this.myFile.getFunctionId(request.getContext());
        if (function == null) {
            LOG.info("Trace function id for PSI element not found");
            return Promise.resolve((Object)new ExpressionEvaluationResult(null, new PropertyMetadata[0], false, true));
        }
        request.setFunctionId(function);
        request.setTotalNumberOfFunctions(this.myFile.getFunctionNumber());
        request.setFile(this.myFilePath);
        return ExpressionEvaluator.evaluateExpression(this.mySession, request);
    }

    @NotNull
    private static Promise<ExpressionEvaluationResult> evaluateExpression(final TraceSession session, final ExpressionEvaluationRequest request) {
        final AsyncPromise result = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){
            final ExpressionEvaluationResult[] value = new ExpressionEvaluationResult[]{new ExpressionEvaluationResult(null, new PropertyMetadata[0], false, false)};
            final Semaphore semaphore = new Semaphore();
            boolean done = false;

            @Override
            public void run() {
                this.semaphore.down();
                session.evaluateExpression(request, (Consumer<ExpressionEvaluationResult>)((Consumer)evaluationResult -> {
                    this.value[0] = evaluationResult;
                    this.done = true;
                    this.semaphore.up();
                }));
                this.semaphore.waitFor(request.getTimeout());
                if (!this.done) {
                    LOG.info("Expression evaluation was not finished in time");
                }
                result.setResult((Object)this.value[0]);
            }
        });
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            ExpressionEvaluator.$$$reportNull$$$0(0);
        }
        return asyncPromise;
    }

    @Override
    public ContextMetadata getContextMetadata(String context) {
        return this.mySession.getContextMetadata(context);
    }

    @Override
    public boolean isReadyToEvaluate() {
        return !this.mySession.isLoaded() && this.mySession.isRunning();
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile.getPsiFile();
        if (psiFile == null) {
            ExpressionEvaluator.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    public static XDebuggerEvaluator getDebuggerEvaluator(Project project, PsiFile file) {
        IndexedPsiFile indexedPsiFile = IndexedPsiFile.getIndexedPsiFile(project, file, true);
        if (indexedPsiFile == null) {
            return null;
        }
        ExpressionEvaluator evaluator = indexedPsiFile.getEvaluator();
        return evaluator.isReadyToEvaluate() ? new MyEvaluator(evaluator) : null;
    }

    public static TraceSessionEvaluator getRemoteEvaluator(Project project, PsiFile file) {
        IndexedPsiFile indexedPsiFile = IndexedPsiFile.getIndexedPsiFile(project, file, true);
        if (indexedPsiFile == null) {
            return null;
        }
        return indexedPsiFile.getEvaluator();
    }

    private static PsiElement getFunctionContext(Map<String, ?> additionalContext) {
        return ((FunctionContext)additionalContext.get("function_context")).getPosition();
    }

    @NotNull
    public Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable Map<String, ?> additionalContext, boolean enableBreak, @Nullable Project project) {
        if (expression == null) {
            ExpressionEvaluator.$$$reportNull$$$0(2);
        }
        PsiElement functionContext = ExpressionEvaluator.getFunctionContext(additionalContext);
        Promise promise = this.evaluateExpression(ExpressionEvaluationRequest.createObjectRequest(functionContext, expression)).then(result -> {
            if (expression == null) {
                ExpressionEvaluator.$$$reportNull$$$0(8);
            }
            return new EvaluateResult(new TraceValueManager(this, functionContext).createValue(expression, result.getValue()), false);
        });
        if (promise == null) {
            ExpressionEvaluator.$$$reportNull$$$0(3);
        }
        return promise;
    }

    @NotNull
    public EvaluateContext withValueManager(@NotNull String objectGroup) {
        if (objectGroup == null) {
            ExpressionEvaluator.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Promise<?> refreshOnDone(@NotNull Promise<?> promise) {
        if (promise == null) {
            ExpressionEvaluator.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    public void releaseObjects() {
    }

    @NotNull
    public EvaluateContext getEvaluateContext() {
        ExpressionEvaluator expressionEvaluator = this;
        if (expressionEvaluator == null) {
            ExpressionEvaluator.$$$reportNull$$$0(6);
        }
        return expressionEvaluator;
    }

    @Nullable
    public String getVariableName() {
        return null;
    }

    @Nullable
    public VariableContext getParent() {
        return null;
    }

    public boolean watchableAsEvaluationExpression() {
        return false;
    }

    @NotNull
    public DebuggerViewSupport getViewSupport() {
        MyDebuggerViewSupport myDebuggerViewSupport = new MyDebuggerViewSupport();
        if (myDebuggerViewSupport == null) {
            ExpressionEvaluator.$$$reportNull$$$0(7);
        }
        return myDebuggerViewSupport;
    }

    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Scope getScope() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/debugger/ExpressionEvaluator";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/debugger/ExpressionEvaluator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluateContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withValueManager";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshOnDone";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDebuggerViewSupport
    extends BasicDebuggerViewSupport {
        private static final List<String> LENGTH_AVAILABLE_TYPES = Collections.singletonList("Buffer");

        private MyDebuggerViewSupport() {
        }

        public void computeObjectPresentation(final @NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
            if (value == null) {
                MyDebuggerViewSupport.$$$reportNull$$$0(0);
            }
            if (variable == null) {
                MyDebuggerViewSupport.$$$reportNull$$$0(1);
            }
            if (context == null) {
                MyDebuggerViewSupport.$$$reportNull$$$0(2);
            }
            if (node == null) {
                MyDebuggerViewSupport.$$$reportNull$$$0(3);
            }
            if (icon == null) {
                MyDebuggerViewSupport.$$$reportNull$$$0(4);
            }
            if (LENGTH_AVAILABLE_TYPES.contains(value.getClassName()) && value instanceof TraceObjectWithLength) {
                node.setPresentation(icon, new XValuePresentation(){

                    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                        if (renderer == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        renderer.renderSpecialSymbol(value.getClassName() + "[");
                        renderer.renderSpecialSymbol(Integer.toString(((TraceObjectWithLength)value).getLength()));
                        renderer.renderSpecialSymbol("]");
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyDebuggerViewSupport$1", "renderValue"));
                    }
                }, value.hasProperties() != ThreeState.NO);
            } else {
                super.computeObjectPresentation(value, variable, context, node, value.getType() == ValueType.FUNCTION ? AllIcons.Nodes.Function : icon);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyDebuggerViewSupport";
            objectArray[2] = "computeObjectPresentation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FunctionContext {
        private final PsiElement myPosition;
        private static final String FUNCTION_CONTEXT = "function_context";

        private FunctionContext(PsiElement position) {
            this.myPosition = position;
        }

        public PsiElement getPosition() {
            return this.myPosition;
        }
    }

    static class MyEvaluator
    extends JavaScriptDebuggerEvaluator {
        private final ExpressionEvaluator expressionEvaluator;

        MyEvaluator(@NotNull ExpressionEvaluator expressionEvaluator) {
            if (expressionEvaluator == null) {
                MyEvaluator.$$$reportNull$$$0(0);
            }
            super((VariableContext)expressionEvaluator);
            this.expressionEvaluator = expressionEvaluator;
        }

        @NotNull
        protected Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable XSourcePosition expressionPosition) {
            if (expression == null) {
                MyEvaluator.$$$reportNull$$$0(1);
            }
            if (expressionPosition == null) {
                Promise promise = Promises.rejectedPromise((String)"No source position specified");
                if (promise == null) {
                    MyEvaluator.$$$reportNull$$$0(2);
                }
                return promise;
            }
            PsiElement elementAt = this.expressionEvaluator.myFile.getPsiFile().findElementAt(expressionPosition.getOffset());
            if (elementAt == null) {
                Promise promise = Promises.rejectedPromise((String)"No source position specified");
                if (promise == null) {
                    MyEvaluator.$$$reportNull$$$0(3);
                }
                return promise;
            }
            Promise<EvaluateResult> promise = this.expressionEvaluator.evaluate(expression, MyEvaluator.createFunctionContext(elementAt), false, null);
            if (promise == null) {
                MyEvaluator.$$$reportNull$$$0(4);
            }
            return promise;
        }

        private static Map<String, Object> createFunctionContext(@NotNull PsiElement position) {
            if (position == null) {
                MyEvaluator.$$$reportNull$$$0(5);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("function_context", new FunctionContext(position));
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionEvaluator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyEvaluator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/trace/debugger/ExpressionEvaluator$MyEvaluator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "evaluate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createFunctionContext";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

