/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger.values;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.debugger.TraceSessionEvaluator;
import com.intellij.javascript.trace.debugger.values.TraceArray;
import com.intellij.javascript.trace.debugger.values.TraceObject;
import com.intellij.javascript.trace.debugger.values.TraceString;
import com.intellij.javascript.trace.execution.common.PropertyMetadata;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationRequest;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationResult;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;

public class TraceValueManager
extends ValueManager {
    private final TraceSessionEvaluator myEvaluator;
    private final PsiElement myPosition;

    public TraceValueManager(TraceSessionEvaluator evaluator, PsiElement position) {
        this.myEvaluator = evaluator;
        this.myPosition = position;
    }

    public void loadProperties(@NotNull String expression, @NotNull AsyncPromise<List<Variable>> result) {
        if (expression == null) {
            TraceValueManager.$$$reportNull$$$0(0);
        }
        if (result == null) {
            TraceValueManager.$$$reportNull$$$0(1);
        }
        this.myEvaluator.evaluateExpression(ExpressionEvaluationRequest.createPropertiesRequest(this.myPosition, expression)).onSuccess(evaluationResult -> {
            if (result == null) {
                TraceValueManager.$$$reportNull$$$0(10);
            }
            if (expression == null) {
                TraceValueManager.$$$reportNull$$$0(11);
            }
            result.setResult((Object)ContainerUtil.map((Object[])evaluationResult.getProperties(), metadata -> {
                if (expression == null) {
                    TraceValueManager.$$$reportNull$$$0(12);
                }
                return new TraceVariable(expression, (PropertyMetadata)metadata);
            }));
        });
    }

    @NotNull
    public Promise<ExpressionEvaluationResult> getIndexedProperties(@NotNull String expression, int from, int to, int threshold, @NotNull IndexedVariablesConsumer consumer) {
        if (expression == null) {
            TraceValueManager.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            TraceValueManager.$$$reportNull$$$0(3);
        }
        Promise promise = this.myEvaluator.evaluateExpression(ExpressionEvaluationRequest.createPropertiesRequest(this.myPosition, expression, (Range<Integer>)new Range((Comparable)Integer.valueOf(from), (Comparable)Integer.valueOf(to)), threshold)).onSuccess(evaluationResult -> {
            if (consumer == null) {
                TraceValueManager.$$$reportNull$$$0(7);
            }
            if (expression == null) {
                TraceValueManager.$$$reportNull$$$0(8);
            }
            if (!consumer.isObsolete() && evaluationResult.getValue() != null) {
                int[] ranges = evaluationResult.getValue().getRanges();
                if (ranges.length > 0) {
                    consumer.consumeRanges(ranges);
                }
                consumer.consumeVariables(ContainerUtil.map((Object[])evaluationResult.getProperties(), metadata -> {
                    if (expression == null) {
                        TraceValueManager.$$$reportNull$$$0(9);
                    }
                    return new TraceVariable(expression, (PropertyMetadata)metadata);
                }));
            }
        });
        if (promise == null) {
            TraceValueManager.$$$reportNull$$$0(4);
        }
        return promise;
    }

    @NotNull
    public Promise<String> getFullString(@NotNull String expression) {
        if (expression == null) {
            TraceValueManager.$$$reportNull$$$0(5);
        }
        Promise promise = this.myEvaluator.evaluateExpression(ExpressionEvaluationRequest.createFullStringRequest(this.myPosition, expression)).then(result -> {
            PropertyMetadata value = result.getValue();
            return value == null ? TraceBundle.message("console.trace.evaluation.noFullStringValue", new Object[0]) : value.getPrimitiveValue();
        });
        if (promise == null) {
            TraceValueManager.$$$reportNull$$$0(6);
        }
        return promise;
    }

    public Value createValue(String expression, PropertyMetadata obj) {
        if (obj == null) {
            return new PrimitiveValue(ValueType.NULL, TraceBundle.message("console.trace.evaluation.noValue", new Object[0]));
        }
        String type = obj.getType();
        if (type.equals("Undefined")) {
            return PrimitiveValue.UNDEFINED;
        }
        if (type.equals("Null")) {
            return PrimitiveValue.NULL;
        }
        if (type.equals("Number")) {
            return new PrimitiveValue(ValueType.NUMBER, obj.getPrimitiveValue());
        }
        if (type.equals("Boolean")) {
            return new PrimitiveValue(ValueType.BOOLEAN, obj.getPrimitiveValue());
        }
        if (type.equals("String")) {
            return new TraceString(this, expression, obj.getLength(), obj.getPrimitiveValue());
        }
        if (type.equals("Array")) {
            return new TraceArray(this, expression, obj.getLength());
        }
        if (type.equals("Function")) {
            return new TraceObject(ValueType.OBJECT, this, expression, type, TraceValueManager.hasProperties(obj), obj.getParams() != null ? String.format(TraceBundle.message("console.trace.evaluation.function", new Object[0]), obj.getParams()) : type, obj.getLength());
        }
        return new TraceObject(ValueType.OBJECT, this, expression, type, TraceValueManager.hasProperties(obj), obj.getPrimitiveValue(), obj.getLength());
    }

    private static ThreeState hasProperties(PropertyMetadata obj) {
        return obj.isEmpty() ? ThreeState.NO : ThreeState.YES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/debugger/values/TraceValueManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/debugger/values/TraceValueManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadProperties";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedProperties";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFullString";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getIndexedProperties$3";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadProperties$1";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TraceVariable
    implements Variable {
        private final String myExpression;
        private final PropertyMetadata myMetadata;
        private final String myName;

        private TraceVariable(String expression, PropertyMetadata metadata) {
            this.myMetadata = metadata;
            this.myExpression = expression + "['" + metadata.getNormalizedName() + "']";
            this.myName = metadata.getName();
        }

        public boolean isReadable() {
            return true;
        }

        @Nullable
        public Value getValue() {
            return TraceValueManager.this.createValue(this.myExpression, this.myMetadata);
        }

        public void setValue(Value value) {
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                TraceVariable.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isMutable() {
            return false;
        }

        @Nullable
        public ValueModifier getValueModifier() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/values/TraceValueManager$TraceVariable", "getName"));
        }
    }
}

