/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.quickFixes;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreateFieldFix
extends QuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.quickFixes.CreateFieldFix");
    private final PsiClass myClass;
    private final String myFieldClassName;
    private final String myFieldName;

    public CreateFieldFix(GuiEditor editor, @NotNull PsiClass aClass, @NotNull String fieldClass, @NotNull String fieldName) {
        if (aClass == null) {
            CreateFieldFix.$$$reportNull$$$0(0);
        }
        if (fieldClass == null) {
            CreateFieldFix.$$$reportNull$$$0(1);
        }
        if (fieldName == null) {
            CreateFieldFix.$$$reportNull$$$0(2);
        }
        super(editor, UIDesignerBundle.message("action.create.field", fieldName), null);
        this.myClass = aClass;
        this.myFieldClassName = fieldClass;
        this.myFieldName = fieldName;
    }

    public static void runImpl(@NotNull Project project, @NotNull RadContainer rootContainer, @NotNull PsiClass boundClass, @NotNull String fieldClassName, @NotNull String fieldName, boolean showErrors, @Nullable Object undoGroupId) {
        PsiClass fieldClass;
        if (project == null) {
            CreateFieldFix.$$$reportNull$$$0(3);
        }
        if (rootContainer == null) {
            CreateFieldFix.$$$reportNull$$$0(4);
        }
        if (boundClass == null) {
            CreateFieldFix.$$$reportNull$$$0(5);
        }
        if (fieldClassName == null) {
            CreateFieldFix.$$$reportNull$$$0(6);
        }
        if (fieldName == null) {
            CreateFieldFix.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!boundClass.isValid()) {
            return;
        }
        if (!boundClass.isWritable()) {
            if (showErrors) {
                if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)boundClass, (Project)project, (String)UIDesignerBundle.message("error.cannot.create.field", fieldClassName))) {
                    return;
                }
            } else {
                return;
            }
        }
        if ((fieldClass = JavaPsiFacade.getInstance((Project)project).findClass(fieldClassName.replace('$', '.'), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)rootContainer.getModule()))) == null) {
            if (showErrors) {
                Messages.showErrorDialog((Project)project, (String)UIDesignerBundle.message("error.cannot.create.field.no.class", fieldName, fieldClassName), (String)CommonBundle.getErrorTitle());
            }
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                CreateFieldFix.$$$reportNull$$$0(8);
            }
            if (fieldName == null) {
                CreateFieldFix.$$$reportNull$$$0(9);
            }
            if (boundClass == null) {
                CreateFieldFix.$$$reportNull$$$0(10);
            }
            if (rootContainer == null) {
                CreateFieldFix.$$$reportNull$$$0(11);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    CreateFieldFix.$$$reportNull$$$0(12);
                }
                if (fieldName == null) {
                    CreateFieldFix.$$$reportNull$$$0(13);
                }
                if (boundClass == null) {
                    CreateFieldFix.$$$reportNull$$$0(14);
                }
                if (rootContainer == null) {
                    CreateFieldFix.$$$reportNull$$$0(15);
                }
                CreateFieldFix.createField(project, fieldClass, fieldName, boundClass, showErrors, rootContainer);
            });
        }, UIDesignerBundle.message("command.create.field", new Object[0]), undoGroupId);
    }

    private static void createField(Project project, PsiClass fieldClass, String fieldName, PsiClass boundClass, boolean showErrors, IContainer rootContainer) {
        block7: {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiClassType type = factory.createType(fieldClass);
            try {
                String[] modifiers;
                PsiField field = factory.createField(fieldName, (PsiType)type);
                String accessibility = GuiDesignerConfiguration.getInstance((Project)project).DEFAULT_FIELD_ACCESSIBILITY;
                PsiModifierList modifierList = field.getModifierList();
                assert (modifierList != null);
                for (String modifier : modifiers = new String[]{"private", "protected", "public"}) {
                    modifierList.setModifierProperty(modifier, accessibility.equals(modifier));
                }
                PsiField lastUiField = null;
                for (PsiField uiField : boundClass.getFields()) {
                    if (FormEditingUtil.findComponentWithBinding((IComponent)rootContainer, uiField.getName()) == null) continue;
                    lastUiField = uiField;
                }
                if (lastUiField != null) {
                    boundClass.addAfter((PsiElement)field, lastUiField);
                } else {
                    boundClass.add((PsiElement)field);
                }
            }
            catch (IncorrectOperationException exc) {
                if (!showErrors) break block7;
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)UIDesignerBundle.message("error.cannot.create.field.reason", fieldName, exc.getMessage()), (String)CommonBundle.getErrorTitle()));
            }
        }
    }

    @Override
    public void run() {
        CreateFieldFix.runImpl(this.myEditor.getProject(), this.myEditor.getRootContainer(), this.myClass, this.myFieldClassName, this.myFieldName, true, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldClass";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootContainer";
                break;
            }
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldClassName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/quickFixes/CreateFieldFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runImpl$1";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

