/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.openapi.application.Application;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;

public class OsmorcFacetRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    private final Application myApplication;

    public OsmorcFacetRefactoringListenerProvider(Application application) {
        this.myApplication = application;
    }

    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        OsmorcFacet osmorcFacet;
        if (element instanceof PsiClass && (osmorcFacet = OsmorcFacet.getInstance(element)) != null) {
            OsmorcFacetConfiguration osmorcFacetConfiguration = (OsmorcFacetConfiguration)osmorcFacet.getConfiguration();
            PsiClass psiClass = (PsiClass)element;
            if (osmorcFacetConfiguration.isOsmorcControlsManifest() && osmorcFacetConfiguration.getBundleActivator() != null && osmorcFacetConfiguration.getBundleActivator().equals(psiClass.getQualifiedName())) {
                return new ActivatorClassRefactoringListener(osmorcFacetConfiguration, this.myApplication);
            }
        }
        return null;
    }

    private static final class ActivatorClassRefactoringListener
    extends RefactoringElementAdapter {
        private final OsmorcFacetConfiguration osmorcFacetConfiguration;
        private final Application application;

        private ActivatorClassRefactoringListener(OsmorcFacetConfiguration osmorcFacetConfiguration, Application application) {
            this.osmorcFacetConfiguration = osmorcFacetConfiguration;
            this.application = application;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                ActivatorClassRefactoringListener.$$$reportNull$$$0(0);
            }
            this.application.runWriteAction(() -> {
                if (newElement == null) {
                    ActivatorClassRefactoringListener.$$$reportNull$$$0(4);
                }
                this.osmorcFacetConfiguration.setBundleActivator(((PsiClass)newElement).getQualifiedName());
            });
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                ActivatorClassRefactoringListener.$$$reportNull$$$0(1);
            }
            if (oldQualifiedName == null) {
                ActivatorClassRefactoringListener.$$$reportNull$$$0(2);
            }
            this.application.runWriteAction(() -> {
                if (oldQualifiedName == null) {
                    ActivatorClassRefactoringListener.$$$reportNull$$$0(3);
                }
                this.osmorcFacetConfiguration.setBundleActivator(oldQualifiedName);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldQualifiedName";
                    break;
                }
            }
            objectArray2[1] = "org/osmorc/facet/OsmorcFacetRefactoringListenerProvider$ActivatorClassRefactoringListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementRenamedOrMoved";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "undoElementMovedOrRenamed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$undoElementMovedOrRenamed$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$elementRenamedOrMoved$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

