/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.AbstractTableCellEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class FileSelectorTableCellEditor
extends AbstractTableCellEditor {
    private final TextFieldWithBrowseButton editor;

    public FileSelectorTableCellEditor(final Project project, final Module module) {
        this.editor = new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
                descriptor.setTitle("Choose source file or folder");
                VirtualFile rootFolder = null;
                VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
                if (contentRoots.length > 0) {
                    rootFolder = contentRoots[0];
                } else if (project.getBaseDir() != null) {
                    rootFolder = project.getBaseDir();
                }
                VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)rootFolder);
                if (files.length > 0) {
                    FileSelectorTableCellEditor.this.editor.setText(files[0].getPath());
                }
            }
        });
    }

    public Object getCellEditorValue() {
        return this.editor.getText();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        TableCellRenderer renderer = table.getCellRenderer(row, column);
        Component c = renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
        if (c != null && c instanceof JComponent) {
            this.editor.getTextField().setBorder(((JComponent)c).getBorder());
        }
        this.editor.setText(value.toString());
        return this.editor;
    }
}

