/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.frameworkintegration.FrameworkRunner;
import org.osmorc.frameworkintegration.impl.GenericRunProperties;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.ui.SelectedBundle;

public abstract class AbstractFrameworkRunner
implements FrameworkRunner {
    protected OsgiRunConfiguration myRunConfiguration;
    protected FrameworkInstanceDefinition myInstance;
    protected FrameworkIntegrator myIntegrator;
    protected FrameworkInstanceManager myInstanceManager;
    protected Map<String, String> myAdditionalProperties;
    protected List<SelectedBundle> myBundles;
    private File myWorkingDir;

    @Override
    public JavaParameters createJavaParameters(@NotNull OsgiRunConfiguration runConfiguration, @NotNull List<SelectedBundle> bundles) throws ExecutionException {
        String systemPackages;
        String bootDelegation;
        String path;
        if (runConfiguration == null) {
            AbstractFrameworkRunner.$$$reportNull$$$0(0);
        }
        if (bundles == null) {
            AbstractFrameworkRunner.$$$reportNull$$$0(1);
        }
        this.myRunConfiguration = runConfiguration;
        this.myInstance = this.myRunConfiguration.getInstanceToUse();
        assert (this.myInstance != null) : this.myRunConfiguration;
        this.myIntegrator = FrameworkIntegratorRegistry.getInstance().findIntegratorByInstanceDefinition(this.myInstance);
        assert (this.myIntegrator != null) : this.myInstance;
        this.myInstanceManager = this.myIntegrator.getFrameworkInstanceManager();
        this.myAdditionalProperties = this.myRunConfiguration.getAdditionalProperties();
        this.myBundles = bundles;
        JavaParameters params = new JavaParameters();
        this.myWorkingDir = this.myRunConfiguration.isGenerateWorkingDir() ? new File(PathManager.getSystemPath(), "osmorc/run." + System.currentTimeMillis()) : new File(this.myRunConfiguration.getWorkingDir());
        if (!this.myWorkingDir.isDirectory() && !this.myWorkingDir.mkdirs()) {
            throw new CantRunException("Cannot create work directory '" + this.myWorkingDir.getPath() + "'");
        }
        params.setWorkingDirectory(this.myWorkingDir);
        String jreHome = this.myRunConfiguration.isUseAlternativeJre() ? this.myRunConfiguration.getAlternativeJrePath() : null;
        JavaParametersUtil.configureProject((Project)this.myRunConfiguration.getProject(), (JavaParameters)params, (int)1, (String)jreHome);
        Collection<SelectedBundle> systemBundles = this.myInstanceManager.getFrameworkBundles(this.myInstance, FrameworkInstanceManager.FrameworkBundleType.SYSTEM);
        if (systemBundles.isEmpty()) {
            throw new CantRunException("Libraries required to start the framework not found - please check the installation");
        }
        for (SelectedBundle bundle : systemBundles) {
            path = bundle.getBundlePath();
            assert (path != null) : bundle;
            params.getClassPath().add(path);
        }
        if (GenericRunProperties.isStartConsole(this.myAdditionalProperties)) {
            Collection<SelectedBundle> shellBundles = this.myInstanceManager.getFrameworkBundles(this.myInstance, FrameworkInstanceManager.FrameworkBundleType.SHELL);
            if (shellBundles.isEmpty()) {
                throw new CantRunException("Console requested but no shell bundles can be found - please check the installation");
            }
            ArrayList allBundles = ContainerUtil.newArrayList((Iterable)shellBundles);
            allBundles.addAll(this.myBundles);
            this.myBundles = allBundles;
        }
        if (this.myRunConfiguration.isIncludeAllBundlesInClassPath()) {
            for (SelectedBundle bundle : this.myBundles) {
                path = bundle.getBundlePath();
                if (path == null) continue;
                params.getClassPath().add(path);
            }
        }
        params.setUseDynamicVMOptions(!this.myBundles.isEmpty());
        params.setUseDynamicParameters(!this.myBundles.isEmpty());
        HttpConfigurable.getInstance().getJvmProperties(false, null).forEach(p -> params.getVMParametersList().addProperty((String)p.first, (String)p.second));
        params.getVMParametersList().addParametersString(this.myRunConfiguration.getVmParameters());
        String additionalProgramParams = this.myRunConfiguration.getProgramParameters();
        if (!StringUtil.isEmptyOrSpaces((String)additionalProgramParams)) {
            params.getProgramParametersList().addParametersString(additionalProgramParams);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(bootDelegation = GenericRunProperties.getBootDelegation(this.myAdditionalProperties)))) {
            params.getVMParametersList().addProperty("org.osgi.framework.bootdelegation", bootDelegation);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(systemPackages = GenericRunProperties.getSystemPackages(this.myAdditionalProperties)))) {
            params.getVMParametersList().addProperty("org.osgi.framework.system.packages.extra", systemPackages);
        }
        this.setupParameters(params);
        return params;
    }

    protected abstract void setupParameters(@NotNull JavaParameters var1);

    protected int getBundleStartLevel(@NotNull SelectedBundle bundle) {
        if (bundle == null) {
            AbstractFrameworkRunner.$$$reportNull$$$0(2);
        }
        return bundle.isDefaultStartLevel() ? this.myRunConfiguration.getDefaultStartLevel() : bundle.getStartLevel();
    }

    protected int getFrameworkStartLevel() {
        if (this.myRunConfiguration.isAutoStartLevel()) {
            int startLevel = 0;
            for (SelectedBundle bundle : this.myBundles) {
                int bundleStartLevel = this.getBundleStartLevel(bundle);
                startLevel = Math.max(bundleStartLevel, startLevel);
            }
            return startLevel;
        }
        return this.myRunConfiguration.getFrameworkStartLevel();
    }

    public void dispose() {
        if (this.myRunConfiguration.isGenerateWorkingDir() && this.myWorkingDir != null) {
            FileUtil.asyncDelete((File)this.myWorkingDir);
        }
    }

    @NotNull
    protected String toFileUri(@NotNull String path) {
        if (path == null) {
            AbstractFrameworkRunner.$$$reportNull$$$0(3);
        }
        String string = new File(path).toURI().toString();
        if (string == null) {
            AbstractFrameworkRunner.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/frameworkintegration/impl/AbstractFrameworkRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/frameworkintegration/impl/AbstractFrameworkRunner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createJavaParameters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBundleStartLevel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toFileUri";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

