/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.osgi.project.BundleManifest;
import org.jetbrains.osgi.project.BundleManifestCache;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.inspection.AbstractOsgiQuickFix;
import org.osmorc.inspection.AbstractOsgiVisitor;
import org.osmorc.util.OsgiPsiUtil;

public class UnregisteredActivatorInspection
extends AbstractOsgiVisitor {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final OsmorcFacet facet, final ProblemsHolder holder, boolean isOnTheFly) {
        if (!(holder.getFile() instanceof PsiClassOwner)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UnregisteredActivatorInspection.$$$reportNull$$$0(0);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitFile(PsiFile file) {
                if (file instanceof PsiClassOwner) {
                    for (PsiClass psiClass : ((PsiClassOwner)file).getClasses()) {
                        BundleManifest manifest;
                        String className = psiClass.getQualifiedName();
                        if (!OsgiPsiUtil.isActivator((PsiElement)psiClass) || className == null || (manifest = BundleManifestCache.getInstance(psiClass.getProject()).getManifest(facet.getModule())) == null || className.equals(manifest.getBundleActivator())) continue;
                        LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)facet.getConfiguration();
                        if (configuration.isManifestManuallyEdited()) {
                            fixes = new LocalQuickFix[]{new RegisterInManifestQuickfix(className)};
                        } else if (configuration.isOsmorcControlsManifest()) {
                            fixes = new LocalQuickFix[]{new RegisterInConfigurationQuickfix(className, configuration)};
                        }
                        PsiElement identifier = AbstractOsgiVisitor.unwrap((PsiElement)psiClass.getNameIdentifier());
                        if (!UnregisteredActivatorInspection.this.isValidElement(identifier)) continue;
                        holder.registerProblem(identifier, OsmorcBundle.message("UnregisteredActivatorInspection.message", new Object[0]), fixes);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            UnregisteredActivatorInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/inspection/UnregisteredActivatorInspection", "buildVisitor"));
    }

    private static class RegisterInConfigurationQuickfix
    extends AbstractOsgiQuickFix {
        private final String myActivatorClass;
        private final OsmorcFacetConfiguration myConfiguration;

        private RegisterInConfigurationQuickfix(@NotNull String activatorClass, @NotNull OsmorcFacetConfiguration configuration) {
            if (activatorClass == null) {
                RegisterInConfigurationQuickfix.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                RegisterInConfigurationQuickfix.$$$reportNull$$$0(1);
            }
            this.myActivatorClass = activatorClass;
            this.myConfiguration = configuration;
        }

        @NotNull
        public String getName() {
            String string = OsmorcBundle.message("UnregisteredActivatorInspection.fix.config", new Object[0]);
            if (string == null) {
                RegisterInConfigurationQuickfix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RegisterInConfigurationQuickfix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                RegisterInConfigurationQuickfix.$$$reportNull$$$0(4);
            }
            this.myConfiguration.setBundleActivator(this.myActivatorClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activatorClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInConfigurationQuickfix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInConfigurationQuickfix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RegisterInManifestQuickfix
    extends AbstractOsgiQuickFix {
        private final String myActivatorClass;

        private RegisterInManifestQuickfix(@NotNull String activatorClass) {
            if (activatorClass == null) {
                RegisterInManifestQuickfix.$$$reportNull$$$0(0);
            }
            this.myActivatorClass = activatorClass;
        }

        @NotNull
        public String getName() {
            String string = OsmorcBundle.message("UnregisteredActivatorInspection.fix.manifest", new Object[0]);
            if (string == null) {
                RegisterInManifestQuickfix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            ManifestFile manifestFile;
            if (project == null) {
                RegisterInManifestQuickfix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RegisterInManifestQuickfix.$$$reportNull$$$0(3);
            }
            if ((manifestFile = this.getVerifiedManifestFile(descriptor.getEndElement())) != null) {
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{manifestFile}).run(() -> OsgiPsiUtil.setHeader(manifestFile, "Bundle-Activator", this.myActivatorClass));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activatorClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInManifestQuickfix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInManifestQuickfix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

