/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.header;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.osmorc.manifest.lang.header.OsgiHeaderParser;
import org.osmorc.manifest.lang.psi.Clause;
import org.osmorc.util.OsgiPsiUtil;

public class BasePackageParser
extends OsgiHeaderParser {
    public static final HeaderParser INSTANCE = new BasePackageParser();

    @NotNull
    public PsiReference[] getReferences(@NotNull HeaderValuePart headerValuePart) {
        if (headerValuePart == null) {
            BasePackageParser.$$$reportNull$$$0(0);
        }
        PsiReference[] psiReferenceArray = headerValuePart.getParent() instanceof Clause ? BasePackageParser.getPackageReferences((PsiElement)headerValuePart) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            BasePackageParser.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        if (header == null) {
            BasePackageParser.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            BasePackageParser.$$$reportNull$$$0(3);
        }
        boolean annotated = false;
        for (HeaderValue value : header.getHeaderValues()) {
            HeaderValuePart valuePart;
            if (!(value instanceof Clause) || (valuePart = ((Clause)value).getValue()) == null) continue;
            String packageName = valuePart.getUnwrappedText();
            if (StringUtil.isEmptyOrSpaces((String)(packageName = StringUtil.trimEnd((String)packageName, (String)".*")))) {
                holder.createErrorAnnotation(valuePart.getHighlightingRange(), ManifestBundle.message((String)"header.reference.invalid", (Object[])new Object[0]));
                annotated = true;
                continue;
            }
            PsiDirectory[] directories = OsgiPsiUtil.resolvePackage((PsiElement)header, packageName);
            if (directories.length != 0) continue;
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), JavaErrorMessages.message((String)"cannot.resolve.package", (Object[])new Object[]{packageName}));
            annotated = true;
        }
        return annotated;
    }

    @Nullable
    public Object getConvertedValue(@NotNull Header header) {
        List headerValues;
        if (header == null) {
            BasePackageParser.$$$reportNull$$$0(4);
        }
        if (!(headerValues = header.getHeaderValues()).isEmpty()) {
            ArrayList packages = ContainerUtil.newArrayListWithCapacity((int)headerValues.size());
            for (HeaderValue headerValue : headerValues) {
                HeaderValuePart valuePart = ((Clause)headerValue).getValue();
                if (valuePart == null) continue;
                packages.add(valuePart.getText().replaceAll("\\s+", ""));
            }
            return packages;
        }
        return null;
    }

    protected static PsiReference[] getPackageReferences(PsiElement psiElement) {
        int size;
        String packageName = psiElement.getText();
        if (StringUtil.isEmptyOrSpaces((String)packageName)) {
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = 0;
        if (packageName.charAt(0) == '!') {
            packageName = packageName.substring(1);
            offset = 1;
        }
        if (packageName.charAt(size = packageName.length() - 1) == '?') {
            packageName = packageName.substring(0, size);
        }
        PackageReferenceSet refSet = new PackageReferenceSet(packageName, psiElement, offset){

            public Collection<PsiPackage> resolvePackageName(@Nullable PsiPackage context, String packageName) {
                if (context == null) {
                    return Collections.emptyList();
                }
                String unwrappedPackageName = packageName.replaceAll("\\s+", "");
                return ContainerUtil.filter((Object[])context.getSubPackages(), pkg -> unwrappedPackageName.equals(pkg.getName()));
            }
        };
        return (PsiReference[])refSet.getReferences().toArray(new PsiPackageReference[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValuePart";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/manifest/lang/header/BasePackageParser";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/manifest/lang/header/BasePackageParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

