/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.maven.facet;

import aQute.bnd.osgi.Analyzer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.osmorc.maven.facet.ImporterUtil;

public class ResourceCollector {
    private static final String MAVEN_RESOURCES = "{maven-resources}";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};

    public static void includeMavenResources(@NotNull MavenProject mavenProject, @NotNull Analyzer analyzer) {
        String includeResource;
        if (mavenProject == null) {
            ResourceCollector.$$$reportNull$$$0(0);
        }
        if (analyzer == null) {
            ResourceCollector.$$$reportNull$$$0(1);
        }
        if ((includeResource = analyzer.getProperty("Include-Resource")) != null) {
            if (includeResource.contains(MAVEN_RESOURCES)) {
                String mavenResourcePaths = ResourceCollector.getMavenResourcePaths(mavenProject);
                if (mavenResourcePaths.length() == 0) {
                    String cleanedResource = ImporterUtil.removeTagFromInstruction(includeResource, MAVEN_RESOURCES);
                    if (cleanedResource.length() > 0) {
                        analyzer.setProperty("Include-Resource", cleanedResource);
                    } else {
                        analyzer.unsetProperty("Include-Resource");
                    }
                } else {
                    String combinedResource = StringUtil.replace((String)includeResource, (String)MAVEN_RESOURCES, (String)mavenResourcePaths);
                    analyzer.setProperty("Include-Resource", combinedResource);
                }
            }
        } else {
            String mavenResourcePaths = ResourceCollector.getMavenResourcePaths(mavenProject);
            if (mavenResourcePaths.length() > 0) {
                analyzer.setProperty("Include-Resource", mavenResourcePaths);
            }
        }
    }

    private static String getMavenResourcePaths(@NotNull MavenProject currentProject) {
        if (currentProject == null) {
            ResourceCollector.$$$reportNull$$$0(2);
        }
        LinkedHashSet<String> pathSet = new LinkedHashSet<String>();
        for (MavenResource resource : ResourceCollector.getMavenResources(currentProject)) {
            String sourcePath = resource.getDirectory();
            String targetPath = resource.getTargetPath();
            if (!new File(sourcePath).exists() || targetPath != null && targetPath.contains("..")) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(sourcePath);
            if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                scanner.setIncludes(ArrayUtil.toStringArray((Collection)resource.getIncludes()));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES);
            }
            if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                scanner.setExcludes(ArrayUtil.toStringArray((Collection)resource.getExcludes()));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            Iterator<String> iterator = includedFiles.iterator();
            while (iterator.hasNext()) {
                String includedFile;
                String name = includedFile = iterator.next();
                String path = sourcePath + '/' + name;
                if (File.separatorChar != '/') {
                    name = name.replace(File.separatorChar, '/');
                    path = path.replace(File.separatorChar, '/');
                }
                path = name + '=' + path;
                if (targetPath != null) {
                    path = targetPath + '/' + path;
                }
                if (resource.isFiltered()) {
                    path = '{' + path + '}';
                }
                pathSet.add(path);
            }
        }
        StringBuilder resourcePaths = new StringBuilder();
        Iterator i = pathSet.iterator();
        while (i.hasNext()) {
            resourcePaths.append((String)i.next());
            if (!i.hasNext()) continue;
            resourcePaths.append(',');
        }
        return resourcePaths.toString();
    }

    private static List<MavenResource> getMavenResources(MavenProject currentProject) {
        ArrayList<MavenResource> resources = new ArrayList<MavenResource>(currentProject.getResources());
        List<String> packageInfoIncludes = Collections.singletonList("**/packageinfo");
        for (String sourceRoot : currentProject.getSources()) {
            MavenResource packageInfoResource = new MavenResource(sourceRoot, false, null, packageInfoIncludes, null);
            resources.add(packageInfoResource);
        }
        return resources;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProject";
                break;
            }
        }
        objectArray2[1] = "org/osmorc/maven/facet/ResourceCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "includeMavenResources";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMavenResourcePaths";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

