/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.lang.UrlClassLoader;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.tooling.internal.consumer.ConnectorServices;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.loader.CachingToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.SynchronizedToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonStatusAction;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonStopAction;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;

@ApiStatus.Experimental
public class GradleDaemonServices
implements GroovyObject {
    private static final Logger LOG;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GradleDaemonServices() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void stopDaemons() {
        Map<ClassPath, ConsumerConnection> connections = GradleDaemonServices.getConnections();
        ConsumerConnection conn = null;
        Iterator<ConsumerConnection> iterator = connections.values().iterator();
        while (iterator.hasNext()) {
            conn = (ConsumerConnection)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ConsumerConnection.class);
            GradleDaemonServices.runAction(conn, DaemonStopAction.class, null);
        }
    }

    public static void stopDaemons(List<DaemonState> daemons) {
        Reference tokens = new Reference(new ArrayList());
        public class _stopDaemons_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tokens;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _stopDaemons_closure1(Object _outerInstance, Object _thisObject, Reference tokens) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.tokens = reference = tokens;
            }

            public Object doCall(Object it) {
                if (DefaultTypeTransformation.booleanUnbox((Object)((DaemonState)it).getToken())) {
                    return ((ArrayList)this.tokens.get()).add(((DaemonState)it).getToken());
                }
                return null;
            }

            public List getTokens() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.tokens.get(), List.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _stopDaemons_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(daemons, (Closure)new _stopDaemons_closure1(GradleDaemonServices.class, GradleDaemonServices.class, tokens));
        Map<ClassPath, ConsumerConnection> connections = GradleDaemonServices.getConnections();
        ConsumerConnection conn = null;
        Iterator<ConsumerConnection> iterator = connections.values().iterator();
        while (iterator.hasNext()) {
            conn = (ConsumerConnection)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ConsumerConnection.class);
            GradleDaemonServices.runAction(conn, DaemonStopAction.class, (ArrayList)tokens.get());
        }
    }

    public static List<DaemonState> getDaemonsStatus() {
        ArrayList<DaemonState> result = new ArrayList<DaemonState>();
        Map<ClassPath, ConsumerConnection> connections = GradleDaemonServices.getConnections();
        ConsumerConnection conn = null;
        Iterator<ConsumerConnection> iterator = connections.values().iterator();
        while (iterator.hasNext()) {
            conn = (ConsumerConnection)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ConsumerConnection.class);
            List daemonStates = (List)ScriptBytecodeAdapter.asType((Object)GradleDaemonServices.runAction(conn, DaemonStatusAction.class, null), List.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)daemonStates)) continue;
            result.addAll(daemonStates);
        }
        return result;
    }

    private static Object runAction(Object daemonClientFactory, ConsumerConnection connection, Class actionClass, Object arg) {
        UrlClassLoader daemonClientClassLoader = UrlClassLoader.build().urls(new URL[]{new File(PathManager.getJarPathForClass((Class)actionClass)).toURI().toURL()}).parent(daemonClientFactory.getClass().getClassLoader()).allowLock(false).get();
        String serviceDirectoryPath = GradleSystemSettings.getInstance().getServiceDirectoryPath();
        byte[] myRawArgData = GradleDaemonServices.getSerialized(arg);
        byte[] myRawResultData = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)daemonClientClassLoader);
            Class clazz = daemonClientClassLoader.loadClass(actionClass.getName());
            Object _arg = GradleDaemonServices.getObject(myRawArgData);
            Method method = GradleDaemonServices.findMethod(clazz, daemonClientFactory, _arg);
            Object[] serviceDirParam = new Object[]{serviceDirectoryPath};
            Object result = arg == null ? method.invoke(DefaultGroovyMethods.newInstance((Class)clazz, (Object[])serviceDirParam), daemonClientFactory) : method.invoke(DefaultGroovyMethods.newInstance((Class)clazz, (Object[])serviceDirParam), daemonClientFactory, _arg);
            if (result instanceof Serializable) {
                byte[] byArray;
                myRawResultData = byArray = GradleDaemonServices.getSerialized(result);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        if (myRawResultData != null) {
            return GradleDaemonServices.getObject(myRawResultData);
        }
        return null;
    }

    private static Method findMethod(Class<?> clazz, Object daemonClientFactory, Object arg) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)arg)) {
            return clazz.getMethod("run", daemonClientFactory.getClass());
        }
        Method method = null;
        try {
            Method method2;
            method = method2 = clazz.getMethod("run", daemonClientFactory.getClass(), arg.getClass());
        }
        catch (Exception ignore) {
        }
        if (method == null) {
            Class<?>[] interfaces = arg.getClass().getInterfaces();
            Class<?> cl = null;
            Class<?>[] classArray = interfaces;
            if (interfaces != null) {
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method3;
                    cl = classArray[n2];
                    ++n2;
                    method = method3 = clazz.getMethod("run", daemonClientFactory.getClass(), cl);
                    try {
                        break;
                    }
                    catch (Exception ignore) {
                    }
                }
            }
        }
        return method;
    }

    private static byte[] getSerialized(Object obj) {
        if (obj instanceof Serializable) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try (ObjectOutputStream oOut = new ObjectOutputStream(bOut);){
                oOut.writeObject(obj);
                byte[] byArray = bOut.toByteArray();
                return byArray;
            }
        }
        return (byte[])ScriptBytecodeAdapter.castToType(null, byte[].class);
    }

    private static Object getObject(byte ... bytes) {
        if (bytes != null) {
            ObjectInputStream objectInputStream;
            ObjectInputStream oIn = null;
            oIn = objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = oIn.readObject();
            StreamUtil.closeStream((Closeable)oIn);
            try {
                return object;
            }
            catch (Exception ignore) {
            }
            finally {
                StreamUtil.closeStream(oIn);
            }
        }
        return null;
    }

    private static Map<ClassPath, ConsumerConnection> getConnections() {
        CallSite[] callSiteArray = GradleDaemonServices.$getCallSiteArray();
        Object registry = callSiteArray[0].callGetProperty(ConnectorServices.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(registry))) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(Collections.class), Map.class);
        }
        SynchronizedToolingImplementationLoader loader = (SynchronizedToolingImplementationLoader)ScriptBytecodeAdapter.asType((Object)callSiteArray[3].call(registry, ToolingImplementationLoader.class), SynchronizedToolingImplementationLoader.class);
        CachingToolingImplementationLoader delegate = (CachingToolingImplementationLoader)ScriptBytecodeAdapter.asType((Object)callSiteArray[4].callGetProperty((Object)loader), CachingToolingImplementationLoader.class);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callGetProperty((Object)delegate), Map.class);
    }

    private static Object runAction(ConsumerConnection connection, Object actionClass, Object arg) {
        CallSite[] callSiteArray = GradleDaemonServices.$getCallSiteArray();
        Object daemonClientFactory = callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty(callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty((Object)connection))));
        Object object = callSiteArray[10].callStatic(GradleDaemonServices.class, daemonClientFactory, (Object)connection, actionClass, arg);
        try {
            return object;
        }
        catch (Throwable t) {
            block8: {
                callSiteArray[11].call((Object)LOG, callSiteArray[12].call((Object)"Unable to send daemon message for ", callSiteArray[13].call((Object)connection)));
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call((Object)LOG))) break block8;
                Object object2 = callSiteArray[15].call((Object)LOG, (Object)t);
                return object2;
            }
            Object object3 = callSiteArray[16].call((Object)LOG, callSiteArray[17].call(ExceptionUtil.class, callSiteArray[18].call(ExceptionUtil.class, (Object)t), (Object)"Unable to send daemon message"));
            return object3;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GradleDaemonServices.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        LOG = logger = Logger.getInstance(GradleDaemonServices.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "singletonRegistry";
        stringArray[1] = "closed";
        stringArray[2] = "emptyMap";
        stringArray[3] = "get";
        stringArray[4] = "delegate";
        stringArray[5] = "connections";
        stringArray[6] = "daemonClientFactory";
        stringArray[7] = "connection";
        stringArray[8] = "delegate";
        stringArray[9] = "delegate";
        stringArray[10] = "runAction";
        stringArray[11] = "warn";
        stringArray[12] = "plus";
        stringArray[13] = "getDisplayName";
        stringArray[14] = "isDebugEnabled";
        stringArray[15] = "debug";
        stringArray[16] = "warn";
        stringArray[17] = "getNonEmptyMessage";
        stringArray[18] = "getRootCause";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[19];
        GradleDaemonServices.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GradleDaemonServices.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GradleDaemonServices.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

