/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathField;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.ui.TextAccessor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleArgumentsCompletionProvider;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunTaskDialog
extends DialogWrapper {
    private final Project myProject;
    @Nullable
    private final Collection<String> myHistory;
    private JPanel contentPane;
    private ExternalProjectPathField myProjectPathField;
    private JPanel commandLinePanel;
    private JLabel commandLineLabel;
    private JPanel projectPathFieldPanel;
    private ComboBox commandLineComboBox;
    private EditorTextField commandLineEditor;

    public GradleRunTaskDialog(@NotNull Project project) {
        if (project == null) {
            GradleRunTaskDialog.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public GradleRunTaskDialog(@NotNull Project project, @Nullable Collection<String> history) {
        if (project == null) {
            GradleRunTaskDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myProject = project;
        this.myHistory = history;
        this.$$$setupUI$$$();
        this.setTitle("Run Gradle Task");
        this.setUpDialog();
        this.setModal(true);
        this.init();
    }

    private void setUpDialog() {
        ComboBox commandLineComponent;
        if (this.myHistory == null) {
            this.commandLineEditor = new EditorTextField("", this.myProject, (FileType)PlainTextFileType.INSTANCE);
            commandLineComponent = this.commandLineEditor;
            this.commandLineLabel.setLabelFor((Component)this.commandLineEditor);
        } else {
            commandLineComponent = this.commandLineComboBox = new ComboBox((Object[])ArrayUtilRt.toStringArray(this.myHistory));
            this.commandLineLabel.setLabelFor((Component)this.commandLineComboBox);
            this.commandLineComboBox.setLightWeightPopupEnabled(false);
            StringComboboxEditor editor = new StringComboboxEditor(this.myProject, (FileType)PlainTextFileType.INSTANCE, this.commandLineComboBox);
            this.commandLineComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)editor));
            this.commandLineComboBox.setEditable(true);
            this.commandLineComboBox.setEditor((ComboBoxEditor)editor);
            this.commandLineComboBox.setFocusable(true);
            this.commandLineEditor = editor.getEditorComponent();
        }
        this.commandLinePanel.add((Component)commandLineComponent);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        FileChooserDescriptor projectPathChooserDescriptor = null;
        if (manager instanceof ExternalSystemUiAware) {
            projectPathChooserDescriptor = ((ExternalSystemUiAware)manager).getExternalProjectConfigDescriptor();
        }
        if (projectPathChooserDescriptor == null) {
            projectPathChooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        }
        String title = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{GradleConstants.SYSTEM_ID.getReadableName()});
        this.myProjectPathField = new ExternalProjectPathField(this.myProject, GradleConstants.SYSTEM_ID, projectPathChooserDescriptor, title){

            public Dimension getPreferredSize() {
                return GradleRunTaskDialog.this.commandLinePanel == null ? super.getPreferredSize() : GradleRunTaskDialog.this.commandLinePanel.getPreferredSize();
            }
        };
        this.projectPathFieldPanel.add((Component)this.myProjectPathField);
        new GradleArgumentsCompletionProvider(this.myProject, (TextAccessor)this.myProjectPathField).apply(this.commandLineEditor);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myProjectPathField.getText().trim().isEmpty()) {
            return new ValidationInfo("Working directory is empty", (JComponent)this.myProjectPathField);
        }
        return null;
    }

    @NotNull
    public String getCommandLine() {
        if (this.commandLineComboBox != null) {
            String string = (String)this.commandLineComboBox.getEditor().getItem();
            if (string == null) {
                GradleRunTaskDialog.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.commandLineEditor.getText();
        if (string == null) {
            GradleRunTaskDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setCommandLine(@NotNull String fullCommandLine) {
        if (fullCommandLine == null) {
            GradleRunTaskDialog.$$$reportNull$$$0(4);
        }
        if (this.commandLineComboBox != null) {
            this.commandLineComboBox.setSelectedItem((Object)fullCommandLine);
        }
        this.commandLineEditor.setText(fullCommandLine);
    }

    @NotNull
    public String getWorkDirectory() {
        String string = this.myProjectPathField.getText();
        if (string == null) {
            GradleRunTaskDialog.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setWorkDirectory(@NotNull String path) {
        if (path == null) {
            GradleRunTaskDialog.$$$reportNull$$$0(6);
        }
        this.myProjectPathField.setText(path);
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.commandLineComboBox;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/task/GradleRunTaskDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullCommandLine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/task/GradleRunTaskDialog";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setWorkDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel;
        JPanel jPanel3;
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, "North");
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Gradle project");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.commandLineLabel = jLabel = new JLabel();
        jLabel.setText("Command line");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.projectPathFieldPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.commandLinePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(600, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

