/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class CoverageOptions
implements Serializable {
    private final boolean m_excludeEmptyClasses;
    private final boolean m_excludeSyntheticMethods;
    private final boolean m_excludeBridgeMethods;
    private final boolean m_doSUIDCompensation;

    public boolean excludeEmptyClasses() {
        return this.m_excludeEmptyClasses;
    }

    public boolean excludeSyntheticMethods() {
        return this.m_excludeSyntheticMethods;
    }

    public boolean excludeBridgeMethods() {
        return this.m_excludeBridgeMethods;
    }

    public boolean doSUIDCompensation() {
        return this.m_doSUIDCompensation;
    }

    CoverageOptions(boolean excludeEmptyClasses, boolean excludeSyntheticMethods, boolean excludeBridgeMethods, boolean doSUIDCompensation) {
        this.m_excludeEmptyClasses = excludeEmptyClasses;
        this.m_excludeSyntheticMethods = excludeSyntheticMethods;
        this.m_excludeBridgeMethods = excludeBridgeMethods;
        this.m_doSUIDCompensation = doSUIDCompensation;
    }

    static CoverageOptions readExternal(DataInput in) throws IOException {
        return new CoverageOptions(in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean());
    }

    static void writeExternal(CoverageOptions options, DataOutput out) throws IOException {
        out.writeBoolean(options.m_excludeEmptyClasses);
        out.writeBoolean(options.m_excludeSyntheticMethods);
        out.writeBoolean(options.m_excludeBridgeMethods);
        out.writeBoolean(options.m_doSUIDCompensation);
    }
}

