/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;

public class PluginBuildUtil {
    private PluginBuildUtil() {
    }

    @NonNls
    @Nullable
    public static String getPluginExPath(Module module) {
        Sdk jdk = IdeaJdk.findIdeaJdk(ModuleRootManager.getInstance((Module)module).getSdk());
        if (jdk == null) {
            return null;
        }
        String sandboxHome = ((Sandbox)jdk.getSdkAdditionalData()).getSandboxHome();
        if (sandboxHome == null) {
            return null;
        }
        try {
            sandboxHome = new File(sandboxHome).getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        return sandboxHome + File.separator + "plugins" + File.separator + module.getName();
    }

    public static void getDependencies(Module module, Set<? super Module> modules) {
        PluginBuildUtil.productionRuntimeDependencies(module).forEachModule(dep -> {
            if (ModuleType.get((Module)dep) == StdModuleTypes.JAVA && !modules.contains(dep)) {
                modules.add((Module)dep);
                PluginBuildUtil.getDependencies(dep, modules);
            }
            return true;
        });
    }

    public static Module[] getWrongSetDependencies(Module module) {
        return (Module[])ReadAction.compute(() -> {
            Module[] projectModules;
            ArrayList<Module> result = new ArrayList<Module>();
            for (Module projectModule : projectModules = ModuleManager.getInstance((Project)module.getProject()).getModules()) {
                if (ArrayUtil.find((Object[])ModuleRootManager.getInstance((Module)projectModule).getDependencies(), (Object)module) <= -1) continue;
                result.add(projectModule);
            }
            return result.toArray(Module.EMPTY_ARRAY);
        });
    }

    public static void getLibraries(Module module, Set<? super Library> libs) {
        PluginBuildUtil.productionRuntimeDependencies(module).forEachLibrary(library -> {
            libs.add((Library)library);
            return true;
        });
    }

    private static OrderEnumerator productionRuntimeDependencies(Module module) {
        return OrderEnumerator.orderEntries((Module)module).productionOnly().runtimeOnly();
    }
}

