/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.completion;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.completion.UiDefaultsHardcodedKeys;
import org.jetbrains.idea.devkit.themes.ThemeJsonSchemaProviderFactory;

public class ThemeJsonCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            ThemeJsonCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ThemeJsonCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!ThemeJsonCompletionContributor.isThemeJsonFile(parameters.getOriginalFile())) {
            return;
        }
        PsiElement position = parameters.getPosition();
        if (!(position instanceof LeafPsiElement)) {
            return;
        }
        PsiElement parent = position.getParent();
        if (parent instanceof JsonStringLiteral || parent instanceof JsonReferenceExpression) {
            PsiElement parentParent = parent.getParent();
            if (!(parentParent instanceof JsonProperty)) {
                return;
            }
            ThemeJsonCompletionContributor.handleJsonProperty(position, (JsonProperty)parentParent, parameters, result);
        } else if (parent instanceof JsonProperty) {
            ThemeJsonCompletionContributor.handleJsonProperty(position, (JsonProperty)parent, parameters, result);
        }
    }

    private static boolean isThemeJsonFile(@Nullable PsiFile file) {
        return file instanceof JsonFile && ThemeJsonSchemaProviderFactory.isAllowedFileName(file.getName());
    }

    private static void handleJsonProperty(@NotNull PsiElement element, @NotNull JsonProperty property, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (element == null) {
            ThemeJsonCompletionContributor.$$$reportNull$$$0(2);
        }
        if (property == null) {
            ThemeJsonCompletionContributor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            ThemeJsonCompletionContributor.$$$reportNull$$$0(4);
        }
        if (result == null) {
            ThemeJsonCompletionContributor.$$$reportNull$$$0(5);
        }
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        if (!ThemeJsonCompletionContributor.isInsideUiProperty(property)) {
            return;
        }
        if (!ThemeJsonCompletionContributor.isPropertyKey(element)) {
            return;
        }
        List parentProperties = PsiTreeUtil.collectParents((PsiElement)property, JsonProperty.class, (boolean)false, e -> e instanceof JsonProperty && "ui".equals(((JsonProperty)e).getName()));
        String presentNamePart = Lists.reverse((List)parentProperties).stream().map(p -> p.getName()).collect(Collectors.joining("."));
        boolean shouldSurroundWithQuotes = !element.getText().startsWith("\"");
        Iterable<LookupElement> lookupElements = ThemeJsonCompletionContributor.getLookupElements(presentNamePart, shouldSurroundWithQuotes);
        result.addAllElements(lookupElements);
    }

    private static boolean isInsideUiProperty(@NotNull JsonProperty property) {
        if (property == null) {
            ThemeJsonCompletionContributor.$$$reportNull$$$0(6);
        }
        JsonProperty parent = property;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof JsonProperty) || !"ui".equals(parent.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isPropertyKey(@NotNull PsiElement element) {
        if (element == null) {
            ThemeJsonCompletionContributor.$$$reportNull$$$0(7);
        }
        PsiElement sibling = element.getParent();
        while ((sibling = sibling.getPrevSibling()) != null) {
            if (!":".equals(sibling.getText())) continue;
            return false;
        }
        return true;
    }

    private static Iterable<LookupElement> getLookupElements(@NotNull String presentNamePart, boolean shouldSurroundWithQuotes) {
        Function<String, String> mapFunction;
        Predicate<String> conditionFilter;
        if (presentNamePart == null) {
            ThemeJsonCompletionContributor.$$$reportNull$$$0(8);
        }
        if (presentNamePart.startsWith("*")) {
            String tail = presentNamePart.substring(1);
            conditionFilter = key -> key.endsWith(tail);
            mapFunction = key -> {
                if (presentNamePart == null) {
                    ThemeJsonCompletionContributor.$$$reportNull$$$0(12);
                }
                return key.substring(presentNamePart.length() - 1);
            };
        } else if (presentNamePart.isEmpty()) {
            conditionFilter = s -> true;
            mapFunction = s -> s;
        } else {
            conditionFilter = key -> {
                if (presentNamePart == null) {
                    ThemeJsonCompletionContributor.$$$reportNull$$$0(11);
                }
                return key.startsWith(presentNamePart);
            };
            mapFunction = key -> {
                if (presentNamePart == null) {
                    ThemeJsonCompletionContributor.$$$reportNull$$$0(10);
                }
                return key.substring(presentNamePart.length() + 1);
            };
        }
        return UiDefaultsHardcodedKeys.UI_DEFAULTS_KEYS.stream().filter(conditionFilter).map(mapFunction).map(key -> ThemeJsonCompletionContributor.createLookupElement(key, shouldSurroundWithQuotes)).collect(Collectors.toSet());
    }

    private static LookupElement createLookupElement(@NotNull String key, boolean shouldSurroundWithQuotes) {
        if (key == null) {
            ThemeJsonCompletionContributor.$$$reportNull$$$0(9);
        }
        return LookupElementBuilder.create((String)key).withPresentableText("\"" + key + "\"").withInsertHandler((InsertHandler)new MyInsertHandler(shouldSurroundWithQuotes));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentNamePart";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/completion/ThemeJsonCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleJsonProperty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideUiProperty";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getLookupElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getLookupElements$7";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getLookupElements$6";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getLookupElements$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyInsertHandler
    implements InsertHandler<LookupElement> {
        private final boolean mySurroundWithQuotes;

        private MyInsertHandler(boolean surroundWithQuotes) {
            this.mySurroundWithQuotes = surroundWithQuotes;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                MyInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                MyInsertHandler.$$$reportNull$$$0(1);
            }
            if (this.mySurroundWithQuotes) {
                String quoted = "\"" + item.getLookupString() + "\"";
                context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)quoted);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/devkit/completion/ThemeJsonCompletionContributor$MyInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

