/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.ConvertToJBInsetsQuickFix;

public class UseDPIAwareInsetsInspection
extends DevKitInspectionBase {
    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            UseDPIAwareInsetsInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression) {
                ProblemDescriptor descriptor = UseDPIAwareInsetsInspection.checkNewExpression(expression, holder.getManager(), isOnTheFly);
                if (descriptor != null) {
                    holder.registerProblem(descriptor);
                }
                super.visitNewExpression(expression);
            }
        };
    }

    @Nullable
    private static ProblemDescriptor checkNewExpression(PsiNewExpression expression, InspectionManager manager, boolean isOnTheFly) {
        Project project = manager.getProject();
        PsiType type = expression.getType();
        PsiExpressionList arguments = expression.getArgumentList();
        if (type != null && arguments != null && type.equalsToText("java.awt.Insets")) {
            PsiType methodType;
            PsiElement parent;
            PsiElement superParent;
            if (expression.getParent() instanceof PsiExpressionList && (superParent = (parent = expression.getParent()).getParent()) instanceof PsiMethodCallExpression && (methodType = ((PsiMethodCallExpression)superParent).getType()) != null && methodType.equalsToText(JBInsets.class.getName())) {
                return null;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiClass jbuiClass = facade.findClass(JBUI.class.getName(), GlobalSearchScope.allScope((Project)project));
            if (jbuiClass != null && facade.getResolveHelper().isAccessible((PsiMember)jbuiClass, (PsiElement)expression, jbuiClass)) {
                PsiType parentType;
                PsiElement parent2 = expression.getParent();
                if (parent2 instanceof PsiExpressionList && parent2.getParent() instanceof PsiNewExpression && ((parentType = ((PsiNewExpression)parent2.getParent()).getType()) == null || JBInsets.class.getName().equals(parentType.getCanonicalText()))) {
                    return null;
                }
                if (arguments.getExpressionCount() == 4) {
                    return manager.createProblemDescriptor((PsiElement)expression, "Replace with JBUI.insets(...)", (LocalQuickFix)new ConvertToJBInsetsQuickFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/UseDPIAwareInsetsInspection", "buildInternalVisitor"));
    }
}

