/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.context.WebModuleContextProvider;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.application.JavaeeModule;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.oss.descriptor.JavaeeCmpDescriptor;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.glassfish.GlassfishBundle;
import com.intellij.javaee.oss.glassfish.GlassfishUtil;
import com.intellij.javaee.oss.glassfish.descriptor.GlassfishOracleAppDescriptor;
import com.intellij.javaee.oss.glassfish.descriptor.GlassfishOracleEjbDescriptor;
import com.intellij.javaee.oss.glassfish.descriptor.GlassfishOracleWebDescriptor;
import com.intellij.javaee.oss.glassfish.descriptor.GlassfishSunAppDescriptor;
import com.intellij.javaee.oss.glassfish.descriptor.GlassfishSunEjbDescriptor;
import com.intellij.javaee.oss.glassfish.descriptor.GlassfishSunWebDescriptor;
import com.intellij.javaee.oss.glassfish.model.GlassfishAppRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishCmpRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishOracleAppRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishOracleEjbRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishOracleWebRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishSunAppRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishSunEjbRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishSunWebRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishWebModule;
import com.intellij.javaee.oss.glassfish.model.GlassfishWebRoot;
import com.intellij.javaee.oss.glassfish.server.GlassfishDeploymentModel;
import com.intellij.javaee.oss.glassfish.server.GlassfishServerVersionConfig;
import com.intellij.javaee.oss.server.JavaeeDeploymentModelContextEditor;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import icons.IdeaGlassfishBaseIcons;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlassfishIntegration
extends JavaeeIntegration
implements WebModuleContextProvider {
    public static JavaeeIntegration getInstance() {
        return (JavaeeIntegration)AppServerIntegrationsManager.getInstance().getIntegration(GlassfishIntegration.class);
    }

    @NotNull
    public String getName() {
        String string = GlassfishBundle.getText("GlassfishIntegration.name", new Object[0]);
        if (string == null) {
            GlassfishIntegration.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getPresentableName() {
        return "Glassfish Server";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = IdeaGlassfishBaseIcons.Glassfish;
        if (icon == null) {
            GlassfishIntegration.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getBigIcon() {
        Icon icon = IdeaGlassfishBaseIcons.Glassfishbig;
        if (icon == null) {
            GlassfishIntegration.$$$reportNull$$$0(2);
        }
        return icon;
    }

    protected void collectDescriptors(JavaeeDescriptorsManager descriptorsManager) {
        descriptorsManager.addItem(GlassfishSunAppDescriptor.class, GlassfishSunAppRoot.class, "sun-application");
        descriptorsManager.addItem(GlassfishSunEjbDescriptor.class, GlassfishSunEjbRoot.class, "sun-ejb-jar");
        descriptorsManager.addItem(JavaeeCmpDescriptor.class, GlassfishCmpRoot.class, "sun-cmp-mapping");
        descriptorsManager.addItem(GlassfishSunWebDescriptor.class, GlassfishSunWebRoot.class, "sun-web");
        descriptorsManager.addItem(GlassfishOracleAppDescriptor.class, GlassfishOracleAppRoot.class, "glassfish-application");
        descriptorsManager.addItem(GlassfishOracleEjbDescriptor.class, GlassfishOracleEjbRoot.class, "glassfish-ejb-jar");
        descriptorsManager.addItem(GlassfishOracleWebDescriptor.class, GlassfishOracleWebRoot.class, "glassfish-web");
    }

    @Nullable
    @NonNls
    public String getNameFromTemplate(String template) {
        return template.split("_")[0];
    }

    @Nullable
    @NonNls
    public String getVersionFromTemplate(String template) {
        return template.replaceAll("[\\w-]+_(\\d)_(\\d(-\\d)?)\\.xml", "$1.$2").replace('-', '.');
    }

    @NotNull
    public String getServerVersion(JavaeePersistentData persistentData) throws Exception {
        String string = GlassfishServerVersionConfig.get(persistentData);
        if (string == null) {
            GlassfishIntegration.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void checkValidServerHome(String home, String version) throws Exception {
        if (GlassfishUtil.isGlassfish3Plus(version)) {
            GlassfishIntegration.checkFile((String)home, (String)"glassfish");
        } else {
            GlassfishIntegration.checkFile((String)home, (String)"lib/appserv-deployment-client.jar");
            GlassfishIntegration.checkFile((String)home, (String)"lib/appserv-ext.jar");
        }
    }

    protected void addLibraryLocations(String home, List<File> locations) {
        locations.add(new File(home, "lib"));
        locations.add(new File(home, "glassfish/modules"));
    }

    protected boolean allLibrariesFound(Collection<String> classes, Function<String, String> mapper) {
        return GlassfishIntegration.allLibrariesExceptEjbFound(classes, mapper);
    }

    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        JavaeeDeploymentModelContextEditor editor = new JavaeeDeploymentModelContextEditor(() -> this.createNewDeploymentModel(commonModel, source), GlassfishBundle.getText("GlassfishIntegration.contextEditorCaption", new Object[0]));
        editor.disableEditingForEEArtifact();
        return editor;
    }

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return new GlassfishDeploymentModel(commonModel, source);
    }

    @Nullable
    public String getContextRoot(JavaeeFacet facet) {
        GlassfishWebRoot web = GlassfishUtil.getWebRoot(facet);
        return web != null ? (String)web.getContextRoot().getValue() : null;
    }

    public String getContext(@NotNull JavaeeApplicationFacet earFacet, @Nullable String moduleWebUri) {
        GlassfishAppRoot app;
        if (earFacet == null) {
            GlassfishIntegration.$$$reportNull$$$0(4);
        }
        if ((app = GlassfishUtil.getAppRoot((JavaeeFacet)earFacet)) != null) {
            for (GlassfishWebModule web : app.getWebs()) {
                String result;
                JavaeeModule javaeeModule = (JavaeeModule)web.getWebUri().getValue();
                if (moduleWebUri != null && (javaeeModule == null || !moduleWebUri.equals(javaeeModule.getWeb().getWebUri().getValue())) || !StringUtil.isNotEmpty((String)(result = (String)web.getContextRoot().getValue()))) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public String getFrameworkLibrariesDescriptionRemoteName() {
        return "glassfish";
    }

    public boolean isStartupScriptTerminating() {
        return true;
    }

    public DeploymentProvider getDeploymentProvider(boolean local) {
        return new JavaeeDeploymentProvider(){

            public boolean isDeployOrderMatter() {
                return true;
            }

            public boolean isNeedUndeployOnDisconnect() {
                return true;
            }
        };
    }

    public boolean isJreCustomizable() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/glassfish/server/GlassfishIntegration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "earFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/glassfish/server/GlassfishIntegration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

