/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ws.rest.references.PathParamPsiElement;
import org.jetbrains.annotations.NotNull;

public class RestPathReference
extends PsiReferenceBase<PsiElement> {
    private final PsiLiteralExpression myLiteral;
    private final TextRange myRange;
    private final String myName;

    public RestPathReference(PsiLiteralExpression literal, TextRange range, String name) {
        super((PsiElement)literal, range, true);
        this.myLiteral = literal;
        this.myRange = range;
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public PsiElement resolve() {
        return new PathParamPsiElement((PsiElement)this.myLiteral, this.myName, this.myRange);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            RestPathReference.$$$reportNull$$$0(0);
        }
        return element instanceof PathParamPsiElement && this.myName.equals(((PathParamPsiElement)element).getName()) && this.myName.length() > 0 && PsiTreeUtil.getParentOfType((PsiElement)this.myLiteral, PsiMember.class) == PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/rest/references/RestPathReference", "isReferenceTo"));
    }
}

