/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.util.UriTemplateParser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSUtils {
    private static final List<String> RESOURCE_ANNOTATIONS = Arrays.asList("javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.PUT", "javax.ws.rs.DELETE", "javax.ws.rs.HEAD");
    @NonNls
    public static final String VALUE = "value";

    private RSUtils() {
    }

    @NotNull
    public static String getResourcePath(@NotNull RSHttpMethod httpMethod) {
        RSJamPsiMethodPath methodPathResource;
        RSJamPsiClassPath psiClassPath;
        if (httpMethod == null) {
            RSUtils.$$$reportNull$$$0(0);
        }
        StringBuilder buffer = new StringBuilder();
        PsiMethod psiMethod = httpMethod.getPsiElement();
        JamService service = JamService.getJamService((Project)psiMethod.getProject());
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass != null && (psiClassPath = (RSJamPsiClassPath)service.getJamElement((PsiElement)containingClass, new JamMemberMeta[]{RSJamPsiClassPath.META})) != null) {
            buffer.append(psiClassPath.getResourceValue());
        }
        if ((methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{RSJamPsiMethodPath.META})) != null) {
            buffer.append(methodPathResource.getResourceValue());
        }
        String string = buffer.toString();
        if (string == null) {
            RSUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isResourceClass(@NotNull PsiClass resource) {
        if (resource == null) {
            RSUtils.$$$reportNull$$$0(2);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)resource, (String)"javax.ws.rs.Path", (int)1);
    }

    @Nullable
    public static PsiClass getParent(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            RSUtils.$$$reportNull$$$0(3);
        }
        for (PsiElement el = anno.getParent(); el != null; el = el.getParent()) {
            if (!(el instanceof PsiClass)) continue;
            return (PsiClass)el;
        }
        return null;
    }

    public static boolean isNonAbstractAndPublicClass(PsiClass c) {
        PsiModifierList modifiers = c == null ? null : c.getModifierList();
        return modifiers != null && !c.isAnnotationType() && !c.isEnum() && !c.isInterface() && !modifiers.hasExplicitModifier("abstract") && modifiers.hasExplicitModifier("public");
    }

    @Nullable
    public static String getAnnotationValue(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            RSUtils.$$$reportNull$$$0(4);
        }
        return (String)AnnotationModelUtil.getStringValue((PsiAnnotation)anno, (String)VALUE, null).getValue();
    }

    public static String[] getAllMimes(Project project) {
        ArrayListSet types = new ArrayListSet();
        for (PsiAnnotation produce : RSUtils.getAnnotations(project, "javax.ws.rs.ProduceMime", "javax.ws.rs.ConsumeMime", "javax.ws.rs.Produces", "javax.ws.rs.Consumes")) {
            List values = AnnotationModelUtil.getStringArrayValue((PsiAnnotation)produce, (String)VALUE);
            for (AnnotationGenericValue value : values) {
                types.add(value.getValue());
            }
        }
        return ArrayUtil.toStringArray((Collection)types);
    }

    @NotNull
    private static Collection<PsiAnnotation> getAnnotations(@NotNull Project project, String ... fqns) {
        if (project == null) {
            RSUtils.$$$reportNull$$$0(5);
        }
        LinkedList annos = ContainerUtilRt.newLinkedList();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        for (String fqn : fqns) {
            String shortName = StringUtil.getShortName((String)fqn);
            for (PsiAnnotation psiAnnotation : JavaAnnotationIndex.getInstance().get(shortName, project, scope)) {
                if (!fqn.equals(psiAnnotation.getQualifiedName())) continue;
                annos.add(psiAnnotation);
            }
        }
        LinkedList linkedList = annos;
        if (linkedList == null) {
            RSUtils.$$$reportNull$$$0(6);
        }
        return linkedList;
    }

    public static boolean isResourceMethod(@NotNull PsiMethod method) {
        if (method == null) {
            RSUtils.$$$reportNull$$$0(7);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, RESOURCE_ANNOTATIONS, (int)0);
    }

    @Nullable
    public static PsiClass findInheritorClassAnnotatedAs(@NotNull @NonNls String fqn, @NotNull PsiClass c) {
        if (fqn == null) {
            RSUtils.$$$reportNull$$$0(8);
        }
        if (c == null) {
            RSUtils.$$$reportNull$$$0(9);
        }
        Query query = ClassInheritorsSearch.search((PsiClass)c, (SearchScope)GlobalSearchScope.projectScope((Project)c.getProject()), (boolean)true);
        Collection classes = query.findAll();
        for (PsiClass clazz : classes) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, (String[])new String[]{fqn}) != null) {
                return clazz;
            }
            PsiClass cl = RSUtils.findInheritorClassAnnotatedAs(fqn, clazz);
            if (cl == null) continue;
            return cl;
        }
        return null;
    }

    public static boolean isRootResourceClass(PsiElement element) {
        return element instanceof PsiClass && RSUtils.isNonAbstractAndPublicClass((PsiClass)element) && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)element), (String)"javax.ws.rs.Path", (int)1);
    }

    public static void annotateFieldWithPathParam(Project project, PsiField field, String name) {
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(field.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiAnnotation annotation = factory.createAnnotationFromText("@javax.ws.rs.PathParam(\"" + name + "\")", (PsiElement)field);
        PsiElement firstChild = modifierList.getFirstChild();
        if (firstChild != null) {
            modifierList.addBefore((PsiElement)annotation, firstChild);
        } else {
            modifierList.add((PsiElement)annotation);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
    }

    public static boolean isRestLibAttached(Module module) {
        return RSUtils.isRestLibAttached(module, "javax.ws.rs.Path");
    }

    public static boolean isRestLibAttached(Module module, String requiredClassName) {
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(requiredClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    @NotNull
    public static List<String> findPathParamNames(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            RSUtils.$$$reportNull$$$0(10);
        }
        ArrayList variants = ContainerUtil.newArrayList();
        String path = (String)AnnotationModelUtil.getStringValue((PsiAnnotation)annotation, (String)VALUE, null).getValue();
        try {
            variants.addAll(new UriTemplateParser(path).getNames());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList arrayList = variants;
        if (arrayList == null) {
            RSUtils.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpMethod";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/utils/RSUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/utils/RSUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findPathParamNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourcePath";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResourceClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isResourceMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findInheritorClassAnnotatedAs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPathParamNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

