/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.view;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.icons.AllIcons;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamModel;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import com.intellij.ws.rest.view.RSViewFinderRecursivePanel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSHttpMethodFinderRecursivePanel
extends FinderRecursivePanel<RSHttpMethod> {
    private final RSJamPsiClassPath myPath;
    private final RSViewFinderRecursivePanel myPanel;

    public RSHttpMethodFinderRecursivePanel(RSViewFinderRecursivePanel panel, @NotNull RSJamPsiClassPath path) {
        if (path == null) {
            RSHttpMethodFinderRecursivePanel.$$$reportNull$$$0(0);
        }
        super((FinderRecursivePanel)panel);
        this.myPanel = panel;
        this.myPath = path;
    }

    @Nullable
    protected JComponent createRightComponent(RSHttpMethod method) {
        return this.getDocumentationComponent((PsiElement)method.getPsiElement());
    }

    public DocumentationComponent getDocumentationComponent(PsiElement element) {
        return DocumentationComponent.createAndFetch((Project)this.getProject(), (PsiElement)element, (Disposable)this);
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent coloredComponent, JList list, RSHttpMethod method, int index, boolean selected, boolean hasFocus) {
        coloredComponent.clear();
        coloredComponent.setIcon(this.myPanel.isShowResourcesView() ? AllIcons.Nodes.PpWeb : this.getItemIcon(method));
        JamService service = JamService.getJamService((Project)this.getProject());
        RSJamPsiMethodPath methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)method.getPsiElement(), new JamMemberMeta[]{RSJamPsiMethodPath.META});
        String methodSignature = RSHttpMethodFinderRecursivePanel.getMethodSignature(method);
        String resourceValue = null;
        if (methodPathResource != null) {
            resourceValue = methodPathResource.getResourceValue();
        }
        resourceValue = resourceValue == null ? "" : "\"" + resourceValue + "\"";
        coloredComponent.append(this.myPanel.isShowResourcesView() ? resourceValue : methodSignature);
        coloredComponent.append(" @" + method.getShortAnnoName() + " ", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES, this.myPanel.isShowResourcesView());
        coloredComponent.append("(" + (this.myPanel.isShowResourcesView() ? methodSignature : resourceValue) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public static String getMethodSignature(RSHttpMethod method) {
        return PsiFormatUtil.formatMethod((PsiMethod)method.getPsiElement(), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)7, (int)2);
    }

    @NotNull
    protected List<RSHttpMethod> getListItems() {
        ArrayList<RSHttpMethod> items = new ArrayList<RSHttpMethod>();
        List<RSHttpMethod> methods = RSJamModel.getModel(this.getProject()).getHttpMethods(this.myPath.getPsiElement());
        for (RSHttpMethod httpMethod : RSViewFinderRecursivePanel.getFilteredMethods(methods, this.getProject())) {
            items.add(httpMethod);
        }
        ArrayList<RSHttpMethod> arrayList = items;
        if (arrayList == null) {
            RSHttpMethodFinderRecursivePanel.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected JComponent createDefaultRightComponent() {
        return this.getDocumentationComponent((PsiElement)this.myPath.getPsiElement());
    }

    @Nullable
    protected Icon getItemIcon(RSHttpMethod method) {
        return method.isValid() ? method.getPsiElement().getIcon(0) : null;
    }

    protected boolean hasChildren(RSHttpMethod method) {
        return false;
    }

    @NotNull
    protected String getItemText(RSHttpMethod method) {
        String resourceValue;
        if (!method.isValid()) {
            if ("" == null) {
                RSHttpMethodFinderRecursivePanel.$$$reportNull$$$0(2);
            }
            return "";
        }
        JamService service = JamService.getJamService((Project)this.getProject());
        RSJamPsiMethodPath methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)method.getPsiElement(), new JamMemberMeta[]{RSJamPsiMethodPath.META});
        String methodSignature = RSHttpMethodFinderRecursivePanel.getMethodSignature(method);
        if (methodPathResource != null && (resourceValue = methodPathResource.getResourceValue()) != null) {
            String string = methodSignature + " ( \"" + resourceValue + "\" )";
            if (string == null) {
                RSHttpMethodFinderRecursivePanel.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = methodSignature;
        if (string == null) {
            RSHttpMethodFinderRecursivePanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            RSHttpMethodFinderRecursivePanel.$$$reportNull$$$0(5);
        }
        RSHttpMethod httpMethod = (RSHttpMethod)((Object)this.getSelectedValue());
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && httpMethod != null) {
            return httpMethod.getPsiElement();
        }
        return super.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/view/RSHttpMethodFinderRecursivePanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/view/RSHttpMethodFinderRecursivePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

