/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.compiler;

import com.intellij.flex.compiler.LoggerAdapter;
import com.intellij.flex.compiler.MessageSender;
import flex2.tools.oem.Logger;
import flex2.tools.oem.Message;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OutputLogger
extends LoggerAdapter
implements Logger {
    public static final String ERROR_MARKER = "Error: ";
    private static final Pattern ERROR_PATTERN = Pattern.compile("(.*?)(\\(\\D.*\\))?(?:\\((-?\\d+)\\))?: ?(?:col: (-?\\d+):?)? (Warning|Error): (.*)");
    private final MessageSender myMessageSender;
    private final String myLogMessagePrefix;
    private boolean myErrorsReported = false;

    public OutputLogger(MessageSender messageSender, String logMessagePrefix) {
        this.myMessageSender = messageSender;
        this.myLogMessagePrefix = logMessagePrefix;
    }

    public void log(String message) {
        if (!this.myErrorsReported) {
            if (message.startsWith(ERROR_MARKER) || message.startsWith("Exception in thread \"main\" ")) {
                this.myErrorsReported = true;
            } else {
                String type;
                Matcher matcher = ERROR_PATTERN.matcher(message);
                if (matcher.matches() && "Error".equals(type = matcher.group(5))) {
                    this.myErrorsReported = true;
                }
            }
        }
        this.myMessageSender.sendMessage(this.myLogMessagePrefix + message);
    }

    public void log(Message msg, int errorCode, String source) {
        this.log(msg.getLevel(), msg.getPath(), msg.getLine(), msg.getColumn(), msg.toString());
    }

    @Override
    public void log(String level, String path, int line, int column, String message) {
        StringBuilder builder = new StringBuilder();
        if (!OutputLogger.isEmpty(path)) {
            builder.append(path);
        }
        if (line >= 0) {
            builder.append('(').append(line).append(')');
        }
        if (builder.length() > 0) {
            builder.append(": ");
        }
        if (column >= 0) {
            builder.append("col: ").append(column).append(" ");
        }
        if ("Warning".equalsIgnoreCase(level)) {
            builder.append("Warning").append(": ");
        } else if ("Error".equalsIgnoreCase(level)) {
            builder.append("Error").append(": ");
        }
        builder.append(OutputLogger.isEmpty(message) ? "unknown error" : message);
        this.log(builder.toString());
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public boolean wereErrorsReported() {
        return this.myErrorsReported;
    }
}

