/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.compiler;

import flex2.tools.oem.PathResolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class SdkFilesResolver
implements PathResolver {
    private static final String FLEXLIB_PATH;
    private static final String FLEX_CONFIG_PATH;
    private static final String AIR_CONFIG_PATH;
    private static File fakeConfigFile;
    public static SdkFilesResolver INSTANCE;

    private SdkFilesResolver() {
    }

    public File resolve(String path) {
        File file = new File(FLEXLIB_PATH, path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static File createFakeConfigFile() {
        try {
            File file = File.createTempFile("fake-config", ".xml");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write("<flex-config/>".getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void removeTempFile() {
        if (fakeConfigFile != null) {
            fakeConfigFile.delete();
        }
    }

    static {
        String appHome = System.getProperty("application.home");
        FLEXLIB_PATH = appHome == null ? "." : appHome + File.separator + "frameworks";
        FLEX_CONFIG_PATH = FLEXLIB_PATH + "/flex-config.xml";
        AIR_CONFIG_PATH = FLEXLIB_PATH + "/air-config.xml";
        INSTANCE = new SdkFilesResolver();
    }
}

