/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.CommonActionsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.play.console.BasicConsoleProcessRunner;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessLanguageConsoleViewWrapper
extends JPanel {
    private final LanguageConsoleView myConsoleView;

    public ProcessLanguageConsoleViewWrapper(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            ProcessLanguageConsoleViewWrapper.$$$reportNull$$$0(0);
        }
        this.myConsoleView = consoleView;
        this.setBorder((Border)new SideBorder(JBColor.border(), 1));
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PlayLangConsoleView", (ActionGroup)toolbarActions, false);
        this.setLayout(new BorderLayout());
        this.add((Component)actionToolbar.getComponent(), "West");
        this.add((Component)this.myConsoleView.getComponent(), "Center");
        actionToolbar.setTargetComponent((JComponent)this);
        List<AnAction> actions = this.fillToolBarActions(toolbarActions);
        ProcessLanguageConsoleViewWrapper.registerActionShortcuts(actions, this.myConsoleView.getConsoleEditor().getComponent());
        ProcessLanguageConsoleViewWrapper.registerActionShortcuts(actions, this);
        this.updateUI();
    }

    public static void registerActionShortcuts(List<? extends AnAction> actions, JComponent component) {
        for (AnAction anAction : actions) {
            if (anAction.getShortcutSet() == null) continue;
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), component);
        }
    }

    protected List<AnAction> fillToolBarActions(DefaultActionGroup toolbarActions) {
        ArrayList<AnAction> actionList = new ArrayList<AnAction>();
        AnAction stopAction = this.createStopAction();
        actionList.add(stopAction);
        AnAction closeAction = this.createCloseAction(this.getProcessRunner());
        actionList.add(closeAction);
        actionList.add(LanguageConsoleBuilder.registerExecuteAction((LanguageConsoleView)this.myConsoleView, text -> {
            try {
                this.getProcessRunner().runProcess((String)text);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }, (String)this.getProcessRunner().getHistoryId(), (String)this.getProcessRunner().getHistoryPersistenceId(), console -> this.getProcessRunner().isReady()));
        actionList.add(CommonActionsManager.getInstance().createHelpAction("interactive_console"));
        Collections.addAll(actionList, this.myConsoleView.createConsoleActions());
        toolbarActions.addAll(actionList);
        return actionList;
    }

    protected abstract BasicConsoleProcessRunner getProcessRunner();

    protected AnAction createCloseAction(final BasicConsoleProcessRunner processRunner) {
        return new CloseAction(null, null, this.myConsoleView.getProject()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processRunner.getState() == BasicConsoleProcessRunner.State.EXECUTING) {
                    Process process = processRunner.getProcessHandler().getProcess();
                    OSProcessManager.getInstance().killProcessTree(process);
                }
                super.actionPerformed(e);
            }

            public Executor getExecutor() {
                return processRunner.getExecutor();
            }

            public RunContentDescriptor getContentDescriptor() {
                return processRunner.getContentDescriptor();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.update(e);
                e.getPresentation().setEnabled(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/play/console/ProcessLanguageConsoleViewWrapper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected AnAction createStopAction() {
        return ActionManager.getInstance().getAction("Stop");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/play/console/ProcessLanguageConsoleViewWrapper", "<init>"));
    }
}

