/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.play.completion.beans.PlayFastTagDescriptor;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.utils.PlayUtils;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayPathUtils {
    private static final String VIEWS_PKG = "views";
    private static final String VIEWS_DEFAULT_EXTENSION = "html";

    @Nullable
    public static PsiDirectory getCorrespondingDirectory(@NotNull PsiClass controller) {
        PsiDirectory directory;
        Module module;
        if (controller == null) {
            PlayPathUtils.$$$reportNull$$$0(0);
        }
        if (PlayUtils.isController(controller) && (module = ModuleUtil.findModuleForPsiElement((PsiElement)controller)) != null && (directory = PlayPathUtils.getViewsDirectory(module)) != null) {
            return directory.findSubdirectory(controller.getName());
        }
        return null;
    }

    @Nullable
    public static PsiClass getCorrespondingController(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PlayPathUtils.$$$reportNull$$$0(1);
        }
        String path = new String();
        for (PsiDirectory psiDirectory = psiFile.getOriginalFile().getContainingDirectory(); psiDirectory != null && !VIEWS_PKG.equals(psiDirectory.getName()); psiDirectory = psiDirectory.getParentDirectory()) {
            if (path.length() > 0) {
                path = path + ".";
            }
            path = psiDirectory.getName() + path;
        }
        return StringUtil.isEmptyOrSpaces((String)path) ? null : JavaPsiFacade.getInstance((Project)psiFile.getProject()).findClass("controllers." + path, psiFile.getResolveScope());
    }

    @Nullable
    public static PsiClass findControllerByName(@NotNull String controller, @NotNull Module module) {
        if (controller == null) {
            PlayPathUtils.$$$reportNull$$$0(2);
        }
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(3);
        }
        return StringUtil.isEmptyOrSpaces((String)controller) ? null : JavaPsiFacade.getInstance((Project)module.getProject()).findClass("controllers." + controller, GlobalSearchScope.moduleWithDependenciesScope((Module)module));
    }

    @Nullable
    public static LocalSearchScope getRoutsFilesScope(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            PlayPathUtils.$$$reportNull$$$0(4);
        }
        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)element)) != null) {
            Set<PsiFile> files = PlayPathUtils.getRoutesFiles(module);
            return new LocalSearchScope(files.toArray(PsiElement.EMPTY_ARRAY));
        }
        return null;
    }

    @NotNull
    public static Set<PsiFile> getRoutesFiles(@NotNull Module module) {
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(5);
        }
        HashSet<PsiFile> files = new HashSet<PsiFile>();
        Set<PsiDirectory> directories = PlayPathUtils.getConfigDirectories(module);
        for (PsiDirectory directory : directories) {
            PsiFile routes = directory.findFile("routes");
            if (routes == null) continue;
            files.add(routes);
        }
        HashSet<PsiFile> hashSet = files;
        if (hashSet == null) {
            PlayPathUtils.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    public static PsiMethod[] getCorrespondingControllerMethods(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PlayPathUtils.$$$reportNull$$$0(7);
        }
        HashSet<PsiMethod> psiMethods = new HashSet<PsiMethod>();
        PsiClass controller = PlayPathUtils.getCorrespondingController(psiFile);
        if (controller != null) {
            String templateName = FileUtil.getNameWithoutExtension((String)psiFile.getName());
            for (PsiMethod psiMethod : controller.getAllMethods()) {
                if (!psiMethod.getName().toLowerCase().equals(templateName.toLowerCase())) continue;
                psiMethods.add(psiMethod);
            }
        }
        PsiMethod[] psiMethodArray = psiMethods.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PlayPathUtils.$$$reportNull$$$0(8);
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiFile getCorrespondingView(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            PlayPathUtils.$$$reportNull$$$0(9);
        }
        String fileName = psiMethod.getName();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String controllerPkgName = containingClass.getQualifiedName();
        if (controllerPkgName != null && controllerPkgName.startsWith("controllers")) {
            String viewPkgName = controllerPkgName.replaceFirst("controllers", VIEWS_PKG);
            PsiPackage viewPackage = JavaPsiFacade.getInstance((Project)psiMethod.getProject()).findPackage(viewPkgName);
            if (viewPackage != null) {
                for (PsiDirectory psiDirectory : viewPackage.getDirectories()) {
                    for (PsiFile psiFile : psiDirectory.getFiles()) {
                        VirtualFile virtualFile = psiFile.getVirtualFile();
                        if (virtualFile == null || !fileName.toLowerCase().equals(virtualFile.getNameWithoutExtension().toLowerCase()) || !(psiFile instanceof PlayPsiFile)) continue;
                        return psiFile;
                    }
                }
            }
        }
        return null;
    }

    public static Set<PsiDirectory> getConfigDirectories(@NotNull Module module) {
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(10);
        }
        HashSet<PsiDirectory> configs = new HashSet<PsiDirectory>();
        PlayPathUtils.collectConfigDirectories(module, configs);
        return configs;
    }

    public static void collectConfigDirectories(@NotNull Module module, @NotNull Set<? super PsiDirectory> configs) {
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(11);
        }
        if (configs == null) {
            PlayPathUtils.$$$reportNull$$$0(12);
        }
        PlayPathUtils.collectConfigDirectories(module, configs, new HashSet());
    }

    public static void collectConfigDirectories(@NotNull Module module, @NotNull Set<? super PsiDirectory> configs, @NotNull Set<? super Module> visitedModules) {
        VirtualFile[] roots;
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(13);
        }
        if (configs == null) {
            PlayPathUtils.$$$reportNull$$$0(14);
        }
        if (visitedModules == null) {
            PlayPathUtils.$$$reportNull$$$0(15);
        }
        if (visitedModules.contains(module)) {
            return;
        }
        visitedModules.add((Module)module);
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile virtualFile : roots = moduleRootManager.getContentRoots()) {
            PsiDirectory directory;
            VirtualFile conf = virtualFile.findChild("conf");
            if (conf == null || !conf.isDirectory() || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(conf)) == null) continue;
            configs.add((PsiDirectory)directory);
        }
        for (VirtualFile virtualFile : moduleRootManager.getDependencies()) {
            PlayPathUtils.collectConfigDirectories((Module)virtualFile, configs, visitedModules);
        }
    }

    @NotNull
    public static Map<String, PsiFile> getCustomTags(@NotNull Module module) {
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(16);
        }
        HashMap files = new HashMap();
        PlayPathUtils.collectCustomTags(module, (Map<String, PsiFile>)files);
        HashMap hashMap = files;
        if (hashMap == null) {
            PlayPathUtils.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    public static Set<PsiDirectory> getCustomTagRoots(@Nullable Module module) {
        if (module == null) {
            return Collections.emptySet();
        }
        return PlayPathUtils.getCustomTagRoots(module, new HashSet());
    }

    public static Set<PsiDirectory> getCustomTagRoots(@NotNull Module module, @NotNull Set<? super Module> processed) {
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(18);
        }
        if (processed == null) {
            PlayPathUtils.$$$reportNull$$$0(19);
        }
        com.intellij.util.containers.hash.HashSet directories = new com.intellij.util.containers.hash.HashSet();
        if (!processed.contains(module)) {
            VirtualFile[] roots;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile virtualFile : roots = moduleRootManager.getSourceRoots()) {
                PsiDirectory directory;
                VirtualFile tagsDir = virtualFile.findFileByRelativePath("views/tags");
                if (tagsDir == null || !tagsDir.isDirectory() || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(tagsDir)) == null) continue;
                directories.add(directory);
            }
            processed.add((Module)module);
            for (VirtualFile virtualFile : moduleRootManager.getDependencies()) {
                directories.addAll(PlayPathUtils.getCustomTagRoots((Module)virtualFile, processed));
            }
        }
        return directories;
    }

    public static void collectCustomTags(@NotNull Module module, @NotNull Map<String, PsiFile> files) {
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(20);
        }
        if (files == null) {
            PlayPathUtils.$$$reportNull$$$0(21);
        }
        PlayPathUtils.collectCustomTags(module, files, (Set<? super Module>)new com.intellij.util.containers.hash.HashSet());
    }

    public static void collectCustomTags(@NotNull Module module, @NotNull Map<String, PsiFile> files, @NotNull Set<? super Module> processed) {
        VirtualFile[] roots;
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(22);
        }
        if (files == null) {
            PlayPathUtils.$$$reportNull$$$0(23);
        }
        if (processed == null) {
            PlayPathUtils.$$$reportNull$$$0(24);
        }
        if (processed.contains(module)) {
            return;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile virtualFile : roots = moduleRootManager.getSourceRoots()) {
            PsiDirectory directory;
            VirtualFile tagsDir = virtualFile.findFileByRelativePath("views/tags");
            if (tagsDir == null || !tagsDir.isDirectory() || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(tagsDir)) == null) continue;
            PlayPathUtils.addFiles(files, directory, "");
        }
        processed.add((Module)module);
        for (VirtualFile virtualFile : moduleRootManager.getDependencies()) {
            PlayPathUtils.collectCustomTags((Module)virtualFile, files, processed);
        }
    }

    private static void addFiles(@NotNull Map<String, PsiFile> files, @NotNull PsiDirectory directory, @NotNull String relatedPath) {
        if (files == null) {
            PlayPathUtils.$$$reportNull$$$0(25);
        }
        if (directory == null) {
            PlayPathUtils.$$$reportNull$$$0(26);
        }
        if (relatedPath == null) {
            PlayPathUtils.$$$reportNull$$$0(27);
        }
        for (PsiDirectory psiDirectory : directory.getSubdirectories()) {
            String dirName = psiDirectory.getName();
            PlayPathUtils.addFiles(files, psiDirectory, relatedPath.isEmpty() ? dirName : relatedPath + "." + dirName);
        }
        for (PsiDirectory psiDirectory : directory.getFiles()) {
            VirtualFile virtualFile;
            if (!(psiDirectory instanceof PlayPsiFile) || (virtualFile = psiDirectory.getVirtualFile()) == null) continue;
            String tagName = virtualFile.getNameWithoutExtension();
            files.put(relatedPath.isEmpty() ? tagName : relatedPath + "." + tagName, (PsiFile)psiDirectory);
        }
    }

    @Nullable
    public static PsiDirectory getViewsDirectory(@NotNull Module module) {
        VirtualFile[] roots;
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(28);
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile root : roots = moduleRootManager.getSourceRoots()) {
            VirtualFile viewsDir = root.findFileByRelativePath(VIEWS_PKG);
            if (viewsDir == null || !viewsDir.isDirectory()) continue;
            return PsiManager.getInstance((Project)module.getProject()).findDirectory(viewsDir);
        }
        return null;
    }

    @NotNull
    public static Set<PlayFastTagDescriptor> getFastTags(@NotNull Module module) {
        if (module == null) {
            PlayPathUtils.$$$reportNull$$$0(29);
        }
        HashSet<PlayFastTagDescriptor> fastTags = new HashSet<PlayFastTagDescriptor>();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        PsiClass fastTagsClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("play.templates.FastTags", scope);
        if (fastTagsClass != null) {
            Query classQuery = ClassInheritorsSearch.search((PsiClass)fastTagsClass, (SearchScope)scope, (boolean)true);
            for (PsiClass psiClass : classQuery.findAll()) {
                fastTags.addAll(PlayPathUtils.getFastTags(psiClass));
            }
        }
        HashSet<PlayFastTagDescriptor> hashSet = fastTags;
        if (hashSet == null) {
            PlayPathUtils.$$$reportNull$$$0(30);
        }
        return hashSet;
    }

    @NotNull
    public static Set<PlayFastTagDescriptor> getFastTags(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PlayPathUtils.$$$reportNull$$$0(31);
        }
        HashSet<PlayFastTagDescriptor> fastTags = new HashSet<PlayFastTagDescriptor>();
        JamStringAttributeElement<String> namespace = PlayPathUtils.getFastTagNamespace(psiClass);
        for (PsiMethod method : psiClass.getMethods()) {
            if (!PlayPathUtils.isFastTagMethod(method)) continue;
            fastTags.add(new PlayFastTagDescriptor(method, namespace));
        }
        HashSet<PlayFastTagDescriptor> hashSet = fastTags;
        if (hashSet == null) {
            PlayPathUtils.$$$reportNull$$$0(32);
        }
        return hashSet;
    }

    @Nullable
    private static JamStringAttributeElement<String> getFastTagNamespace(@NotNull PsiClass aClass) {
        PsiAnnotation annotation;
        if (aClass == null) {
            PlayPathUtils.$$$reportNull$$$0(33);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{"play.templates.FastTags.Namespace"})) == null) {
            return null;
        }
        return JamAttributeMeta.singleString((String)"value").getJam(PsiElementRef.real((PsiElement)annotation));
    }

    private static boolean isFastTagMethod(@NotNull PsiMethod method) {
        PsiParameter[] parameters;
        if (method == null) {
            PlayPathUtils.$$$reportNull$$$0(34);
        }
        return method.getName().startsWith("_") && (parameters = method.getParameterList().getParameters()).length == 5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 17: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 17: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: 
            case 17: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/play/utils/PlayPathUtils";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedModules";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedPath";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/play/utils/PlayPathUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutesFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingControllerMethods";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomTags";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingController";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findControllerByName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRoutsFilesScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRoutesFiles";
                break;
            }
            case 6: 
            case 8: 
            case 17: 
            case 30: 
            case 32: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingControllerMethods";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingView";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConfigDirectories";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectConfigDirectories";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCustomTags";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCustomTagRoots";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectCustomTags";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getViewsDirectory";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getFastTags";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFastTagNamespace";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isFastTagMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 17: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

