/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dupLocator.iterators.CountingNodeIterator;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchScriptException;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspectionCompiledPatternsCache;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspectionOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SSBasedInspection
extends LocalInspectionTool {
    static final Object LOCK = new Object();
    static final String SHORT_NAME = "SSBasedInspection";
    private final List<Configuration> myConfigurations = new ArrayList<Configuration>();
    final Set<String> myProblemsReported = new HashSet<String>(1);

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SSBasedInspection.$$$reportNull$$$0(0);
        }
        ConfigurationManager.writeConfigurations(node, this.myConfigurations);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            SSBasedInspection.$$$reportNull$$$0(1);
        }
        this.myProblemsReported.clear();
        this.myConfigurations.clear();
        ConfigurationManager.readConfigurations(node, this.myConfigurations);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            SSBasedInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = SSRBundle.message("SSRInspection.display.name", new Object[0]);
        if (string == null) {
            SSBasedInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            SSBasedInspection.$$$reportNull$$$0(4);
        }
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        Map<Configuration, MatchContext> compiledOptions;
        if (holder == null) {
            SSBasedInspection.$$$reportNull$$$0(5);
        }
        if ((compiledOptions = SSBasedInspectionCompiledPatternsCache.getCompiledOptions(this.myConfigurations, holder.getProject())).isEmpty()) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                SSBasedInspection.$$$reportNull$$$0(6);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){
            final Matcher matcher;
            final PairProcessor<MatchResult, Configuration> processor;
            {
                this.matcher = new Matcher(holder.getManager().getProject());
                this.processor = (matchResult, configuration) -> {
                    if (holder == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PsiElement element = matchResult.getMatch();
                    String name = configuration.getName();
                    LocalQuickFix fix = SSBasedInspection.createQuickFix(holder.getManager().getProject(), matchResult, configuration);
                    holder.registerProblem(holder.getManager().createProblemDescriptor(element, name, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                    return true;
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitElement(PsiElement element) {
                Object object = LOCK;
                synchronized (object) {
                    if (LexicalNodesFilter.getInstance().accepts(element)) {
                        return;
                    }
                    SsrFilteringNodeIterator matchedNodes = new SsrFilteringNodeIterator(element);
                    for (Map.Entry entry : compiledOptions.entrySet()) {
                        block7: {
                            Configuration configuration = (Configuration)entry.getKey();
                            MatchContext context = (MatchContext)entry.getValue();
                            if (context == null || !Matcher.checkIfShouldAttemptToMatch(context, matchedNodes)) continue;
                            int nodeCount = context.getPattern().getNodeCount();
                            try {
                                this.matcher.processMatchesInElement(context, configuration, new CountingNodeIterator(nodeCount, matchedNodes), this.processor);
                            }
                            catch (StructuralSearchException e) {
                                if (!SSBasedInspection.this.myProblemsReported.add(configuration.getName())) break block7;
                                UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.ERROR).setContent(e instanceof StructuralSearchScriptException ? SSRBundle.message("inspection.script.problem", e.getCause(), configuration.getName()) : SSRBundle.message("inspection.template.problem", e.getMessage())).setImportant(true).notify(element.getProject());
                            }
                        }
                        matchedNodes.reset();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection$1", "lambda$$0"));
            }
        };
        if (psiElementVisitor == null) {
            SSBasedInspection.$$$reportNull$$$0(7);
        }
        return psiElementVisitor;
    }

    static LocalQuickFix createQuickFix(Project project, MatchResult matchResult, Configuration configuration) {
        if (!(configuration instanceof ReplaceConfiguration)) {
            return null;
        }
        ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)configuration;
        final Replacer replacer = new Replacer(project, replaceConfiguration.getReplaceOptions());
        final ReplacementInfo replacementInfo = replacer.buildReplacement(matchResult);
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = SSRBundle.message("SSRInspection.replace.with", replacementInfo.getReplacement());
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement element;
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((element = descriptor.getPsiElement()) != null) {
                    replacer.replace(replacementInfo);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = SSRBundle.message("SSRInspection.family.name", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SSBasedInspectionOptions(this.myConfigurations).getComponent();
    }

    public void setConfigurations(@NotNull List<Configuration> configurations, @NotNull Project project) {
        if (configurations == null) {
            SSBasedInspection.$$$reportNull$$$0(8);
        }
        if (project == null) {
            SSBasedInspection.$$$reportNull$$$0(9);
        }
        this.myConfigurations.clear();
        this.myConfigurations.addAll(configurations);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

