/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.core.postprocessing;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.clones.core.postprocessing.UniteNearbyClonesKt;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0007H\u0002\u001a\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0002\u001a\u0014\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u001a\u001c\u0010\f\u001a\u0004\u0018\u00010\r*\b\u0012\u0004\u0012\u00020\r0\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u000f\u001a\u0004\u0018\u00010\r*\u00020\r2\u0006\u0010\u0003\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0015\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0082\u0004\u001a\u001e\u0010\u0010\u001a\u0004\u0018\u00010\r*\u00020\r2\u0006\u0010\u0003\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012*\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"canBeExtendedBy", "", "Lcom/jetbrains/clones/structures/TextFragment;", "other", "lineGap", "", "compareTo", "Lcom/intellij/openapi/util/TextRange;", "contains", "extendDown", "lines", "intersects", "processHead", "Lcom/jetbrains/clones/structures/TextClone;", "Ljava/util/Deque;", "unite", "uniteIntersected", "uniteTextRanges", "", "intellij.platform.duplicatesDetector"})
public final class UniteNearbyClonesKt {
    public static final boolean intersects(@NotNull TextFragment $receiver, @NotNull TextFragment other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$receiver.getFile(), (Object)other.getFile()) && $receiver.getRange().intersects(other.getRange());
    }

    private static final TextFragment extendDown(@NotNull TextFragment $receiver, int lines) {
        boolean bl;
        boolean bl2 = bl = lines >= 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Document document = FileDocumentManager.getInstance().getDocument($receiver.getFile());
        if (document == null) {
            throw (Throwable)new IllegalStateException("There is no document for file " + $receiver.getFile().getPresentableName());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"FileDocumentManager.getI\u2026${file.presentableName}\")");
        Document document2 = document;
        int newEndLine = document2.getLineNumber($receiver.getRange().getEndOffset()) + lines;
        int newEndOffset = document2.getLineEndOffset(RangesKt.coerceIn((int)newEndLine, (ClosedRange)((ClosedRange)RangesKt.until((int)0, (int)document2.getLineCount()))));
        return new TextFragment($receiver.getFile(), new TextRange($receiver.getRange().getStartOffset(), newEndOffset));
    }

    private static final TextFragment unite(@NotNull TextFragment $receiver, TextFragment other) {
        boolean bl = Intrinsics.areEqual((Object)$receiver.getFile(), (Object)other.getFile());
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        VirtualFile virtualFile = $receiver.getFile();
        TextRange textRange = $receiver.getRange().union(other.getRange());
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"range.union(other.range)");
        return new TextFragment(virtualFile, textRange);
    }

    public static final boolean contains(@NotNull TextFragment $receiver, @NotNull TextFragment other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$receiver.getFile(), (Object)other.getFile()) && $receiver.getRange().contains(other.getRange());
    }

    private static final int compareTo(@NotNull TextRange $receiver, TextRange other) {
        return $receiver.getStartOffset() != other.getStartOffset() ? $receiver.getStartOffset() - other.getStartOffset() : other.getLength() - $receiver.getLength();
    }

    @NotNull
    public static final List<TextClone> uniteTextRanges(@NotNull List<TextClone> $receiver, int lineGap) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        LinkedList queue2 = new LinkedList(CollectionsKt.sortedWith((Iterable)$receiver, (Comparator)uniteTextRanges.queue.1.INSTANCE));
        List classes2 = new ArrayList();
        while (!(collection = (Collection)queue2).isEmpty()) {
            TextClone result = UniteNearbyClonesKt.processHead(queue2, lineGap);
            if (result == null) continue;
            classes2.add(result);
        }
        return classes2;
    }

    private static final TextClone processHead(@NotNull Deque<TextClone> $receiver, int lineGap) {
        TextClone textClone;
        TextClone result;
        TextClone textClone2 = $receiver.poll();
        if (textClone2 == null) {
            return null;
        }
        TextClone first = textClone2;
        TextClone textClone3 = $receiver.poll();
        if (textClone3 == null) {
            return first;
        }
        TextClone second = textClone3;
        TextClone textClone4 = result = UniteNearbyClonesKt.intersects(first.getMain(), second.getMain()) ? UniteNearbyClonesKt.unite(first, second, 0) : UniteNearbyClonesKt.unite(first, second, lineGap);
        if (result != null) {
            $receiver.push(result);
            textClone = null;
        } else if (UniteNearbyClonesKt.intersects(first.getMain(), second.getMain())) {
            $receiver.push(first);
            textClone = null;
        } else {
            $receiver.push(second);
            textClone = first;
        }
        return textClone;
    }

    @Nullable
    public static final TextClone unite(@NotNull TextClone $receiver, @NotNull TextClone other, int lineGap) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return $receiver.getMain().getRange().contains(other.getMain().getRange()) ? $receiver : (!UniteNearbyClonesKt.canBeExtendedBy($receiver.getMain(), other.getMain(), lineGap) ? null : UniteNearbyClonesKt.uniteIntersected($receiver, other, lineGap));
    }

    /*
     * WARNING - void declaration
     */
    private static final TextClone uniteIntersected(@NotNull TextClone $receiver, TextClone other, int lineGap) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Object element$iv$iv2;
        void $receiver$iv$iv3;
        Iterable $receiver$iv;
        TextFragment unitedMain = UniteNearbyClonesKt.unite($receiver.getMain(), other.getMain());
        Iterable iterable = $receiver$iv = (Iterable)other.getDuplicates();
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv3) {
            TextFragment it = (TextFragment)element$iv$iv2;
            if (UniteNearbyClonesKt.intersects(it, unitedMain)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List otherDuplicates = (List)destination$iv$iv;
        Iterable $receiver$iv2 = $receiver.getDuplicates();
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv3 : $receiver$iv$iv2) {
            TextFragment it = (TextFragment)element$iv$iv3;
            if (UniteNearbyClonesKt.intersects(it, unitedMain)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        List thisDuplicates = (List)destination$iv$iv2;
        int offset = other.getMain().getLines().getStart() - $receiver.getMain().getLines().getStart();
        Iterable $receiver$iv3 = thisDuplicates;
        element$iv$iv2 = $receiver$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TextFragment textFragment;
            Object v0;
            TextFragment thisDuplicate;
            block5: {
                void $receiver$iv4;
                Object element$iv$iv$iv;
                Object element$iv$iv4 = element$iv$iv$iv = iterator.next();
                thisDuplicate = (TextFragment)element$iv$iv4;
                Iterable iterable2 = otherDuplicates;
                Iterable iterable3 = $receiver$iv4;
                Comparator comparator = new Comparator<T>(thisDuplicate, otherDuplicates, offset, lineGap){
                    final /* synthetic */ TextFragment $thisDuplicate$inlined;
                    final /* synthetic */ List $otherDuplicates$inlined;
                    final /* synthetic */ int $offset$inlined;
                    final /* synthetic */ int $lineGap$inlined;
                    {
                        this.$thisDuplicate$inlined = textFragment;
                        this.$otherDuplicates$inlined = list;
                        this.$offset$inlined = n;
                        this.$lineGap$inlined = n2;
                    }

                    public final int compare(T a, T b) {
                        TextFragment it = (TextFragment)a;
                        Comparable comparable = Integer.valueOf(Math.abs(this.$offset$inlined - Math.abs(it.getLines().getStart() - this.$thisDuplicate$inlined.getLines().getStart())));
                        it = (TextFragment)b;
                        Comparable comparable2 = comparable;
                        Integer n = Math.abs(this.$offset$inlined - Math.abs(it.getLines().getStart() - this.$thisDuplicate$inlined.getLines().getStart()));
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                };
                iterable3 = iterable2 = (Iterable)CollectionsKt.sortedWith((Iterable)iterable3, (Comparator)comparator);
                for (Object e : iterable3) {
                    TextFragment it = (TextFragment)e;
                    if (!UniteNearbyClonesKt.canBeExtendedBy(thisDuplicate, it, lineGap)) continue;
                    v0 = e;
                    break block5;
                }
                v0 = null;
            }
            TextFragment textFragment2 = v0;
            TextFragment textFragment3 = textFragment2 != null ? UniteNearbyClonesKt.unite(textFragment2, thisDuplicate) : null;
            if (textFragment3 == null) continue;
            TextFragment it$iv$iv = textFragment = textFragment3;
            destination$iv$iv3.add(it$iv$iv);
        }
        List unitedEntries = (List)destination$iv$iv3;
        if (unitedEntries.isEmpty()) {
            return null;
        }
        return new TextClone(unitedMain, unitedEntries);
    }

    private static final boolean canBeExtendedBy(@NotNull TextFragment $receiver, TextFragment other, int lineGap) {
        return Intrinsics.areEqual((Object)$receiver.getFile(), (Object)other.getFile()) ^ true ? false : UniteNearbyClonesKt.extendDown($receiver, lineGap).getRange().contains(other.getRange().getStartOffset()) && other.getRange().getEndOffset() > $receiver.getRange().getEndOffset();
    }

    public static final /* synthetic */ int access$compareTo(@NotNull TextRange $receiver, @NotNull TextRange other) {
        return UniteNearbyClonesKt.compareTo($receiver, other);
    }
}

