/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.toolwindow;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.clones.presentation.PreviewPanel;
import com.jetbrains.clones.structures.TextFragment;
import com.jetbrains.clones.toolwindow.DuplicateEntry;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0002R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/clones/toolwindow/DiffController;", "Lcom/intellij/openapi/Disposable;", "left", "Lcom/jetbrains/clones/toolwindow/DuplicateEntry;", "right", "(Lcom/jetbrains/clones/toolwindow/DuplicateEntry;Lcom/jetbrains/clones/toolwindow/DuplicateEntry;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "diffPanel", "Lcom/intellij/diff/DiffRequestPanel;", "value", "getLeft", "()Lcom/jetbrains/clones/toolwindow/DuplicateEntry;", "setLeft", "(Lcom/jetbrains/clones/toolwindow/DuplicateEntry;)V", "getRight", "setRight", "createDiffContent", "Lcom/intellij/diff/contents/DocumentContent;", "fragment", "Lcom/jetbrains/clones/structures/TextFragment;", "dispose", "", "update", "intellij.platform.duplicatesDetector"})
final class DiffController
implements Disposable {
    private final DiffRequestPanel diffPanel;
    @NotNull
    private DuplicateEntry left;
    @NotNull
    private DuplicateEntry right;

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.diffPanel));
    }

    @NotNull
    public final DuplicateEntry getLeft() {
        return this.left;
    }

    public final void setLeft(@NotNull DuplicateEntry value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.left == value) {
            return;
        }
        this.left.getLeftButton().setSelected(false);
        this.left = value;
        value.getLeftButton().setSelected(true);
        this.update();
    }

    @NotNull
    public final DuplicateEntry getRight() {
        return this.right;
    }

    public final void setRight(@NotNull DuplicateEntry value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.right == value) {
            return;
        }
        this.right.getRightButton().setSelected(false);
        this.right = value;
        value.getRightButton().setSelected(true);
        this.update();
    }

    @NotNull
    public final JComponent getComponent() {
        JComponent jComponent = this.diffPanel.getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"diffPanel.component");
        return jComponent;
    }

    private final void update() {
        SimpleDiffRequest simpleDiffRequest;
        DocumentContent documentContent = this.createDiffContent(this.left.getDuplicate());
        if (documentContent != null) {
            DocumentContent documentContent2;
            DocumentContent leftContent = documentContent2 = documentContent;
            DocumentContent documentContent3 = this.createDiffContent(this.right.getDuplicate());
            if (documentContent3 != null) {
                DocumentContent documentContent4;
                DocumentContent rightContent = documentContent4 = documentContent3;
                simpleDiffRequest = new SimpleDiffRequest(null, (DiffContent)leftContent, (DiffContent)rightContent, this.left.getDescriptionText(), this.right.getDescriptionText());
            } else {
                simpleDiffRequest = null;
            }
        } else {
            simpleDiffRequest = null;
        }
        SimpleDiffRequest request = simpleDiffRequest;
        this.diffPanel.setRequest((DiffRequest)request);
    }

    private final DocumentContent createDiffContent(TextFragment fragment) {
        return PreviewPanel.createContent(this.left.getProject(), fragment);
    }

    public DiffController(@NotNull DuplicateEntry left, @NotNull DuplicateEntry right) {
        DiffRequestPanel diffRequestPanel;
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        DiffRequestPanel diffRequestPanel2 = DiffManager.getInstance().createRequestPanel(null, (Disposable)this, null);
        DiffController diffController = this;
        DiffRequestPanel $receiver = diffRequestPanel2;
        $receiver.putContextHints(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        DiffRequestPanel diffRequestPanel3 = diffRequestPanel = diffRequestPanel2;
        Intrinsics.checkExpressionValueIsNotNull((Object)diffRequestPanel3, (String)"DiffManager.getInstance(\u2026.FORCE_READ_ONLY, true) }");
        diffController.diffPanel = diffRequestPanel3;
        this.left = left;
        this.right = right;
        left.getLeftButton().setSelected(true);
        right.getRightButton().setSelected(true);
        this.update();
    }
}

