/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model.renderers;

import com.intellij.guice.utils.GuiceUtils;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import icons.GuiceIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiceBindingClassPsiElementListCellRenderer
extends PsiElementListCellRenderer {
    public String getElementText(PsiElement element) {
        StringBuilder sb;
        PsiMethodCallExpression methodCallExpression;
        if (element instanceof PsiMethodCallExpression && GuiceBindingClassPsiElementListCellRenderer.addExpressionText(methodCallExpression = (PsiMethodCallExpression)element, sb = new StringBuilder(), "bind", true)) {
            GuiceBindingClassPsiElementListCellRenderer.addToBinding(methodCallExpression, sb, "annotatedWith");
            if (GuiceBindingClassPsiElementListCellRenderer.addToBinding(methodCallExpression, sb, "to")) {
                return sb.toString();
            }
            if (GuiceBindingClassPsiElementListCellRenderer.addToBinding(methodCallExpression, sb, "toInstance")) {
                return sb.toString();
            }
            if (GuiceBindingClassPsiElementListCellRenderer.addToBinding(methodCallExpression, sb, "toProvider")) {
                return sb.toString();
            }
            if (GuiceBindingClassPsiElementListCellRenderer.addToBinding(methodCallExpression, sb, "toConstructor")) {
                return sb.toString();
            }
        }
        return SymbolPresentationUtil.getSymbolPresentableText((PsiElement)element);
    }

    private static boolean addToBinding(@NotNull PsiMethodCallExpression element, @NotNull StringBuilder sb, @NotNull String methodName) {
        if (element == null) {
            GuiceBindingClassPsiElementListCellRenderer.$$$reportNull$$$0(0);
        }
        if (sb == null) {
            GuiceBindingClassPsiElementListCellRenderer.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            GuiceBindingClassPsiElementListCellRenderer.$$$reportNull$$$0(2);
        }
        return GuiceBindingClassPsiElementListCellRenderer.addExpressionText(element, sb, methodName, false);
    }

    private static boolean addExpressionText(@NotNull PsiMethodCallExpression element, @NotNull StringBuilder sb, @NotNull String methodName, boolean firstElementInChain) {
        PsiMethodCallExpression to;
        if (element == null) {
            GuiceBindingClassPsiElementListCellRenderer.$$$reportNull$$$0(3);
        }
        if (sb == null) {
            GuiceBindingClassPsiElementListCellRenderer.$$$reportNull$$$0(4);
        }
        if (methodName == null) {
            GuiceBindingClassPsiElementListCellRenderer.$$$reportNull$$$0(5);
        }
        if ((to = GuiceUtils.findCallInChain(element, methodName)) != null) {
            if (!firstElementInChain) {
                sb.append(".");
            }
            sb.append(methodName);
            sb.append("(");
            sb.append(GuiceBindingClassPsiElementListCellRenderer.getExpressionText(to.getArgumentList().getExpressions()[0]));
            sb.append(")");
            return true;
        }
        return false;
    }

    private static String getExpressionText(@NotNull PsiExpression expression) {
        if (expression == null) {
            GuiceBindingClassPsiElementListCellRenderer.$$$reportNull$$$0(6);
        }
        if (expression instanceof PsiClassObjectAccessExpression) {
            return expression.getText();
        }
        if (expression instanceof PsiNewExpression) {
            PsiType expressionType = expression.getType();
            if (expressionType != null) {
                boolean hasArgs;
                StringBuilder sb = new StringBuilder("new ");
                sb.append(expressionType.getPresentableText());
                sb.append("(");
                PsiExpressionList list = ((PsiNewExpression)expression).getArgumentList();
                boolean bl = hasArgs = list != null && list.getExpressions().length > 0;
                if (hasArgs) {
                    sb.append("...");
                }
                sb.append(")");
                if (expressionType instanceof PsiClassType && ((PsiClassType)expressionType).resolve() instanceof PsiAnonymousClass) {
                    sb.append("{...}");
                }
                return sb.toString();
            }
            return expression.getText();
        }
        return expression.getText();
    }

    @Nullable
    protected String getContainerText(PsiElement element, String name) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (psiClass != null) {
            return SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass);
        }
        return SymbolPresentationUtil.getSymbolContainerText((PsiElement)element);
    }

    protected Icon getIcon(PsiElement element) {
        return GuiceIcons.Google_small;
    }

    protected int getIconFlags() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/guice/model/renderers/GuiceBindingClassPsiElementListCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addToBinding";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addExpressionText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

