/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.guice.constants.GuiceAnnotations;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiceUtils {
    private GuiceUtils() {
    }

    public static boolean isInstantiable(PsiClass referentClass) {
        if (referentClass.isInterface() || referentClass.isEnum() || referentClass.isAnnotationType() || referentClass.hasModifierProperty("abstract")) {
            return false;
        }
        PsiMethod[] constructors = referentClass.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor : constructors) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)constructor, GuiceAnnotations.INJECTS, (int)1)) {
                return true;
            }
            if (constructor.getParameterList().getParametersCount() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean provides(PsiClass providerClass, PsiClass providedClass) {
        PsiMethod[] allMethods;
        if (InheritanceUtil.isInheritor((PsiClass)providerClass, (String)"com.google.inject.Provider")) {
            return providedClass.equals(GuiceUtils.getProvidedMethodType(providerClass));
        }
        for (PsiMethod method : allMethods = providerClass.getAllMethods()) {
            PsiType returnType;
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"com.google.inject.Provides", (int)1) || !((returnType = method.getReturnType()) instanceof PsiClassType) || !providedClass.equals(((PsiClassType)returnType).resolve())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiClass getProvidedType(@Nullable PsiClass providerClass) {
        if (providerClass != null && InheritanceUtil.isInheritor((PsiClass)providerClass, (String)"com.google.inject.Provider")) {
            return GuiceUtils.getProvidedMethodType(providerClass);
        }
        return null;
    }

    private static PsiClass getProvidedMethodType(@NotNull PsiClass providerClass) {
        PsiMethod[] methods;
        if (providerClass == null) {
            GuiceUtils.$$$reportNull$$$0(0);
        }
        for (PsiMethod method : methods = providerClass.findMethodsByName("get", true)) {
            PsiType returnType;
            if (method.getParameterList().getParametersCount() != 0 || !((returnType = method.getReturnType()) instanceof PsiClassType)) continue;
            return ((PsiClassType)returnType).resolve();
        }
        return null;
    }

    public static boolean isBinding(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression containingCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)true);
        if (containingCall != null) {
            return false;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
        PsiMethod method = callExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"com.google.inject.binder.ScopedBindingBuilder");
    }

    @Nullable
    public static PsiClass findImplementedClassForBinding(PsiMethodCallExpression call) {
        return GuiceUtils.getClassArgumentOfCallInChain(call, "bind");
    }

    @Nullable
    public static PsiMethodCallExpression findCallInChain(PsiMethodCallExpression call, String name) {
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (name.equals(methodName)) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 1) {
                return call;
            }
            return null;
        }
        PsiElement qualifier = methodExpression.getQualifier();
        if (!(qualifier instanceof PsiMethodCallExpression)) {
            return null;
        }
        return GuiceUtils.findCallInChain((PsiMethodCallExpression)qualifier, name);
    }

    @Nullable
    public static PsiExpression getArgumentOfCallInChain(PsiMethodCallExpression call, String name) {
        PsiMethodCallExpression inCall = GuiceUtils.findCallInChain(call, name);
        return inCall != null ? inCall.getArgumentList().getExpressions()[0] : null;
    }

    @Nullable
    private static PsiClass getClassArgumentOfCallInChain(PsiMethodCallExpression call, String name) {
        PsiExpression expression = GuiceUtils.getArgumentOfCallInChain(call, name);
        if (!(expression instanceof PsiClassObjectAccessExpression)) {
            return null;
        }
        PsiType classType = ((PsiClassObjectAccessExpression)expression).getOperand().getType();
        if (classType instanceof PsiClassType) {
            return ((PsiClassType)classType).resolve();
        }
        return null;
    }

    @Nullable
    public static PsiClass findImplementingClassForBinding(PsiMethodCallExpression call) {
        return GuiceUtils.getClassArgumentOfCallInChain(call, "to");
    }

    @Nullable
    public static PsiClass findProvidingClassForBinding(PsiMethodCallExpression call) {
        return GuiceUtils.getClassArgumentOfCallInChain(call, "toProvider");
    }

    @Nullable
    public static PsiExpression findScopeForBinding(PsiMethodCallExpression call) {
        return GuiceUtils.getArgumentOfCallInChain(call, "in");
    }

    @Nullable
    public static PsiMethodCallExpression findScopeCallForBinding(PsiMethodCallExpression call) {
        return GuiceUtils.findCallInChain(call, "in");
    }

    @Nullable
    public static PsiMethodCallExpression findProvidingCallForBinding(PsiMethodCallExpression call) {
        return GuiceUtils.findCallInChain(call, "toProvider");
    }

    @Nullable
    public static PsiMethodCallExpression findBindingCallForBinding(PsiMethodCallExpression call) {
        return GuiceUtils.findCallInChain(call, "to");
    }

    @Nullable
    public static PsiMethodCallExpression findAnnotatedWithCallForBinding(PsiMethodCallExpression call) {
        return GuiceUtils.findCallInChain(call, "annotatedWith");
    }

    @Nullable
    public static String getScopeAnnotationForScopeExpression(PsiExpression arg) {
        if (!(arg instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arg;
        PsiElement referent = referenceExpression.resolve();
        if (!(referent instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)referent;
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return null;
        }
        String className = aClass.getQualifiedName();
        String fieldName = field.getName();
        if ("SINGLETON".equals(fieldName) && "com.google.inject.Scopes".equals(className)) {
            return "com.google.inject.Singleton";
        }
        if ("REQUEST".equals(fieldName) && "com.google.inject.servlet.ServletScopes".equals(className)) {
            return "com.google.inject.servlet.RequestScoped";
        }
        if ("SESSION".equals(fieldName) && "com.google.inject.servlet.ServletScopes".equals(className)) {
            return "com.google.inject.servlet.SessionScoped";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerClass", "com/intellij/guice/utils/GuiceUtils", "getProvidedMethodType"));
    }
}

