/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.agent;

import com.intellij.javaee.oss.admin.DeploymentStatusWrapper;
import com.intellij.javaee.oss.admin.ModuleTypeWrapper;
import com.intellij.javaee.oss.agent.AgentCallback;
import com.intellij.javaee.oss.agent.AgentDeploymentCallback;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.VendorSpecificAgentBase;
import com.intellij.javaee.oss.geronimo.agent.GeronimoDeploymentModel;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.util.AgentDeployStateChecker;
import com.intellij.javaee.util.AgentServerInstancePoller;
import com.intellij.javaee.util.IDeployStateChecker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public abstract class GeronimoAgentBase
extends VendorSpecificAgentBase {
    private static final Map<ModuleTypeWrapper, ModuleType> MODULE_TYPES = new HashMap<ModuleTypeWrapper, ModuleType>();
    private AgentServerInstancePoller myPoller;
    private DeploymentManager myDeploymentManager;

    protected final MBeanServerConnection createConnection() throws IOException {
        String[] credentials = new String[]{this.getUsername(), this.getPassword()};
        Map<String, String[]> env = Collections.singletonMap("jmx.remote.credentials", credentials);
        String url = "service:jmx:rmi://" + this.getHost() + "/jndi/rmi://" + this.getHost() + ':' + this.getPort() + "/JMXConnector";
        return JMXConnectorFactory.connect(new JMXServiceURL(url), env).getMBeanServerConnection();
    }

    public void init(String host, int port, String username, String password, ParametersMap initParameters, AgentCallback callback) {
        super.init(host, port, username, password, initParameters, callback);
        this.myPoller = new AgentServerInstancePoller(this.getLog());
        this.myPoller.onInstanceStart();
    }

    public boolean connect() {
        if (!this.connectKernel()) {
            return false;
        }
        if (this.myDeploymentManager == null) {
            try {
                DeploymentFactoryManager factory = DeploymentFactoryManager.getInstance();
                factory.registerDeploymentFactory(this.getDeploymentFactory());
                this.myDeploymentManager = factory.getDeploymentManager(GeronimoAgentBase.getDeployerUrl(this.getHost(), this.getPort()), this.getUsername(), this.getPassword());
            }
            catch (DeploymentManagerCreationException e) {
                this.getLog().debugEx((Exception)((Object)e));
                return false;
            }
        }
        return true;
    }

    private static String getDeployerUrl(String host, int port) {
        return "deployer:geronimo:jmx://" + host + ':' + port;
    }

    public void destroy() {
        if (this.myDeploymentManager != null) {
            this.myDeploymentManager.release();
            this.myDeploymentManager = null;
        }
        if (this.myPoller != null) {
            this.myPoller.onInstanceShutdown();
            this.myPoller = null;
        }
    }

    public void startDeploy(final String deploymentName, final File source, ParametersMap deployParameters, AgentDeploymentCallback callback) {
        new DeploymentJob(deploymentName, callback){
            private TargetModuleID[] myModuleIDs;

            @Override
            protected void doJob(final String moduleName, final ModuleType moduleType) {
                GeronimoAgentBase.this.myPoller.putDeployStateChecker((IDeployStateChecker)new SteppedDeployStateChecker(new CheckerStep[]{new ProgressCheckerStep(){

                    @Override
                    protected ProgressObject createProgress() {
                        return GeronimoAgentBase.this.myDeploymentManager.distribute(GeronimoAgentBase.this.myDeploymentManager.getTargets(), source, null);
                    }
                }, new CheckerStep(){

                    @Override
                    public boolean check() throws TargetException {
                        1.access$202(this, GeronimoAgentBase.this.getTargetModuleIDs(GeronimoAgentBase.this.myDeploymentManager.getNonRunningModules(moduleType, GeronimoAgentBase.this.myDeploymentManager.getTargets()), moduleName));
                        return myModuleIDs.length > 0;
                    }
                }, new ProgressCheckerStep(){

                    @Override
                    protected ProgressObject createProgress() {
                        return GeronimoAgentBase.this.myDeploymentManager.start(myModuleIDs);
                    }
                }}){

                    public String getDeploymentModel() {
                        return deploymentName;
                    }

                    @Override
                    protected void onSuccess() {
                        this.setDeploymentStatus(DeploymentStatusWrapper.STATUS_DEPLOYED);
                    }

                    @Override
                    protected void onFail(Exception e) {
                        this.onException(e);
                    }
                });
            }

            @Override
            protected void onException(Exception e) {
                this.setDeploymentStatus(DeploymentStatusWrapper.STATUS_FAILED, e);
            }

            static /* synthetic */ TargetModuleID[] access$202(1 x0, TargetModuleID[] x1) {
                x0.myModuleIDs = x1;
                return x1;
            }
        }.perform();
    }

    private TargetModuleID[] getTargetModuleIDs(TargetModuleID[] modules, String name) {
        ArrayList<TargetModuleID> list = new ArrayList<TargetModuleID>();
        if (modules != null && name != null) {
            int pos = name.indexOf(124);
            if (pos >= 0) {
                String target = name.substring(0, pos);
                String id = name.substring(pos + 1);
                for (TargetModuleID module : modules) {
                    if (!module.getTarget().getName().equals(target) || !this.matches(module, id)) continue;
                    list.add(module);
                }
            }
            if (list.isEmpty()) {
                for (TargetModuleID module : modules) {
                    if (!this.matches(module, name)) continue;
                    list.add(module);
                }
            }
        }
        return list.toArray(new TargetModuleID[0]);
    }

    public void startUndeploy(final String deploymentName, AgentDeploymentCallback callback) {
        new DeploymentJob(deploymentName, callback){

            @Override
            protected void doJob(final String moduleName, final ModuleType moduleType) {
                GeronimoAgentBase.this.myPoller.putDeployStateChecker((IDeployStateChecker)new SteppedDeployStateChecker(new CheckerStep[]{new ProgressCheckerStep(){

                    @Override
                    protected ProgressObject createProgress() throws TargetException {
                        return GeronimoAgentBase.this.myDeploymentManager.stop(GeronimoAgentBase.this.getTargetModuleIDs(GeronimoAgentBase.this.myDeploymentManager.getRunningModules(moduleType, GeronimoAgentBase.this.myDeploymentManager.getTargets()), moduleName));
                    }
                }, new ProgressCheckerStep(){

                    @Override
                    protected ProgressObject createProgress() throws TargetException {
                        return GeronimoAgentBase.this.myDeploymentManager.undeploy(GeronimoAgentBase.this.getTargetModuleIDs(GeronimoAgentBase.this.myDeploymentManager.getNonRunningModules(moduleType, GeronimoAgentBase.this.myDeploymentManager.getTargets()), moduleName));
                    }
                }}){

                    public String getDeploymentModel() {
                        return deploymentName;
                    }

                    @Override
                    protected void onSuccess() {
                        this.setDeploymentStatus(DeploymentStatusWrapper.STATUS_NOT_DEPLOYED);
                    }

                    @Override
                    protected void onFail(Exception e) {
                        this.onException(e);
                    }
                });
            }

            @Override
            protected void onException(Exception e) {
                this.setDeploymentStatus(DeploymentStatusWrapper.STATUS_UNKNOWN, e);
            }
        }.perform();
    }

    public void updateDeploymentStatus(String deploymentName, AgentDeploymentCallback callback) {
        new DeploymentJob(deploymentName, callback){

            @Override
            protected void doJob(String moduleName, ModuleType moduleType) {
                try {
                    boolean deployed = GeronimoAgentBase.this.getTargetModuleIDs(GeronimoAgentBase.this.myDeploymentManager.getRunningModules(moduleType, GeronimoAgentBase.this.myDeploymentManager.getTargets()), moduleName).length != 0;
                    this.setDeploymentStatus(deployed ? DeploymentStatusWrapper.STATUS_DEPLOYED : DeploymentStatusWrapper.STATUS_NOT_DEPLOYED);
                }
                catch (TargetException e) {
                    this.onException((Exception)((Object)e));
                }
            }

            @Override
            protected void onException(Exception e) {
                this.setDeploymentStatus(DeploymentStatusWrapper.STATUS_UNKNOWN, e);
            }
        }.perform();
    }

    protected abstract boolean connectKernel();

    protected abstract DeploymentFactory getDeploymentFactory();

    protected abstract boolean matches(TargetModuleID var1, String var2);

    static {
        MODULE_TYPES.put(ModuleTypeWrapper.EAR, ModuleType.EAR);
        MODULE_TYPES.put(ModuleTypeWrapper.EJB, ModuleType.EJB);
        MODULE_TYPES.put(ModuleTypeWrapper.WAR, ModuleType.WAR);
    }

    private static abstract class SteppedDeployStateChecker
    implements AgentDeployStateChecker {
        private final Iterator<CheckerStep> myStepIterator;
        private CheckerStep myCurrentStep;

        SteppedDeployStateChecker(CheckerStep ... steps) {
            this.myStepIterator = Arrays.asList(steps).iterator();
            this.myCurrentStep = this.myStepIterator.next();
        }

        public boolean check() {
            Boolean stepResult;
            try {
                stepResult = this.myCurrentStep.check();
            }
            catch (TargetException e) {
                this.onFail((Exception)((Object)e));
                return true;
            }
            catch (JavaeeProcessUtilException e) {
                this.onFail((Exception)((Object)e));
                return true;
            }
            if (stepResult.booleanValue()) {
                if (this.myStepIterator.hasNext()) {
                    this.myCurrentStep = this.myStepIterator.next();
                    return false;
                }
                this.onSuccess();
                return true;
            }
            return false;
        }

        protected abstract void onSuccess();

        protected abstract void onFail(Exception var1);
    }

    private static abstract class ProgressCheckerStep
    implements CheckerStep {
        private ProgressObject myProgress;
        private boolean myRunning;
        private String myErrors;

        private ProgressCheckerStep() {
        }

        @Override
        public boolean check() throws TargetException, JavaeeProcessUtilException {
            if (this.myProgress == null) {
                this.myProgress = this.createProgress();
                this.myRunning = this.myProgress.getDeploymentStatus().isRunning();
                if (this.myRunning) {
                    this.myProgress.addProgressListener(new ProgressListener(){

                        public void handleProgressEvent(ProgressEvent event) {
                            if (event.getDeploymentStatus().isFailed()) {
                                ProgressCheckerStep.this.myErrors = event.getDeploymentStatus().getMessage();
                            }
                            ProgressCheckerStep.this.myRunning = event.getDeploymentStatus().isRunning();
                            if (!ProgressCheckerStep.this.myRunning) {
                                ProgressCheckerStep.this.myProgress.removeProgressListener((ProgressListener)this);
                            }
                        }
                    });
                }
            }
            if (this.myRunning) {
                return false;
            }
            if (this.myErrors != null) {
                throw new JavaeeProcessUtilException(this.myErrors);
            }
            return true;
        }

        protected abstract ProgressObject createProgress() throws TargetException;
    }

    private static interface CheckerStep {
        public boolean check() throws TargetException, JavaeeProcessUtilException;
    }

    private static abstract class DeploymentJob {
        private final String myDeploymentName;
        private final AgentDeploymentCallback myCallback;

        DeploymentJob(String deploymentName, AgentDeploymentCallback callback) {
            this.myDeploymentName = deploymentName;
            this.myCallback = callback;
        }

        public void perform() {
            try {
                GeronimoDeploymentModel deploymentModel = GeronimoDeploymentModel.load(this.myDeploymentName);
                this.doJob(deploymentModel.getName(), (ModuleType)MODULE_TYPES.get(deploymentModel.getModuleType()));
            }
            catch (JavaeeProcessUtilException e) {
                this.onException((Exception)((Object)e));
            }
        }

        protected void setDeploymentStatus(DeploymentStatusWrapper status) {
            this.myCallback.setDeploymentStatus(this.myDeploymentName, status.getName());
        }

        protected void setDeploymentStatus(DeploymentStatusWrapper status, Exception e) {
            this.myCallback.setDeploymentStatusWithError(this.myDeploymentName, status.getName(), e);
        }

        protected abstract void doJob(String var1, ModuleType var2);

        protected abstract void onException(Exception var1);
    }
}

