/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.server;

import com.intellij.javaee.oss.geronimo.server.GeronimoLocalModel;
import com.intellij.javaee.oss.geronimo.server.GeronimoPortConfig;
import com.intellij.javaee.oss.server.JavaeePortConfig;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatServerXmlWrapper;

public class GeronimoHttpPortConfig
extends GeronimoPortConfig {
    private static final String HTTP_CONFIG = "(:?tomcat|jetty)\\d*";
    private static final String HTTP_GBEAN = "(?:Tomcat|Jetty)WebConnector";
    private static final String HTTP_FACTORY_KEY = "http";
    private static final JavaeePortConfig.Factory<GeronimoLocalModel> LOCAL = new GeronimoPortConfig.GeronimoFactoryBase("http"){

        @Override
        @NotNull
        public JavaeePortConfig createConfig(GeronimoLocalModel data) {
            GeronimoHttpPortConfig geronimoHttpPortConfig = new GeronimoHttpPortConfig(data.getHome());
            if (geronimoHttpPortConfig == null) {
                1.$$$reportNull$$$0(0);
            }
            return geronimoHttpPortConfig;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/geronimo/server/GeronimoHttpPortConfig$1", "createConfig"));
        }
    };
    private final File myServerXml;
    private final GeronimoTomcatServerXmlWrapper myServerXmlWrapper;

    private GeronimoHttpPortConfig(String home) {
        super(home, HTTP_CONFIG, HTTP_GBEAN);
        this.myServerXml = new File(home, FileUtil.toSystemDependentName((String)"var/catalina/server.xml"));
        this.myServerXmlWrapper = new GeronimoTomcatServerXmlWrapper();
    }

    @Override
    protected long getStamp(JavaeeServerModel data) {
        return super.getStamp(data) ^ GeronimoHttpPortConfig.getStamp((File)this.myServerXml);
    }

    @Override
    protected int getPort(JavaeeServerModel model) {
        if (this.myServerXml.exists()) {
            return this.myServerXmlWrapper.getHttpPort();
        }
        return super.getPort(model);
    }

    public static int getLocal(GeronimoLocalModel model) {
        return GeronimoHttpPortConfig.get(LOCAL, (JavaeeServerModel)model, (int)model.getDefaultPort());
    }

    private class GeronimoTomcatServerXmlWrapper
    extends TomcatServerXmlWrapper {
        private final GeronimoHttpPortHandler myHttpPortHandler;

        protected GeronimoTomcatServerXmlWrapper() {
            super(GeronimoHttpPortConfig.this.myServerXml);
            this.myHttpPortHandler = new GeronimoHttpPortHandler();
        }

        public int getHttpPort() {
            return this.myHttpPortHandler.getPort();
        }

        private class GeronimoHttpPortHandler
        extends TomcatServerXmlWrapper.HttpPortHandler {
            private GeronimoHttpPortHandler() {
                super((TomcatServerXmlWrapper)GeronimoTomcatServerXmlWrapper.this);
            }

            protected int parsePort(String port) throws NumberFormatException {
                return GeronimoHttpPortConfig.this.parse(port);
            }
        }
    }
}

