/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.ParserAction;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public abstract class OutputParser {
    protected final List<ParserAction> myParserActions = new ArrayList<ParserAction>(10);

    public boolean processMessageLine(Callback callback) {
        String string = callback.getNextLine();
        if (string == null) {
            return false;
        }
        for (ParserAction parserAction : this.myParserActions) {
            if (!parserAction.execute(string, callback)) continue;
            return true;
        }
        return StringUtil.startsWithChar((CharSequence)string, (char)'[') && StringUtil.endsWithChar((CharSequence)string, (char)']');
    }

    protected static void addMessage(Callback callback, CompilerMessageCategory type, String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        OutputParser.addMessage(callback, type, message, null, -1, -1);
    }

    protected static void addMessage(Callback callback, CompilerMessageCategory type, String text2, String url, int line, int column) {
        callback.message(type, text2, url, line, column);
    }

    public static interface Callback {
        public String getNextLine();

        public String getCurrentLine();

        public void pushBack(String var1);

        public void setProgressText(String var1);

        public void fileProcessed(String var1);

        public void fileGenerated(String var1);

        public void message(CompilerMessageCategory var1, String var2, @NonNls String var3, int var4, int var5);
    }
}

