/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import b.a.lb;
import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.PathElement;
import com.intellij.compiler.ant.taskdefs.PatternSetRef;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class LibraryDefinitionsGeneratorFactory {
    private final ProjectEx a;
    private final GenerationOptions b;
    private final Set<String> c = new HashSet<String>();
    private static final long d = lb.a(7468722597523438759L, -3158545380584678811L, MethodHandles.lookup().lookupClass()).a(4919839160897L);

    public LibraryDefinitionsGeneratorFactory(ProjectEx project2, GenerationOptions genOptions) {
        Module[] moduleArray;
        this.a = project2;
        this.b = genOptions;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        for (Module module2 : moduleArray = moduleManager.getModules()) {
            ModuleRootManager.getInstance((Module)module2).orderEntries().forEachLibrary(library -> {
                String string = library.getName();
                if (string != null) {
                    this.c.add(string);
                }
                return true;
            });
        }
    }

    @Nullable
    public Generator create(LibraryTable libraryTable, File baseDir, String comment) {
        Library[] libraryArray = libraryTable.getLibraries();
        if (libraryArray.length == 0) {
            return null;
        }
        CompositeGenerator compositeGenerator = new CompositeGenerator();
        compositeGenerator.add((Generator)new Comment(comment), 1);
        TreeMap<String, Library> treeMap = new TreeMap<String, Library>();
        for (Library library2 : libraryArray) {
            String string = library2.getName();
            if (!this.c.contains(string)) continue;
            treeMap.put(BuildProperties.getLibraryPathId((String)string), library2);
        }
        for (Library library : treeMap.values()) {
            Library library2;
            String string = library.getName();
            library2 = new Path(BuildProperties.getLibraryPathId((String)string));
            LibraryDefinitionsGeneratorFactory.genLibraryContent(this.a, this.b, library, baseDir, (CompositeGenerator)library2);
            compositeGenerator.add((Generator)library2, 1);
        }
        return compositeGenerator.getGeneratorCount() > 0 ? compositeGenerator : null;
    }

    public static void genLibraryContent(ProjectEx project2, GenerationOptions genOptions, Library library, File baseDir, CompositeGenerator libraryPath) {
        LibraryDefinitionsGeneratorFactory.genLibraryContent(genOptions, library, OrderRootType.CLASSES, baseDir, libraryPath);
    }

    public static void genLibraryContent(GenerationOptions genOptions, Library library, OrderRootType rootType, File baseDir, CompositeGenerator libraryPath) {
        long l2 = d ^ 0x13AB16AB2266L;
        if (genOptions.expandJarDirectories) {
            VirtualFile[] virtualFileArray = library.getFiles(rootType);
            TreeSet<String> treeSet = new TreeSet<String>();
            for (VirtualFile virtualFile : virtualFileArray) {
                String string = GenerationUtils.toRelativePath((VirtualFile)virtualFile, (File)baseDir, (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)genOptions);
                treeSet.add(string);
            }
            for (String string : treeSet) {
                libraryPath.add((Generator)new PathElement(string));
            }
        } else {
            TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(library.getUrls(rootType)));
            for (String string : treeSet) {
                File file = LibraryDefinitionsGeneratorFactory.a(string);
                String string2 = GenerationUtils.toRelativePath((String)file.getPath(), (File)baseDir, (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)genOptions);
                if (string.startsWith("jar://")) {
                    libraryPath.add((Generator)new PathElement(string2));
                    continue;
                }
                if (string.startsWith("file://")) {
                    if (library.isJarDirectory(string, rootType)) {
                        FileSet fileSet = new FileSet(string2);
                        fileSet.add((Generator)new PatternSetRef("library.patterns"));
                        libraryPath.add((Generator)fileSet);
                        continue;
                    }
                    libraryPath.add((Generator)new PathElement(string2));
                    continue;
                }
                throw new IllegalStateException("Unknown url type: " + string);
            }
        }
    }

    private static File a(String string) {
        String string2;
        long l2 = d ^ 0x3B1151661E1FL;
        if (string.startsWith("jar://") && string.endsWith("!/")) {
            string2 = string.substring("jar://".length(), string.length() - "!/".length());
        } else if (string.startsWith("file://")) {
            string2 = string.substring("jar://".length());
        } else {
            throw new IllegalArgumentException("Unknown url type: " + string);
        }
        return new File(string2.replace('/', File.separatorChar));
    }
}

