/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import b.a.lb;
import com.intellij.compiler.impl.FileProcessingCompilerStateCache;
import com.intellij.compiler.impl.GenericCompilerRunner;
import com.intellij.compiler.impl.generic.GenericCompilerCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityStateFactory;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompilerCacheManager
implements Disposable {
    private static final Logger e;
    private final Map<Compiler, Object> a = new HashMap<Compiler, Object>();
    private final Map<GenericCompiler<?, ?, ?>, GenericCompilerCache<?, ?, ?>> b = new HashMap();
    private final List<Disposable> f = new ArrayList<Disposable>();
    private final File d;
    private final Project c;
    private static final long g;

    public CompilerCacheManager(Project project2) {
        this.c = project2;
        this.d = CompilerPaths.getCacheStoreDirectory((Project)project2);
    }

    public static CompilerCacheManager getInstance(Project project2) {
        return (CompilerCacheManager)project2.getComponent(CompilerCacheManager.class);
    }

    public void dispose() {
        this.flushCaches();
    }

    private File a(Compiler compiler) {
        File file = new File(this.d, CompilerCacheManager.getCompilerIdString(compiler));
        file.mkdirs();
        return file;
    }

    synchronized <Key, SourceState, OutputState> GenericCompilerCache<Key, SourceState, OutputState> getGenericCompilerCache(GenericCompiler<Key, SourceState, OutputState> compiler) throws IOException {
        GenericCompilerCache<Object, Object, Object> genericCompilerCache = this.b.get(compiler);
        if (genericCompilerCache == null) {
            GenericCompilerCache genericCompilerCache2 = new GenericCompilerCache(compiler, GenericCompilerRunner.getGenericCompilerCacheDir(this.c, compiler));
            this.b.put(compiler, genericCompilerCache2);
            this.f.add(() -> {
                long l2 = g ^ 0x6098F4D4CB0AL;
                if (e.isDebugEnabled()) {
                    e.debug("Closing cache for feneric compiler " + compiler.getId());
                }
                genericCompilerCache2.close();
            });
            genericCompilerCache = genericCompilerCache2;
        }
        return genericCompilerCache;
    }

    synchronized FileProcessingCompilerStateCache getFileProcessingCompilerCache(FileProcessingCompiler compiler) throws IOException {
        Object object = this.a.get(compiler);
        if (object == null) {
            File file = this.a((Compiler)compiler);
            FileProcessingCompilerStateCache fileProcessingCompilerStateCache = new FileProcessingCompilerStateCache(file, (ValidityStateFactory)compiler);
            this.a.put((Compiler)compiler, fileProcessingCompilerStateCache);
            this.f.add(() -> {
                long l2 = g ^ 0x489B34064526L;
                if (e.isDebugEnabled()) {
                    e.debug("Closing cache for compiler " + compiler.getDescription() + "; cache root dir: " + file);
                }
                fileProcessingCompilerStateCache.close();
            });
            object = fileProcessingCompilerStateCache;
        } else {
            e.assertTrue(object instanceof FileProcessingCompilerStateCache);
        }
        return (FileProcessingCompilerStateCache)object;
    }

    public static String getCompilerIdString(Compiler compiler) {
        long l2 = g ^ 0x3CFB783C3D60L;
        String string = compiler.getDescription();
        return string.replaceAll("\\s+", "_").replaceAll("[\\.\\?]", "_").toLowerCase();
    }

    synchronized void flushCaches() {
        for (Disposable disposable : this.f) {
            try {
                Disposer.dispose((Disposable)disposable);
            }
            catch (Throwable throwable) {
                e.info(throwable);
            }
        }
        this.f.clear();
        this.b.clear();
        this.a.clear();
    }

    public void clearCaches(CompileContext context) {
        long l2 = g ^ 0x17389D68FA1EL;
        this.flushCaches();
        File[] fileArray = this.d.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                boolean bl2 = FileUtil.delete((File)file);
                if (bl2) continue;
                context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.failed.to.delete", (Object[])new Object[]{file.getPath()}), null, -1, -1);
            }
        }
    }

    static {
        g = lb.a(-45796663176945184L, 244536293914617008L, MethodHandles.lookup().lookupClass()).a(138966159670836L);
        long l2 = g ^ 0x17C93B950715L;
        e = Logger.getInstance((String)"#com.intellij.compiler.impl.CompilerCacheManager");
    }
}

