/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import b.a.lb;
import com.intellij.compiler.impl.StateCache;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ValidityStateFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class FileProcessingCompilerStateCache {
    private static final Logger a;
    private final StateCache<MyState> b;
    private static final long c;

    public FileProcessingCompilerStateCache(File storeDirectory, final ValidityStateFactory stateFactory) throws IOException {
        long l2 = c ^ 0x5F03359C2EBDL;
        this.b = new StateCache<MyState>(new File(storeDirectory, "timestamps")){

            @Override
            public MyState read(DataInput stream2) throws IOException {
                return new MyState(stream2.readLong(), stateFactory.createValidityState(stream2));
            }

            @Override
            public void write(MyState state, DataOutput out) throws IOException {
                out.writeLong(state.getTimestamp());
                ValidityState validityState = state.getExtState();
                if (validityState != null) {
                    validityState.save(out);
                }
            }
        };
    }

    public void update(VirtualFile sourceFile, ValidityState extState) throws IOException {
        if (sourceFile.isValid()) {
            this.b.update(sourceFile.getUrl(), new MyState(sourceFile.getTimeStamp(), extState));
        }
    }

    public void remove(String url) throws IOException {
        this.b.remove(url);
    }

    public long getTimestamp(String url) throws IOException {
        MyState myState = this.b.getState(url);
        return myState != null ? myState.getTimestamp() : -1L;
    }

    public ValidityState getExtState(String url) throws IOException {
        MyState myState = this.b.getState(url);
        return myState != null ? myState.getExtState() : null;
    }

    public void force() {
        this.b.force();
    }

    public Collection<String> getUrls() throws IOException {
        return this.b.getUrls();
    }

    public boolean wipe() {
        return this.b.wipe();
    }

    public void close() {
        try {
            this.b.close();
        }
        catch (IOException iOException) {
            a.info((Throwable)iOException);
        }
    }

    static {
        c = lb.a(-4786886821234923542L, 5135868021660750895L, MethodHandles.lookup().lookupClass()).a(142633153973303L);
        long l2 = c ^ 0x6FDA2574B7C4L;
        a = Logger.getInstance((String)"#com.intellij.compiler.impl.FileProcessingCompilerStateCache");
    }

    private static class MyState
    implements Serializable {
        private final long a;
        private final ValidityState b;

        MyState(long timestamp, @Nullable ValidityState extState) {
            this.a = timestamp;
            this.b = extState;
        }

        public long getTimestamp() {
            return this.a;
        }

        @Nullable
        public ValidityState getExtState() {
            return this.b;
        }
    }
}

