/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import b.a.lb;
import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DelegatingMessageHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;

@ChannelHandler.Sharable
class BuildMessageDispatcher
extends SimpleChannelInboundHandlerAdapter<CmdlineRemoteProto.Message> {
    private static final Logger a;
    private static final AttributeKey<SessionData> d;
    private final Map<UUID, SessionData> b = new ConcurrentHashMap<UUID, SessionData>(16, 0.75f, 1);
    private final Set<UUID> c = ContainerUtil.newConcurrentSet();
    private static final long e;

    BuildMessageDispatcher() {
    }

    public void registerBuildMessageHandler(final @NotNull RequestFuture<? extends BuilderMessageHandler> future, @Nullable CmdlineRemoteProto.Message.ControllerMessage params) {
        if (future == null) {
            BuildMessageDispatcher.a(0);
        }
        DelegatingMessageHandler delegatingMessageHandler = new DelegatingMessageHandler(){
            private static final long a = lb.a(4684354450264174114L, -1695818985279180972L, MethodHandles.lookup().lookupClass()).a(22530843717373L);

            @Override
            protected BuilderMessageHandler getDelegateHandler() {
                return (BuilderMessageHandler)future.getMessageHandler();
            }

            @Override
            public void sessionTerminated(@NotNull UUID sessionId) {
                if (sessionId == null) {
                    1.b(0);
                }
                try {
                    super.sessionTerminated(sessionId);
                }
                finally {
                    future.setDone();
                }
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = a ^ 0x138B018D1217L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionId", "com/intellij/compiler/server/BuildMessageDispatcher$1", "sessionTerminated"));
            }
        };
        UUID uUID = future.getRequestID();
        this.b.put(uUID, new SessionData(uUID, delegatingMessageHandler, params));
    }

    @Nullable
    public BuilderMessageHandler unregisterBuildMessageHandler(UUID sessionId) {
        this.c.remove(sessionId);
        SessionData sessionData = this.b.remove(sessionId);
        if (sessionData == null) {
            return null;
        }
        Channel channel = sessionData.channel;
        if (channel != null) {
            channel.attr(d).set(null);
        }
        return sessionData.handler;
    }

    public void cancelSession(UUID sessionId) {
        Channel channel;
        if (this.c.add(sessionId) && (channel = this.getConnectedChannel(sessionId)) != null) {
            channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
        }
    }

    @Nullable
    public Channel getConnectedChannel(@NotNull UUID sessionId) {
        Channel channel;
        if (sessionId == null) {
            BuildMessageDispatcher.a(1);
        }
        return (channel = this.getAssociatedChannel(sessionId)) != null && channel.isActive() ? channel : null;
    }

    @Nullable
    public Channel getAssociatedChannel(@NotNull UUID sessionId) {
        SessionData sessionData;
        if (sessionId == null) {
            BuildMessageDispatcher.a(2);
        }
        return (sessionData = this.b.get(sessionId)) != null ? sessionData.channel : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBuildParameters(@NotNull UUID preloadedSessionId, @NotNull CmdlineRemoteProto.Message.ControllerMessage params) {
        if (preloadedSessionId == null) {
            BuildMessageDispatcher.a(3);
        }
        if (params == null) {
            BuildMessageDispatcher.a(4);
        }
        boolean bl2 = false;
        SessionData sessionData = this.b.get(preloadedSessionId);
        if (sessionData != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                if (sessionData.state == SessionData.State.WAITING_PARAMS) {
                    sessionData.state = SessionData.State.RUNNING;
                    Channel channel = sessionData.channel;
                    if (channel != null && channel.isActive()) {
                        sessionData.handler.buildStarted(preloadedSessionId);
                        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)preloadedSessionId, (CmdlineRemoteProto.Message.ControllerMessage)params));
                        bl2 = true;
                    }
                } else if (sessionData.state == SessionData.State.INITIAL) {
                    sessionData.params = params;
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void messageReceived(ChannelHandlerContext context, CmdlineRemoteProto.Message message) {
        UUID uUID;
        Object object;
        boolean bl2;
        long l2 = e ^ 0x5D715751E9A6L;
        SessionData sessionData = (SessionData)context.channel().attr(d).get();
        boolean bl3 = bl2 = sessionData == null;
        if (bl2) {
            object = message.getSessionId();
            uUID = new UUID(object.getMostSigBits(), object.getLeastSigBits());
            sessionData = this.b.get(uUID);
            if (sessionData != null) {
                sessionData.channel = context.channel();
                context.channel().attr(d).set((Object)sessionData);
            }
        } else {
            uUID = sessionData.sessionId;
        }
        try {
            BuilderMessageHandler builderMessageHandler = object = sessionData != null ? sessionData.handler : null;
            if (object == null) {
                a.info("No message handler registered for session " + uUID);
                return;
            }
            CmdlineRemoteProto.Message.Type type = message.getType();
            switch (type) {
                case FAILURE: {
                    object.handleFailure(uUID, message.getFailure());
                    return;
                }
                case BUILDER_MESSAGE: {
                    CmdlineRemoteProto.Message.BuilderMessage builderMessage = message.getBuilderMessage();
                    CmdlineRemoteProto.Message.BuilderMessage.Type type2 = builderMessage.getType();
                    if (type2 == CmdlineRemoteProto.Message.BuilderMessage.Type.PARAM_REQUEST) {
                        SessionData sessionData2 = sessionData;
                        synchronized (sessionData2) {
                            CmdlineRemoteProto.Message.ControllerMessage controllerMessage = sessionData.params;
                            if (controllerMessage != null) {
                                sessionData.state = SessionData.State.RUNNING;
                                object.buildStarted(uUID);
                                sessionData.params = null;
                                context.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)uUID, (CmdlineRemoteProto.Message.ControllerMessage)controllerMessage));
                            } else if (sessionData.state == SessionData.State.INITIAL) {
                                sessionData.state = SessionData.State.WAITING_PARAMS;
                            } else {
                                this.cancelSession(uUID);
                            }
                            return;
                        }
                    }
                    object.handleBuildMessage(context.channel(), uUID, builderMessage);
                    return;
                }
                default: {
                    a.info("Unsupported message type " + type);
                    return;
                }
            }
        }
        finally {
            if (bl2 && this.c.contains(uUID)) {
                context.channel().writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)uUID, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        BuilderMessageHandler builderMessageHandler;
        try {
            super.channelInactive(context);
        }
        catch (Throwable throwable) {
            BuilderMessageHandler builderMessageHandler2;
            SessionData sessionData = (SessionData)context.channel().attr(d).get();
            if (sessionData != null && (builderMessageHandler2 = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
                builderMessageHandler2.sessionTerminated(sessionData.sessionId);
            }
            throw throwable;
        }
        SessionData sessionData = (SessionData)context.channel().attr(d).get();
        if (sessionData != null && (builderMessageHandler = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
            builderMessageHandler.sessionTerminated(sessionData.sessionId);
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        if (cause != null) {
            a.info(cause);
        }
    }

    static {
        e = lb.a(-3225877812368539533L, 4020775526535544120L, MethodHandles.lookup().lookupClass()).a(269925873345922L);
        long l2 = e ^ 0x400500CADD8CL;
        a = Logger.getInstance((String)"#com.intellij.compiler.server.BuildMessageDispatcher");
        d = AttributeKey.valueOf((String)"BuildMessageDispatcher.sessionData");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x50B172FE9E7BL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preloadedSessionId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/server/BuildMessageDispatcher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBuildMessageHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getConnectedChannel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssociatedChannel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sendBuildParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SessionData {
        @NotNull
        final UUID sessionId;
        @NotNull
        final BuilderMessageHandler handler;
        volatile CmdlineRemoteProto.Message.ControllerMessage params;
        volatile Channel channel;
        State state;
        private static final long a = lb.a(-8759056817629881678L, -5392106634094529325L, MethodHandles.lookup().lookupClass()).a(186364275114212L);

        private SessionData(@NotNull UUID sessionId, @NotNull BuilderMessageHandler handler, CmdlineRemoteProto.Message.ControllerMessage params) {
            if (sessionId == null) {
                SessionData.a(0);
            }
            if (handler == null) {
                SessionData.a(1);
            }
            this.state = State.INITIAL;
            this.sessionId = sessionId;
            this.handler = handler;
            this.params = params;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x4D225EAA5A0BL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sessionId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/server/BuildMessageDispatcher$SessionData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static final class State
        extends Enum<State> {
            public static final /* enum */ State INITIAL;
            public static final /* enum */ State WAITING_PARAMS;
            public static final /* enum */ State RUNNING;
            private static final /* synthetic */ State[] a;

            public static State[] values() {
                return (State[])a.clone();
            }

            public static State valueOf(String name2) {
                return Enum.valueOf(State.class, name2);
            }

            static {
                long l2 = lb.a(-2194514070285018395L, 7944842830127968572L, MethodHandles.lookup().lookupClass()).a(175485801723023L) ^ 0x148A3FBDB524L;
                INITIAL = new State();
                WAITING_PARAMS = new State();
                RUNNING = new State();
                a = new State[]{INITIAL, WAITING_PARAMS, RUNNING};
            }
        }
    }
}

