/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import b.a.lb;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.ViewAsGroup;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.ArrayRendererConfigurable;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ArrayFilterInplaceEditor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class ArrayAction
extends DebuggerAction {
    private static final long b = lb.a(8891041688339208185L, -6097204144331703365L, MethodHandles.lookup().lookupClass()).a(120452393010267L);

    public void actionPerformed(@NotNull AnActionEvent e10) {
        DebuggerContextImpl debuggerContextImpl;
        DebugProcessImpl debugProcessImpl;
        if (e10 == null) {
            ArrayAction.b(0);
        }
        if ((debugProcessImpl = (debuggerContextImpl = DebuggerAction.getDebuggerContext(e10.getDataContext())).getDebugProcess()) == null) {
            return;
        }
        XValueNodeImpl xValueNodeImpl = XDebuggerTreeActionBase.getSelectedNode((DataContext)e10.getDataContext());
        if (xValueNodeImpl == null) {
            return;
        }
        ArrayRenderer arrayRenderer2 = ArrayAction.getArrayRenderer((XValue)xValueNodeImpl.getValueContainer());
        if (arrayRenderer2 == null) {
            return;
        }
        this.createNewRenderer(xValueNodeImpl, arrayRenderer2, debuggerContextImpl, xValueNodeImpl.getName()).onSuccess(arrayRenderer -> ArrayAction.setArrayRenderer(arrayRenderer, xValueNodeImpl, debuggerContextImpl));
    }

    @NotNull
    protected abstract Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl var1, ArrayRenderer var2, @NotNull DebuggerContextImpl var3, String var4);

    public void update(@NotNull AnActionEvent e10) {
        if (e10 == null) {
            ArrayAction.b(1);
        }
        boolean bl2 = false;
        List<JavaValue> list2 = ViewAsGroup.getSelectedValues(e10);
        if (list2.size() == 1) {
            bl2 = ArrayAction.getArrayRenderer((XValue)list2.get(0)) != null;
        }
        e10.getPresentation().setEnabledAndVisible(bl2);
    }

    @Nullable
    public static ArrayRenderer getArrayRenderer(XValue value) {
        if (value instanceof JavaValue) {
            ChildrenRenderer childrenRenderer;
            ValueDescriptorImpl valueDescriptorImpl = ((JavaValue)value).getDescriptor();
            Renderer renderer = valueDescriptorImpl.getLastRenderer();
            if (renderer instanceof CompoundNodeRenderer && (childrenRenderer = ((CompoundNodeRenderer)renderer).getChildrenRenderer()) instanceof ExpressionChildrenRenderer && (renderer = ExpressionChildrenRenderer.getLastChildrenRenderer(valueDescriptorImpl)) == null) {
                renderer = ((ExpressionChildrenRenderer)childrenRenderer).getPredictedRenderer();
            }
            if (renderer instanceof ArrayRenderer) {
                return (ArrayRenderer)renderer;
            }
        }
        return null;
    }

    public static void setArrayRenderer(final ArrayRenderer newRenderer, final @NotNull XValueNodeImpl node, @NotNull DebuggerContextImpl debuggerContext) {
        XValue xValue;
        ArrayRenderer arrayRenderer;
        if (node == null) {
            ArrayAction.b(2);
        }
        if (debuggerContext == null) {
            ArrayAction.b(3);
        }
        if ((arrayRenderer = ArrayAction.getArrayRenderer(xValue = (XValue)node.getValueContainer())) == null) {
            return;
        }
        final ValueDescriptorImpl valueDescriptorImpl = ((JavaValue)xValue).getDescriptor();
        DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
        if (debugProcessImpl != null) {
            debugProcessImpl.getManagerThread().schedule(new SuspendContextCommandImpl(debuggerContext.getSuspendContext()){
                private static final long e = lb.a(-7124586141115498157L, 327109338580037671L, MethodHandles.lookup().lookupClass()).a(169133999408247L);

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    CompoundNodeRenderer compoundNodeRenderer;
                    ChildrenRenderer childrenRenderer;
                    Renderer renderer;
                    if (suspendContext == null) {
                        1.b(0);
                    }
                    if ((renderer = valueDescriptorImpl.getLastRenderer()) instanceof ArrayRenderer) {
                        ((JavaValue)xValue).setRenderer(newRenderer, node);
                        node.invokeNodeUpdate(() -> {
                            if (node == null) {
                                1.b(1);
                            }
                            node.getTree().expandPath(node.getPath());
                        });
                    } else if (renderer instanceof CompoundNodeRenderer && (childrenRenderer = (compoundNodeRenderer = (CompoundNodeRenderer)renderer).getChildrenRenderer()) instanceof ExpressionChildrenRenderer) {
                        ExpressionChildrenRenderer.setPreferableChildrenRenderer(valueDescriptorImpl, newRenderer);
                        ((JavaValue)xValue).reBuild(node);
                    }
                }

                private static /* synthetic */ void b(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    long l2 = e ^ 0x7F117926630EL;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "suspendContext";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/actions/ArrayAction$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "contextAction";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$contextAction$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static String a(String string, DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        if (debuggerTreeNodeImpl != null) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl2 = debuggerTreeNodeImpl.getParent();
            NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl2.getDescriptor();
            if (nodeDescriptorImpl instanceof ValueDescriptorImpl && ((ValueDescriptorImpl)nodeDescriptorImpl).isArray()) {
                int n2 = debuggerTreeNodeImpl2.getIndex(debuggerTreeNodeImpl);
                return ArrayAction.a(string, debuggerTreeNodeImpl2) + "[" + n2 + "]";
            }
            String string2 = debuggerTreeNodeImpl.getDescriptor() != null ? debuggerTreeNodeImpl.getDescriptor().getName() : null;
            return string2 != null ? string + " " + string2 : string;
        }
        return string;
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x3A368D7EA1FEL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/actions/ArrayAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setArrayRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FilterArrayAction
    extends ArrayAction {
        private static final long c = lb.a(-5017331931018426033L, -86206005803968223L, MethodHandles.lookup().lookupClass()).a(264494125331493L);

        @Override
        @NotNull
        protected Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl node, ArrayRenderer original, @NotNull DebuggerContextImpl debuggerContext, String title) {
            if (debuggerContext == null) {
                FilterArrayAction.c(0);
            }
            ArrayFilterInplaceEditor.editParent(node);
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                FilterArrayAction.c(1);
            }
            return promise;
        }

        private static /* synthetic */ void c(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x6F5FA25E6FE2L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggerContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/actions/ArrayAction$FilterArrayAction";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/actions/ArrayAction$FilterArrayAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewRenderer";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewRenderer";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AdjustArrayRangeAction
    extends ArrayAction {
        private static final long c = lb.a(3571683169995185358L, 8460447373453274523L, MethodHandles.lookup().lookupClass()).a(63932686653670L);

        @Override
        @NotNull
        protected Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl node, ArrayRenderer original, @NotNull DebuggerContextImpl debuggerContext, String title) {
            if (debuggerContext == null) {
                AdjustArrayRangeAction.c(0);
            }
            ArrayRenderer arrayRenderer = original.clone();
            arrayRenderer.setForced(true);
            if (ShowSettingsUtil.getInstance().editConfigurable(debuggerContext.getProject(), (Configurable)new NamedArrayConfigurable(title, arrayRenderer))) {
                Promise promise = Promises.resolvedPromise((Object)arrayRenderer);
                if (promise == null) {
                    AdjustArrayRangeAction.c(1);
                }
                return promise;
            }
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AdjustArrayRangeAction.c(2);
            }
            return promise;
        }

        private static /* synthetic */ void c(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x4A8C282C7650L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggerContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/actions/ArrayAction$AdjustArrayRangeAction";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/actions/ArrayAction$AdjustArrayRangeAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewRenderer";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NamedArrayConfigurable
    extends ArrayRendererConfigurable
    implements Configurable {
        private final String h;

        NamedArrayConfigurable(String title, ArrayRenderer renderer) {
            super(renderer);
            this.h = title;
        }

        public String getDisplayName() {
            return this.h;
        }

        public String getHelpTopic() {
            return null;
        }
    }
}

