/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.GeneratedLocation;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.settings.CaptureSettingsProvider;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncStacksUtils {
    private static final Logger c;
    public static final String CAPTURE_STORAGE_CLASS_NAME = "com.intellij.rt.debugger.agent.CaptureStorage";
    public static final String CAPTURE_AGENT_CLASS_NAME = "com.intellij.rt.debugger.agent.CaptureAgent";
    private static final Key<Pair<ClassType, Method>> b;
    private static final Pair<ClassType, Method> a;
    private static final long d;

    public static boolean isAgentEnabled() {
        return DebuggerSettings.getInstance().INSTRUMENTING_AGENT;
    }

    @Nullable
    public static List<StackFrameItem> getAgentRelatedStack(JavaStackFrame frame, @NotNull SuspendContextImpl suspendContext) {
        Method method;
        Location location;
        long l2 = d ^ 0x31D3378E6F76L;
        if (suspendContext == null) {
            AsyncStacksUtils.a(0);
        }
        if (AsyncStacksUtils.isAgentEnabled() && suspendContext.getDebugProcess().isEvaluationPossible() && (location = frame.getDescriptor().getLocation()) != null && (method = DebuggerUtilsEx.getMethod(location)) != null && method.name().endsWith("$$$capture")) {
            try {
                return AsyncStacksUtils.a(new EvaluationContextImpl(suspendContext, frame.getStackFrameProxy()));
            }
            catch (EvaluateException evaluateException) {
                c.error((Throwable)evaluateException);
            }
        }
        return null;
    }

    private static List<StackFrameItem> a(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Object object;
        long l2 = d ^ 0x42E48038D0F0L;
        EvaluationContextImpl evaluationContextImpl2 = evaluationContextImpl.withAutoLoadClasses(false);
        DebugProcessImpl debugProcessImpl = evaluationContextImpl2.getDebugProcess();
        Pair pair2 = (Pair)debugProcessImpl.getUserData(b);
        if (pair2 == null) {
            try {
                object = (ClassType)debugProcessImpl.findClass(evaluationContextImpl2, CAPTURE_STORAGE_CLASS_NAME, null);
                if (object == null) {
                    pair2 = a;
                    c.debug("Error loading debug agent", new Object[]{"agent class not found"});
                } else {
                    pair2 = Pair.create((Object)object, (Object)object.methodsByName("getCurrentCapturedStack").get(0));
                }
            }
            catch (EvaluateException evaluateException) {
                pair2 = a;
                c.debug("Error loading debug agent", (Throwable)evaluateException);
            }
            AsyncStacksUtils.putProcessUserData(b, pair2, debugProcessImpl);
        }
        if (pair2 == a) {
            return null;
        }
        Pair pair3 = pair2;
        object = debugProcessImpl.getVirtualMachineProxy();
        List<IntegerValue> list2 = Collections.singletonList(((VirtualMachineProxyImpl)object).mirrorOf(AsyncStacksUtils.getMaxStackLength()));
        Object t2 = evaluationContextImpl2.computeAndKeep(() -> debugProcessImpl.invokeMethod(evaluationContextImpl2, (ClassType)pair2.first, (Method)pair2.second, list2, 1, true));
        if (t2 instanceof ArrayReference) {
            List<Value> list3 = ((ArrayReference)t2).getValues();
            ArrayList<StackFrameItem> arrayList = new ArrayList<StackFrameItem>(list3.size());
            ClassesByNameProvider classesByNameProvider = ClassesByNameProvider.createCache(((VirtualMachineProxyImpl)object).allClasses());
            for (Value value : list3) {
                if (value == null) {
                    arrayList.add(null);
                    continue;
                }
                List<Value> list4 = ((ArrayReference)value).getValues();
                String string = AsyncStacksUtils.a((StringReference)list4.get(0));
                String string2 = AsyncStacksUtils.a((StringReference)list4.get(2));
                int n2 = Integer.parseInt(((StringReference)list4.get(3)).value());
                Location location = AsyncStacksUtils.a(debugProcessImpl, (ReferenceType)ContainerUtil.getFirstItem(classesByNameProvider.get(string)), string2, n2);
                arrayList.add(new ProcessStackFrameItem(location, string, string2));
            }
            return arrayList;
        }
        return null;
    }

    private static String a(StringReference stringReference) {
        return stringReference != null ? stringReference.value() : null;
    }

    public static void setupAgent(final DebugProcessImpl process2) {
        Properties properties;
        long l2 = d ^ 0x8ED71E52332L;
        if (!AsyncStacksUtils.isAgentEnabled()) {
            return;
        }
        if (Registry.is((String)"debugger.capture.points.agent.debug")) {
            AsyncStacksUtils.a(process2);
        }
        if (DebuggerUtilsImpl.isRemote(process2) && !(properties = CaptureSettingsProvider.getPointsProperties()).isEmpty()) {
            process2.addDebugProcessListener(new DebugProcessAdapterImpl(){

                @Override
                public void paused(SuspendContextImpl suspendContext) {
                    if (process2.isEvaluationPossible()) {
                        try {
                            StackCapturingLineBreakpoint.deleteAll(process2);
                            try {
                                AsyncStacksUtils.addAgentCapturePoints(new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy()), properties);
                                process2.removeDebugProcessListener(this);
                            }
                            finally {
                                process2.onHotSwapFinished();
                                StackCapturingLineBreakpoint.createAll(process2);
                            }
                        }
                        catch (Exception exception) {
                            c.debug((Throwable)exception);
                        }
                    }
                }
            });
        }
    }

    private static void a(final DebugProcessImpl debugProcessImpl) {
        long l2 = d ^ 0x747ED0E18B93L;
        final RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
        ClassPrepareRequestor classPrepareRequestor = new ClassPrepareRequestor(){
            private static final long a = lb.a(-2908420171743570466L, 940202011003786558L, MethodHandles.lookup().lookupClass()).a(133709956943798L);

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                long l2 = a ^ 0x29A1159CC6C1L;
                try {
                    requestManagerImpl.deleteRequest((Requestor)this);
                    ((ClassType)referenceType).setValue(referenceType.fieldByName("DEBUG"), debugProcessImpl.getVirtualMachineProxy().mirrorOf(true));
                }
                catch (Exception exception) {
                    c.warn("Error setting agent debug mode", (Throwable)exception);
                }
            }
        };
        requestManagerImpl.callbackOnPrepareClasses(classPrepareRequestor, CAPTURE_STORAGE_CLASS_NAME);
        try {
            ClassType classType = (ClassType)debugProcessImpl.findClass(null, CAPTURE_STORAGE_CLASS_NAME, null);
            if (classType != null) {
                classPrepareRequestor.processClassPrepare((DebugProcess)debugProcessImpl, (ReferenceType)classType);
            }
        }
        catch (Exception exception) {
            c.warn("Error setting agent debug mode", (Throwable)exception);
        }
    }

    private static Location a(DebugProcessImpl debugProcessImpl, ReferenceType referenceType, String string, int n2) {
        long l2 = d ^ 0x62B70330F923L;
        if (referenceType != null && n2 >= 0) {
            try {
                Location location2 = referenceType.locationsOfLine("Java", null, n2).stream().filter(location -> location.method().name().equals(string)).findFirst().orElse(null);
                if (location2 != null) {
                    return location2;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return new GeneratedLocation(debugProcessImpl, referenceType, string, n2);
    }

    public static void addAgentCapturePoints(EvaluationContextImpl evalContext, Properties properties) {
        long l2 = d ^ 0x3C2DE555FD75L;
        EvaluationContextImpl evaluationContextImpl = evalContext.withAutoLoadClasses(false);
        DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
        try {
            ClassType classType = (ClassType)debugProcessImpl.findClass(evaluationContextImpl, CAPTURE_AGENT_CLASS_NAME, null);
            if (classType == null) {
                c.debug("Error loading debug agent", new Object[]{"agent class not found"});
            } else {
                Method method = classType.methodsByName("addCapturePoints").get(0);
                if (method != null) {
                    StringWriter stringWriter = new StringWriter();
                    try {
                        properties.store(stringWriter, null);
                        List<StringReference> list2 = Collections.singletonList(DebuggerUtilsEx.mirrorOfString(stringWriter.toString(), debugProcessImpl.getVirtualMachineProxy(), evalContext));
                        debugProcessImpl.invokeMethod(evaluationContextImpl, classType, method, list2, 1, true);
                    }
                    catch (Exception exception) {
                        c.error((Throwable)exception);
                    }
                }
            }
        }
        catch (EvaluateException evaluateException) {
            c.debug("Error loading debug agent", (Throwable)evaluateException);
        }
    }

    public static <T> void putProcessUserData(final @NotNull Key<T> key, @Nullable T value, DebugProcessImpl debugProcess) {
        if (key == null) {
            AsyncStacksUtils.a(1);
        }
        debugProcess.putUserData(key, value);
        debugProcess.addDebugProcessListener(new DebugProcessListener(){
            private static final long a = lb.a(4945744706114493178L, 8565760897389463492L, MethodHandles.lookup().lookupClass()).a(207107511068805L);

            public void processDetached(@NotNull DebugProcess process2, boolean closedByUser) {
                if (process2 == null) {
                    3.a(0);
                }
                process2.putUserData(key, null);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x39E73245161L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/debugger/engine/AsyncStacksUtils$3", "processDetached"));
            }
        });
    }

    public static int getMaxStackLength() {
        long l2 = d ^ 0x460261695B62L;
        return Registry.intValue((String)"debugger.async.stacks.max.depth", (int)500);
    }

    static {
        d = lb.a(-3482026366298214037L, 4596632512683455771L, MethodHandles.lookup().lookupClass()).a(206490848998158L);
        long l2 = d ^ 0x462062F9F6DFL;
        c = Logger.getInstance(AsyncStacksUtils.class);
        b = Key.create((String)"CAPTURE_STORAGE_METHOD");
        a = Pair.empty();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = d ^ 0x1CBA1F73E17EL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/AsyncStacksUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAgentRelatedStack";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "putProcessUserData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProcessStackFrameItem
    extends StackFrameItem {
        final String myClass;
        final String myMethod;
        private static final long f = lb.a(1528128487046911912L, 8223634719821989128L, MethodHandles.lookup().lookupClass()).a(108321858974479L);

        ProcessStackFrameItem(Location location, String aClass, String method) {
            super(location, null);
            this.myClass = aClass;
            this.myMethod = method;
        }

        @Override
        @NotNull
        public String path() {
            String string = this.myClass;
            if (string == null) {
                ProcessStackFrameItem.b(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String method() {
            String string = this.myMethod;
            if (string == null) {
                ProcessStackFrameItem.b(1);
            }
            return string;
        }

        @Override
        public String toString() {
            return this.myClass + "." + this.myMethod + ":" + this.line();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            long l2 = f ^ 0x4B4F72C95C46L;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/debugger/engine/AsyncStacksUtils$ProcessStackFrameItem";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "method";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

