/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicStepMethodFilter
implements NamedMethodFilter {
    private static final Logger a;
    @NotNull
    protected final JVMName myDeclaringClassName;
    @NotNull
    private final String b;
    @Nullable
    protected final JVMName myTargetMethodSignature;
    private final Range<Integer> c;
    private static final long f;

    public BasicStepMethodFilter(@NotNull PsiMethod psiMethod, Range<Integer> callingExpressionLines) {
        if (psiMethod == null) {
            BasicStepMethodFilter.b(0);
        }
        this(JVMNameUtil.getJVMQualifiedName(psiMethod.getContainingClass()), JVMNameUtil.getJVMMethodName(psiMethod), JVMNameUtil.getJVMSignature(psiMethod), callingExpressionLines);
    }

    protected BasicStepMethodFilter(@NotNull JVMName declaringClassName, @NotNull String targetMethodName, @Nullable JVMName targetMethodSignature, Range<Integer> callingExpressionLines) {
        if (declaringClassName == null) {
            BasicStepMethodFilter.b(1);
        }
        if (targetMethodName == null) {
            BasicStepMethodFilter.b(2);
        }
        this.myDeclaringClassName = declaringClassName;
        this.b = targetMethodName;
        this.myTargetMethodSignature = targetMethodSignature;
        this.c = callingExpressionLines;
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.b;
        if (string == null) {
            BasicStepMethodFilter.b(3);
        }
        return string;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process2, Location location) throws EvaluateException {
        return this.locationMatches(process2, location, () -> null);
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process2, Location location, @NotNull EvaluatingComputable<ObjectReference> thisProvider) throws EvaluateException {
        ObjectReference objectReference;
        Method method;
        String string;
        if (thisProvider == null) {
            BasicStepMethodFilter.b(4);
        }
        if (!this.b.equals(string = (method = location.method()).name())) {
            if (DebuggerUtilsEx.isLambdaName(string)) {
                SourcePosition sourcePosition = process2.getPositionManager().getSourcePosition(location);
                return (Boolean)ReadAction.compute(() -> {
                    PsiElement psiElement = DebuggerUtilsEx.getContainingMethod(sourcePosition);
                    if (psiElement instanceof PsiLambdaExpression) {
                        PsiType psiType = ((PsiLambdaExpression)psiElement).getFunctionalInterfaceType();
                        PsiMethod psiMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)psiType);
                        if (psiType != null && psiMethod != null && this.b.equals(psiMethod.getName())) {
                            try {
                                return InheritanceUtil.isInheritor((PsiType)psiType, (String)this.myDeclaringClassName.getName(process2).replace('$', '.'));
                            }
                            catch (EvaluateException evaluateException) {
                                a.info((Throwable)evaluateException);
                            }
                        }
                    }
                    return false;
                });
            }
            return false;
        }
        if (this.myTargetMethodSignature != null && !BasicStepMethodFilter.a(method, this.myTargetMethodSignature.getName(process2))) {
            return false;
        }
        if (method.isBridge()) {
            return false;
        }
        String string2 = this.myDeclaringClassName.getName(process2);
        boolean bl2 = DebuggerUtilsEx.isAssignableFrom(string2, location.declaringType());
        if (!bl2 && !method.isStatic() && (objectReference = thisProvider.compute()) != null) {
            bl2 = DebuggerUtilsEx.isAssignableFrom(string2, objectReference.referenceType());
        }
        return bl2;
    }

    private static boolean a(Method method, String string) throws EvaluateException {
        if (string.equals(method.signature())) {
            return true;
        }
        for (Method method2 : method.declaringType().methodsByName(method.name())) {
            if (method2 == method || !method2.isBridge() || !string.equals(method2.signature())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.c;
    }

    static {
        f = lb.a(6232379182258462814L, -6036244883550435685L, MethodHandles.lookup().lookupClass()).a(271545675729522L);
        a = Logger.getInstance(BasicStepMethodFilter.class);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x191624E421B1L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringClassName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/BasicStepMethodFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/BasicStepMethodFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "locationMatches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

