/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.ClassPrepareRequest;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundPositionManager
extends PositionManagerEx
implements MultiRequestPositionManager {
    private static final Logger a;
    public static final CompoundPositionManager EMPTY;
    private final ArrayList<PositionManager> c = new ArrayList();
    private final Map<Location, SourcePosition> b = new WeakHashMap<Location, SourcePosition>();
    private static final long d;

    public CompoundPositionManager() {
    }

    public CompoundPositionManager(PositionManager manager) {
        this.appendPositionManager(manager);
    }

    public void appendPositionManager(PositionManager manager) {
        this.c.remove(manager);
        this.c.add(0, manager);
        this.clearCache();
    }

    public void clearCache() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.b.clear();
    }

    private <T> T a(Processor<T> processor, T t2, SourcePosition sourcePosition) {
        return this.a(processor, t2, sourcePosition, true);
    }

    private <T> T a(Processor<T> processor, T t2, SourcePosition sourcePosition, boolean bl2) {
        FileType fileType = sourcePosition != null ? sourcePosition.getFile().getFileType() : null;
        for (PositionManager positionManager : this.c) {
            Set set;
            if (fileType != null && (set = positionManager.getAcceptedFileTypes()) != null && !set.contains(fileType)) continue;
            try {
                if (!bl2) {
                    ProgressManager.checkCanceled();
                }
                return DebuggerUtilsImpl.suppressExceptions(() -> processor.process(positionManager), t2, bl2, NoDataException.class);
            }
            catch (NoDataException noDataException) {
            }
        }
        return t2;
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location) {
        if (location == null) {
            return null;
        }
        return (SourcePosition)DebuggerUtilsImpl.runInReadActionWithWriteActionPriorityWithRetries(() -> {
            SourcePosition sourcePosition = null;
            try {
                sourcePosition = this.b.get(location);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (CompoundPositionManager.a(sourcePosition, location)) {
                return sourcePosition;
            }
            return this.a(positionManager -> {
                SourcePosition sourcePosition = positionManager.getSourcePosition(location);
                this.b.put(location, sourcePosition);
                return sourcePosition;
            }, null, null, false);
        });
    }

    private static boolean a(@Nullable SourcePosition sourcePosition, @NotNull Location location) {
        if (location == null) {
            CompoundPositionManager.a(0);
        }
        if (sourcePosition == null) {
            return false;
        }
        PsiFile psiFile = sourcePosition.getFile();
        if (!psiFile.isValid()) {
            return false;
        }
        String string = DebuggerUtilsEx.getAlternativeSourceUrl(location.declaringType().name(), psiFile.getProject());
        if (string == null) {
            return true;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return virtualFile != null && string.equals(virtualFile.getUrl());
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) {
        if (classPosition == null) {
            CompoundPositionManager.a(1);
        }
        List<ReferenceType> list2 = this.a(positionManager -> {
            if (classPosition == null) {
                CompoundPositionManager.a(23);
            }
            return positionManager.getAllClasses(classPosition);
        }, Collections.emptyList(), classPosition);
        if (list2 == null) {
            CompoundPositionManager.a(2);
        }
        return list2;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) {
        int n2;
        SourcePosition sourcePosition;
        VirtualFile virtualFile;
        if (type == null) {
            CompoundPositionManager.a(3);
        }
        if (position == null) {
            CompoundPositionManager.a(4);
        }
        if ((virtualFile = position.getFile().getVirtualFile()) != null && (sourcePosition = (LineNumbersMapping)virtualFile.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (n2 = sourcePosition.sourceToBytecode(position.getLine() + 1)) > -1) {
            position = SourcePosition.createFromLine((PsiFile)position.getFile(), (int)(n2 - 1));
        }
        sourcePosition = position;
        List<Location> list2 = this.a(positionManager -> {
            if (type == null) {
                CompoundPositionManager.a(22);
            }
            return positionManager.locationsOfLine(type, sourcePosition);
        }, Collections.emptyList(), position);
        if (list2 == null) {
            CompoundPositionManager.a(5);
        }
        return list2;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        if (requestor == null) {
            CompoundPositionManager.a(6);
        }
        if (position == null) {
            CompoundPositionManager.a(7);
        }
        return this.a(positionManager -> {
            if (requestor == null) {
                CompoundPositionManager.a(20);
            }
            if (position == null) {
                CompoundPositionManager.a(21);
            }
            return positionManager.createPrepareRequest(requestor, position);
        }, null, position);
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        if (requestor == null) {
            CompoundPositionManager.a(8);
        }
        if (position == null) {
            CompoundPositionManager.a(9);
        }
        List<ClassPrepareRequest> list2 = this.a(positionManager -> {
            if (requestor == null) {
                CompoundPositionManager.a(18);
            }
            if (position == null) {
                CompoundPositionManager.a(19);
            }
            if (positionManager instanceof MultiRequestPositionManager) {
                return ((MultiRequestPositionManager)positionManager).createPrepareRequests(requestor, position);
            }
            ClassPrepareRequest classPrepareRequest = positionManager.createPrepareRequest(requestor, position);
            if (classPrepareRequest == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(classPrepareRequest);
        }, Collections.emptyList(), position);
        if (list2 == null) {
            CompoundPositionManager.a(10);
        }
        return list2;
    }

    @Override
    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location) {
        if (frame == null) {
            CompoundPositionManager.a(11);
        }
        if (debugProcess == null) {
            CompoundPositionManager.a(12);
        }
        if (location == null) {
            CompoundPositionManager.a(13);
        }
        for (PositionManager positionManager : this.c) {
            if (!(positionManager instanceof PositionManagerEx)) continue;
            try {
                XStackFrame xStackFrame = ((PositionManagerEx)positionManager).createStackFrame(frame, debugProcess, location);
                if (xStackFrame == null) continue;
                return xStackFrame;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw vMDisconnectedException;
            }
            catch (Throwable throwable) {
                a.error(throwable);
            }
        }
        return null;
    }

    @Override
    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression) {
        if (context == null) {
            CompoundPositionManager.a(14);
        }
        if (frame == null) {
            CompoundPositionManager.a(15);
        }
        if (location == null) {
            CompoundPositionManager.a(16);
        }
        if (expression == null) {
            CompoundPositionManager.a(17);
        }
        for (PositionManager positionManager : this.c) {
            if (!(positionManager instanceof PositionManagerEx)) continue;
            try {
                ThreeState threeState = ((PositionManagerEx)positionManager).evaluateCondition(context, frame, location, expression);
                if (threeState == ThreeState.UNSURE) continue;
                return threeState;
            }
            catch (Throwable throwable) {
                a.error(throwable);
            }
        }
        return ThreeState.UNSURE;
    }

    static {
        d = lb.a(6393503031528981121L, -4436768475998314657L, MethodHandles.lookup().lookupClass()).a(80122167322059L);
        a = Logger.getInstance(CompoundPositionManager.class);
        EMPTY = new CompoundPositionManager();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x101EBC6E351L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPosition";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/CompoundPositionManager";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: 
            case 8: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/CompoundPositionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrepareRequests";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkCacheEntry";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequests";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createStackFrame";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCondition";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPrepareRequests$6";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPrepareRequest$5";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$locationsOfLine$4";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllClasses$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Processor<T> {
        public T process(PositionManager var1) throws NoDataException;
    }
}

