/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaBreakpointHandler;
import com.intellij.debugger.engine.JavaBreakpointHandlerFactory;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValueMarker;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.JavaDebuggerInlayUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SourceCodeChecker;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.AlternativeSourceNotificationProvider;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.ThreadsPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.overhead.OverheadView;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerInlayUtil;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class JavaDebugProcess
extends XDebugProcess {
    private final DebuggerSession e;
    private final JavaDebuggerEditorsProvider b;
    private final XBreakpointHandler<?>[] d;
    private final NodeManagerImpl a;
    private static final JavaBreakpointHandlerFactory[] c;
    private static final long f;

    public static JavaDebugProcess create(@NotNull XDebugSession session, DebuggerSession javaSession) {
        if (session == null) {
            JavaDebugProcess.a(0);
        }
        JavaDebugProcess javaDebugProcess = new JavaDebugProcess(session, javaSession);
        javaSession.getProcess().setXDebugProcess(javaDebugProcess);
        return javaDebugProcess;
    }

    protected JavaDebugProcess(final @NotNull XDebugSession session, final DebuggerSession javaSession) {
        long l2 = f ^ 0x35FB324086F5L;
        if (session == null) {
            JavaDebugProcess.a(1);
        }
        super(session);
        this.e = javaSession;
        this.b = new JavaDebuggerEditorsProvider();
        final DebugProcessImpl debugProcessImpl = javaSession.getProcess();
        this.d = (XBreakpointHandler[])StreamEx.of((Object[])c).append((Collection)JavaBreakpointHandlerFactory.EP_NAME.getExtensionList()).map(javaBreakpointHandlerFactory -> javaBreakpointHandlerFactory.createHandler(debugProcessImpl)).toArray(XBreakpointHandler[]::new);
        this.e.getContextManager().addListener(new DebuggerContextListener(){
            private static final long a = lb.a(-5450483926944171970L, -7314029285515030347L, MethodHandles.lookup().lookupClass()).a(278843178464661L);

            @Override
            public void changeEvent(final @NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                if (newContext == null) {
                    1.a(0);
                }
                if (event == DebuggerSession.Event.PAUSE || event == DebuggerSession.Event.CONTEXT || event == DebuggerSession.Event.REFRESH || event == DebuggerSession.Event.REFRESH_WITH_STACK && JavaDebugProcess.this.e.isPaused()) {
                    final SuspendContextImpl suspendContextImpl = newContext.getSuspendContext();
                    if (suspendContextImpl != null && (JavaDebugProcess.this.b(newContext) || event == DebuggerSession.Event.REFRESH_WITH_STACK)) {
                        debugProcessImpl.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContextImpl){
                            private static final long e = lb.a(6157713165537235851L, -6632250924854663499L, MethodHandles.lookup().lookupClass()).a(228922801647473L);

                            @Override
                            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                                if (suspendContext == null) {
                                    1.b(0);
                                }
                                ThreadReferenceProxyImpl threadReferenceProxyImpl = newContext.getThreadProxy();
                                suspendContextImpl.initExecutionStacks(threadReferenceProxyImpl);
                                Pair pair2 = (Pair)ContainerUtil.getFirstItem(DebuggerUtilsEx.getEventDescriptors(suspendContextImpl));
                                if (pair2 != null) {
                                    XBreakpoint xBreakpoint = ((Breakpoint)pair2.getFirst()).getXBreakpoint();
                                    Event event = (Event)pair2.getSecond();
                                    if (xBreakpoint != null && event instanceof LocatableEvent && threadReferenceProxyImpl != null && ((LocatableEvent)event).thread() == threadReferenceProxyImpl.getThreadReference()) {
                                        ((XDebugSessionImpl)JavaDebugProcess.this.getSession()).breakpointReachedNoProcessing(xBreakpoint, (XSuspendContext)suspendContextImpl);
                                        JavaDebugProcess.this.a(newContext);
                                        SourceCodeChecker.checkSource(newContext);
                                        return;
                                    }
                                }
                                JavaDebugProcess.this.getSession().positionReached((XSuspendContext)suspendContextImpl);
                                JavaDebugProcess.this.a(newContext);
                                SourceCodeChecker.checkSource(newContext);
                            }

                            private static /* synthetic */ void b(int n2) {
                                long l2 = e ^ 0x12F4386F18CL;
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaDebugProcess$1$1", "contextAction"));
                            }
                        });
                    }
                } else if (event == DebuggerSession.Event.ATTACHED) {
                    JavaDebugProcess.this.getSession().rebuildViews();
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2EE1819C9CA2L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/engine/JavaDebugProcess$1", "changeEvent"));
            }
        });
        this.a = new NodeManagerImpl(session.getProject(), null){
            private static final long i = lb.a(-43744436895854935L, -4229531770845716163L, MethodHandles.lookup().lookupClass()).a(263167539124211L);

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor2, EvaluationContext evaluationContext) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, descriptor2);
                if (debuggerTreeNodeImpl == null) {
                    2.c(0);
                }
                return debuggerTreeNodeImpl;
            }

            @Override
            public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor2) {
                return new DebuggerTreeNodeImpl(null, descriptor2);
            }

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createMessageNode(String message) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, new MessageDescriptor(message));
                if (debuggerTreeNodeImpl == null) {
                    2.c(1);
                }
                return debuggerTreeNodeImpl;
            }

            private static /* synthetic */ void c(int n2) {
                Object[] objectArray;
                long l2 = i ^ 0x6AB675397322L;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/debugger/engine/JavaDebugProcess$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMessageNode";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                JavaDebugProcess.this.saveNodeHistory();
                this.a(session.getCurrentStackFrame());
            }

            public void stackFrameChanged() {
                XStackFrame xStackFrame = session.getCurrentStackFrame();
                if (xStackFrame instanceof JavaStackFrame) {
                    this.a(xStackFrame);
                    StackFrameProxyImpl stackFrameProxyImpl = ((JavaStackFrame)xStackFrame).getStackFrameProxy();
                    DebuggerContextUtil.setStackFrame(javaSession.getContextManager(), stackFrameProxyImpl);
                    JavaDebugProcess.this.a(stackFrameProxyImpl);
                }
            }

            private void a(@Nullable XStackFrame xStackFrame) {
                VirtualFile virtualFile;
                XSourcePosition xSourcePosition;
                if (xStackFrame != null && (xSourcePosition = xStackFrame.getSourcePosition()) != null && !AlternativeSourceNotificationProvider.isFileProcessed(virtualFile = xSourcePosition.getFile())) {
                    EditorNotifications.getInstance((Project)session.getProject()).updateNotifications(virtualFile);
                }
            }
        });
        if (Registry.is((String)"debugger.show.values.between.lines") && session instanceof XDebugSessionImpl) {
            ((XDebugSessionImpl)session).getSessionData().putUserData(XDebuggerInlayUtil.HELPER_KEY, (Object)new JavaDebuggerInlayUtil.Helper());
        }
    }

    private void a(DebuggerContextImpl debuggerContextImpl) {
        SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
        if (suspendContextImpl != null && !suspendContextImpl.suspends(debuggerContextImpl.getThreadProxy())) {
            ((XDebugSessionImpl)this.getSession()).unsetPaused();
        }
    }

    private boolean b(DebuggerContextImpl debuggerContextImpl) {
        SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
        SuspendContextImpl suspendContextImpl2 = (SuspendContextImpl)this.getSession().getSuspendContext();
        if (suspendContextImpl != null && !((Object)((Object)suspendContextImpl)).equals((Object)suspendContextImpl2)) {
            return true;
        }
        JavaExecutionStack javaExecutionStack = suspendContextImpl2 != null ? suspendContextImpl2.getActiveExecutionStack() : null;
        return javaExecutionStack == null || !Comparing.equal((Object)debuggerContextImpl.getThreadProxy(), (Object)javaExecutionStack.getThreadProxy());
    }

    public void saveNodeHistory() {
        this.a(this.a().getContext().getFrameProxy());
    }

    private void a(StackFrameProxyImpl stackFrameProxyImpl) {
        this.e.getProcess().getManagerThread().invoke(PrioritizedTask.Priority.NORMAL, () -> this.a.setHistoryByContext(stackFrameProxyImpl));
    }

    private DebuggerStateManager a() {
        return this.e.getContextManager();
    }

    public DebuggerSession getDebuggerSession() {
        return this.e;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        JavaDebuggerEditorsProvider javaDebuggerEditorsProvider = this.b;
        if (javaDebuggerEditorsProvider == null) {
            JavaDebugProcess.a(2);
        }
        return javaDebuggerEditorsProvider;
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.e.stepOver(false);
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.e.stepInto(false, null);
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.e.stepInto(true, null);
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.e.stepOut();
    }

    public void stop() {
        this.e.dispose();
        this.a.dispose();
    }

    public void startPausing() {
        this.e.pause();
    }

    public void resume(@Nullable XSuspendContext context) {
        this.e.resume();
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            JavaDebugProcess.a(3);
        }
        this.e.runToCursor(position, false);
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.d == null) {
            JavaDebugProcess.a(4);
        }
        return this.d;
    }

    public boolean checkCanInitBreakpoints() {
        return false;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.e.getProcess().getProcessHandler();
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole executionConsole = this.e.getProcess().getExecutionResult().getExecutionConsole();
        if (executionConsole != null) {
            ExecutionConsole executionConsole2 = executionConsole;
            if (executionConsole2 == null) {
                JavaDebugProcess.a(5);
            }
            return executionConsole2;
        }
        ExecutionConsole executionConsole3 = super.createConsole();
        if (executionConsole3 == null) {
            JavaDebugProcess.a(6);
        }
        return executionConsole3;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        XDebugTabLayouter xDebugTabLayouter = new XDebugTabLayouter(){
            private static final long a = lb.a(-3387175969323933519L, 2808308151395492243L, MethodHandles.lookup().lookupClass()).a(170456207938467L);

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    4.a(0);
                }
                this.b(ui);
                this.a(ui);
                this.c(ui);
            }

            @NotNull
            public Content registerConsoleContent(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
                long l2 = a ^ 0x72A9D83B1B61L;
                if (ui == null) {
                    4.a(1);
                }
                if (console == null) {
                    4.a(2);
                }
                Content content = null;
                if (console instanceof ExecutionConsoleEx) {
                    ((ExecutionConsoleEx)console).buildUi(ui);
                    content = ui.findContent("ConsoleContent");
                }
                if (content == null) {
                    content = super.registerConsoleContent(ui, console);
                }
                Content content2 = content;
                if (content2 == null) {
                    4.a(3);
                }
                return content2;
            }

            private void b(@NotNull RunnerLayoutUi runnerLayoutUi) {
                long l2 = a ^ 0x13CB247DA0C7L;
                if (runnerLayoutUi == null) {
                    4.a(4);
                }
                final ThreadsPanel threadsPanel = new ThreadsPanel(JavaDebugProcess.this.e.getProject(), JavaDebugProcess.this.a());
                final Content content = runnerLayoutUi.createContent("ThreadsContent", (JComponent)threadsPanel, XDebuggerBundle.message((String)"debugger.session.tab.threads.title", (Object[])new Object[0]), AllIcons.Debugger.Threads, null);
                content.setCloseable(false);
                runnerLayoutUi.addContent(content, 0, PlaceInGrid.left, true);
                runnerLayoutUi.addListener((ContentManagerListener)new ContentManagerAdapter(){
                    private static final long a = lb.a(-4150463364169705665L, -5488041288022024339L, MethodHandles.lookup().lookupClass()).a(121376978754747L);

                    public void selectionChanged(@NotNull ContentManagerEvent event) {
                        if (event == null) {
                            1.a(0);
                        }
                        if (event.getContent() == content) {
                            if (content.isSelected()) {
                                threadsPanel.setUpdateEnabled(true);
                                if (threadsPanel.isRefreshNeeded()) {
                                    threadsPanel.rebuildIfVisible(DebuggerSession.Event.CONTEXT);
                                }
                            } else {
                                threadsPanel.setUpdateEnabled(false);
                            }
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x4FF4DB839E7DL;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/JavaDebugProcess$4$1", "selectionChanged"));
                    }
                }, (Disposable)content);
            }

            private void a(@NotNull RunnerLayoutUi runnerLayoutUi) {
                long l2 = a ^ 0x4A9007784AF4L;
                if (runnerLayoutUi == null) {
                    4.a(5);
                }
                if (!Registry.is((String)"debugger.enable.memory.view")) {
                    return;
                }
                final XDebugSession xDebugSession = JavaDebugProcess.this.getSession();
                DebugProcessImpl debugProcessImpl = JavaDebugProcess.this.e.getProcess();
                InstancesTracker instancesTracker = InstancesTracker.getInstance((Project)JavaDebugProcess.this.e.getProject());
                final ClassesFilteredView classesFilteredView = new ClassesFilteredView(xDebugSession, debugProcessImpl, instancesTracker);
                final Content content = runnerLayoutUi.createContent("MemoryView", (JComponent)((Object)classesFilteredView), "Memory", AllIcons.Debugger.MemoryView.Active, null);
                content.setCloseable(false);
                content.setShouldDisposeContent(true);
                final MemoryViewDebugProcessData memoryViewDebugProcessData = new MemoryViewDebugProcessData();
                debugProcessImpl.putUserData(MemoryViewDebugProcessData.KEY, memoryViewDebugProcessData);
                xDebugSession.addSessionListener(new XDebugSessionListener(){

                    public void sessionStopped() {
                        xDebugSession.removeSessionListener((XDebugSessionListener)this);
                        memoryViewDebugProcessData.getTrackedStacks().clear();
                    }
                });
                runnerLayoutUi.addContent(content, 0, PlaceInGrid.right, true);
                final DebuggerManagerThreadImpl debuggerManagerThreadImpl = debugProcessImpl.getManagerThread();
                runnerLayoutUi.addListener((ContentManagerListener)new ContentManagerAdapter(){
                    private static final long a = lb.a(-8022254793161893311L, -668151071003732558L, MethodHandles.lookup().lookupClass()).a(75973870543585L);

                    public void selectionChanged(@NotNull ContentManagerEvent event) {
                        if (event == null) {
                            3.a(0);
                        }
                        if (event != null && event.getContent() == content) {
                            classesFilteredView.setActive(content.isSelected(), debuggerManagerThreadImpl);
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x3DE9119DB4AL;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/JavaDebugProcess$4$3", "selectionChanged"));
                    }
                }, (Disposable)content);
            }

            private void c(@NotNull RunnerLayoutUi runnerLayoutUi) {
                long l2 = a ^ 0x4478E151E80L;
                if (runnerLayoutUi == null) {
                    4.a(6);
                }
                if (!Registry.is((String)"debugger.enable.overhead.monitor")) {
                    return;
                }
                DebugProcessImpl debugProcessImpl = JavaDebugProcess.this.e.getProcess();
                OverheadView overheadView = new OverheadView(debugProcessImpl);
                Content content = runnerLayoutUi.createContent("OverheadMonitor", (JComponent)((Object)overheadView), "Overhead", AllIcons.Debugger.Overhead, null);
                overheadView.setBouncer(() -> {
                    if (runnerLayoutUi == null) {
                        4.a(7);
                    }
                    runnerLayoutUi.setBouncing(content, true);
                });
                content.setCloseable(false);
                content.setShouldDisposeContent(true);
                runnerLayoutUi.addContent(content, 0, PlaceInGrid.right, true);
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x15A1749B0FA0L;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 3: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ui";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "console";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/engine/JavaDebugProcess$4";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess$4";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "registerConsoleContent";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "registerAdditionalContent";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "registerConsoleContent";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "registerThreadsPanel";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "registerMemoryViewPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "registerOverheadMonitor";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$registerOverheadMonitor$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (xDebugTabLayouter == null) {
            JavaDebugProcess.a(7);
        }
        return xDebugTabLayouter;
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        long l2 = f ^ 0x4908D1E32ED1L;
        if (leftToolbar == null) {
            JavaDebugProcess.a(8);
        }
        if (topToolbar == null) {
            JavaDebugProcess.a(9);
        }
        if (settings == null) {
            JavaDebugProcess.a(10);
        }
        Constraints constraints = new Constraints(Anchor.BEFORE, "Runner.Layout");
        leftToolbar.add((AnAction)Separator.getInstance(), constraints);
        leftToolbar.add(ActionManager.getInstance().getAction("DumpThreads"), constraints);
        leftToolbar.add((AnAction)Separator.getInstance(), constraints);
        Constraints constraints2 = new Constraints(Anchor.BEFORE, "XDebugger.ToggleSortValues");
        settings.addAction((AnAction)new WatchLastMethodReturnValueAction(), constraints2);
        settings.addAction((AnAction)new AutoVarsSwitchAction(), constraints2);
    }

    @Nullable
    private static DebugProcessImpl a(@Nullable Project project2) {
        XDebugProcess xDebugProcess;
        XDebugSession xDebugSession;
        if (project2 != null && (xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null && (xDebugProcess = xDebugSession.getDebugProcess()) instanceof JavaDebugProcess) {
            return ((JavaDebugProcess)xDebugProcess).getDebuggerSession().getProcess();
        }
        return null;
    }

    public NodeManagerImpl getNodeManager() {
        return this.a;
    }

    public String getCurrentStateMessage() {
        String string = this.e.getStateDescription();
        return string != null ? string : super.getCurrentStateMessage();
    }

    @Nullable
    public XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return new JavaValueMarker();
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    static {
        f = lb.a(109509266875104052L, 7940933034602930980L, MethodHandles.lookup().lookupClass()).a(197154848842786L);
        c = new JavaBreakpointHandlerFactory[]{JavaBreakpointHandler.JavaLineBreakpointHandler::new, JavaBreakpointHandler.JavaExceptionBreakpointHandler::new, JavaBreakpointHandler.JavaFieldBreakpointHandler::new, JavaBreakpointHandler.JavaMethodBreakpointHandler::new, JavaBreakpointHandler.JavaWildcardBreakpointHandler::new};
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x78A99221A199L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaDebugProcess";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabLayouter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WatchLastMethodReturnValueAction
    extends ToggleAction {
        private final String a;
        private final String b;
        private static final long c = lb.a(-2535087249110422488L, -6826967360826066059L, MethodHandles.lookup().lookupClass()).a(36380628888408L);

        WatchLastMethodReturnValueAction() {
            long l2 = c ^ 0x614593079EDEL;
            super("", DebuggerBundle.message((String)"action.watch.method.return.value.description", (Object[])new Object[0]), null);
            this.a = DebuggerBundle.message((String)"action.watches.method.return.value.enable", (Object[])new Object[0]);
            this.b = DebuggerBundle.message((String)"action.watches.method.return.value.unavailable.reason", (Object[])new Object[0]);
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                WatchLastMethodReturnValueAction.a(0);
            }
            super.update(e10);
            Presentation presentation = e10.getPresentation();
            DebugProcessImpl debugProcessImpl = JavaDebugProcess.a(e10.getProject());
            if (debugProcessImpl == null || debugProcessImpl.canGetMethodReturnValue()) {
                presentation.setEnabled(true);
                presentation.setText(this.a);
            } else {
                presentation.setEnabled(false);
                presentation.setText(this.b);
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                WatchLastMethodReturnValueAction.a(1);
            }
            return DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean watch) {
            if (e10 == null) {
                WatchLastMethodReturnValueAction.a(2);
            }
            DebuggerSettings.getInstance().WATCH_RETURN_VALUES = watch;
            DebugProcessImpl debugProcessImpl = JavaDebugProcess.a(e10.getProject());
            if (debugProcessImpl != null) {
                debugProcessImpl.setWatchMethodReturnValuesEnabled(watch);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = c ^ 0x73EF42F8866CL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess$WatchLastMethodReturnValueAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AutoVarsSwitchAction
    extends ToggleAction {
        private volatile boolean a;
        private static final long b = lb.a(-7323885949570149359L, 4367703361858244511L, MethodHandles.lookup().lookupClass()).a(167959971353013L);

        AutoVarsSwitchAction() {
            long l2 = b ^ 0x3F9D1EABFD5EL;
            super(DebuggerBundle.message((String)"action.auto.variables.mode", (Object[])new Object[0]), DebuggerBundle.message((String)"action.auto.variables.mode.description", (Object[])new Object[0]), null);
            this.a = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                AutoVarsSwitchAction.a(0);
            }
            return this.a;
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean enabled) {
            if (e10 == null) {
                AutoVarsSwitchAction.a(1);
            }
            this.a = enabled;
            DebuggerSettings.getInstance().AUTO_VARIABLES_MODE = enabled;
            XDebuggerUtilImpl.rebuildAllSessionsViews((Project)e10.getProject());
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0x2C31992F8736L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/debugger/engine/JavaDebugProcess$AutoVarsSwitchAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

