/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongType;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaValueModifier
extends XValueModifier {
    private final JavaValue a;
    private static final long b = lb.a(1400254705153022732L, 7185140843593106001L, MethodHandles.lookup().lookupClass()).a(241104433709278L);

    public JavaValueModifier(JavaValue javaValue) {
        this.a = javaValue;
    }

    public void calculateInitialValueEditorText(final XValueModifier.XInitialValueCallback callback) {
        final Value value = this.a.getDescriptor().getValue();
        if (value == null || value instanceof PrimitiveValue) {
            String string = this.a.getValueString();
            int n2 = string.lastIndexOf(40);
            if (n2 > 1) {
                string = string.substring(0, n2).trim();
            }
            callback.setValue(string);
        } else if (value instanceof StringReference) {
            final EvaluationContextImpl evaluationContextImpl = this.a.getEvaluationContext();
            evaluationContextImpl.getManagerThread().schedule(new SuspendContextCommandImpl(evaluationContextImpl.getSuspendContext()){
                private static final long e = lb.a(448152394738203486L, -7495588904071198933L, MethodHandles.lookup().lookupClass()).a(33741801688288L);

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                    if (suspendContext == null) {
                        1.b(0);
                    }
                    callback.setValue(StringUtil.wrapWithDoubleQuote((String)DebuggerUtils.translateStringValue((String)DebuggerUtils.getValueAsString((EvaluationContext)evaluationContextImpl, (Value)value))));
                }

                private static /* synthetic */ void b(int n2) {
                    long l2 = e ^ 0x5056E8447F38L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValueModifier$1", "contextAction"));
                }
            });
        } else {
            callback.setValue(null);
        }
    }

    protected static void update(DebuggerContextImpl context) {
        DebuggerInvocationUtil.swingInvokeLater(context.getProject(), () -> {
            DebuggerSession debuggerSession = context.getDebuggerSession();
            if (debuggerSession != null) {
                debuggerSession.refresh(false);
            }
        });
    }

    protected abstract void setValueImpl(@NotNull XExpression var1, @NotNull XValueModifier.XModificationCallback var2);

    public void setValue(@NotNull XExpression expression, @NotNull XValueModifier.XModificationCallback callback) {
        ValueDescriptorImpl valueDescriptorImpl;
        long l2 = b ^ 0x65C52645F15EL;
        if (expression == null) {
            JavaValueModifier.a(0);
        }
        if (callback == null) {
            JavaValueModifier.a(1);
        }
        if (!(valueDescriptorImpl = this.a.getDescriptor()).canSetValue()) {
            return;
        }
        if (this.a.getEvaluationContext().getSuspendContext().isResumed()) {
            callback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
            return;
        }
        this.setValueImpl(expression, callback);
    }

    protected static Value preprocessValue(EvaluationContextImpl context, Value value, @NotNull Type varType) throws EvaluateException {
        String string;
        long l2 = b ^ 0x71A2FC1759B0L;
        if (varType == null) {
            JavaValueModifier.a(2);
        }
        if (value != null && "java.lang.String".equals(varType.name()) && !(value instanceof StringReference) && (string = DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)value)) != null) {
            value = DebuggerUtilsEx.mirrorOfString(string, context.getDebugProcess().getVirtualMachineProxy(), context);
        }
        if (value instanceof DoubleValue) {
            double d10 = ((DoubleValue)value).doubleValue();
            if (varType instanceof FloatType && (double)1.4E-45f <= d10 && d10 <= 3.4028234663852886E38) {
                value = context.getDebugProcess().getVirtualMachineProxy().mirrorOf((float)d10);
            }
        }
        if (value != null) {
            if (varType instanceof PrimitiveType) {
                if (!(value instanceof PrimitiveValue)) {
                    value = (Value)UnBoxingEvaluator.unbox(value, context);
                }
            } else if (varType instanceof ReferenceType && value instanceof PrimitiveValue) {
                value = (Value)new BoxingEvaluator(new IdentityEvaluator(value)).evaluate(context);
            }
        }
        return value;
    }

    @Nullable
    private static ExpressionEvaluator a(@NotNull XExpression xExpression, @Nullable Type type, @NotNull EvaluationContextImpl evaluationContextImpl) {
        if (xExpression == null) {
            JavaValueModifier.a(3);
        }
        if (evaluationContextImpl == null) {
            JavaValueModifier.a(4);
        }
        if (type instanceof LongType) {
            try {
                return new ExpressionEvaluatorImpl(new IdentityEvaluator(evaluationContextImpl.getDebugProcess().getVirtualMachineProxy().mirrorOf(Long.decode(xExpression.getExpression()))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void a(ExpressionEvaluator expressionEvaluator, EvaluationContextImpl evaluationContextImpl, SetValueRunnable setValueRunnable) throws EvaluateException {
        long l2 = b ^ 0x7075E32ED02BL;
        try {
            Value value = expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl);
            setValueRunnable.setValue(evaluationContextImpl, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw EvaluateExceptionUtil.createEvaluateException((String)illegalArgumentException.getMessage());
        }
        catch (InvalidTypeException invalidTypeException) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.type.mismatch", (Object[])new Object[0]));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            if (!evaluationContextImpl.isAutoLoadClasses()) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)classNotLoadedException);
            }
            try {
                ReferenceType referenceType = evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, classNotLoadedException.className(), setValueRunnable.getClassLoader(evaluationContextImpl));
                if (referenceType != null) {
                    JavaValueModifier.a(expressionEvaluator, evaluationContextImpl, setValueRunnable);
                }
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException exception) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
            }
        }
    }

    protected void set(final @NotNull XExpression expression, final XValueModifier.XModificationCallback callback, DebuggerContextImpl debuggerContext, final SetValueRunnable setValueRunnable) {
        long l2 = b ^ 0x6B8488E67962L;
        if (expression == null) {
            JavaValueModifier.a(5);
        }
        final ProgressWindow progressWindow = new ProgressWindow(true, debuggerContext.getProject());
        final EvaluationContextImpl evaluationContextImpl = this.a.getEvaluationContext();
        DebuggerContextCommandImpl debuggerContextCommandImpl = new DebuggerContextCommandImpl(debuggerContext){
            private static final long i = lb.a(6944715226122686576L, 5196935703998872142L, MethodHandles.lookup().lookupClass()).a(194131798422751L);

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.c(0);
                }
                try {
                    ExpressionEvaluator expressionEvaluator = JavaValueModifier.a(expression, setValueRunnable.getLType(), evaluationContextImpl);
                    if (expressionEvaluator == null) {
                        final Project project2 = evaluationContextImpl.getProject();
                        final SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)evaluationContextImpl);
                        final PsiElement psiElement = ContextUtil.getContextElement((StackFrameContext)evaluationContextImpl, sourcePosition);
                        expressionEvaluator = DebuggerInvocationUtil.commitAndRunReadAction(project2, new EvaluatingComputable<ExpressionEvaluator>(){

                            @Override
                            public ExpressionEvaluator compute() throws EvaluateException {
                                return EvaluatorBuilderImpl.build(TextWithImportsImpl.fromXExpression(expression), psiElement, sourcePosition, project2);
                            }
                        });
                    }
                    JavaValueModifier.a(expressionEvaluator, evaluationContextImpl, new SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException {
                            if (!progressWindow.isCanceled()) {
                                setValueRunnable.setValue(evaluationContext, newValue);
                            }
                        }

                        @Override
                        @Nullable
                        public Type getLType() throws EvaluateException, ClassNotLoadedException {
                            return setValueRunnable.getLType();
                        }
                    });
                    callback.valueModified();
                }
                catch (EvaluateException | ClassNotLoadedException throwable) {
                    callback.errorOccurred(throwable.getMessage());
                }
            }

            private static /* synthetic */ void c(int n2) {
                long l2 = i ^ 0x29358ABA12DL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValueModifier$2", "threadAction"));
            }
        };
        progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
        evaluationContextImpl.getDebugProcess().getManagerThread().startProgress(debuggerContextCommandImpl, progressWindow);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x2533E8C6EE0L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/JavaValueModifier";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryDirectAssignment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static interface SetValueRunnable {
        public void setValue(EvaluationContextImpl var1, Value var2) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException;

        default public ClassLoaderReference getClassLoader(EvaluationContextImpl evaluationContext) throws EvaluateException {
            return evaluationContext.getClassLoader();
        }

        @Nullable
        public Type getLType() throws ClassNotLoadedException, EvaluateException;
    }
}

