/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import b.a.lb;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SmartHashSet;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspendManagerUtil {
    private static final Logger a;
    private static final long b;

    public static boolean isEvaluating(SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        for (SuspendContextImpl suspendContextImpl : suspendManager.getEventContexts()) {
            if (!suspendContextImpl.isEvaluating() || !thread.equals(suspendContextImpl.getThread())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static SuspendContextImpl findContextByThread(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            SuspendManagerUtil.a(0);
        }
        for (SuspendContextImpl suspendContextImpl : suspendManager.getEventContexts()) {
            if (suspendContextImpl.getThread() != thread && suspendContextImpl.getSuspendPolicy() != 2 || suspendContextImpl.isExplicitlyResumed(thread)) continue;
            return suspendContextImpl;
        }
        return null;
    }

    public static void assertSuspendContext(SuspendContextImpl context) {
        long l2 = b ^ 0xF11D7395374L;
        if (a.isDebugEnabled()) {
            a.assertTrue(context.myInProgress, (Object)"You can invoke methods only inside commands invoked for SuspendContext");
        }
    }

    @NotNull
    public static Set<SuspendContextImpl> getSuspendingContexts(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            SuspendManagerUtil.a(1);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Set set = (Set)suspendManager.getEventContexts().stream().filter(suspendContextImpl -> suspendContextImpl.suspends(thread)).collect(Collectors.toCollection(SmartHashSet::new));
        if (set == null) {
            SuspendManagerUtil.a(2);
        }
        return set;
    }

    @Nullable
    public static SuspendContextImpl getSuspendingContext(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            SuspendManagerUtil.a(3);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return suspendManager.getEventContexts().stream().filter(suspendContextImpl -> suspendContextImpl.suspends(thread)).findFirst().orElse(null);
    }

    public static void restoreAfterResume(SuspendContextImpl context, Object resumeData) {
        long l2 = b ^ 0x3FFEA1D8D8A8L;
        SuspendManager suspendManager = context.getDebugProcess().getSuspendManager();
        ResumeData resumeData2 = (ResumeData)resumeData;
        ThreadReferenceProxyImpl threadReferenceProxyImpl = context.getThread();
        if (resumeData2.myIsFrozen && !suspendManager.isFrozen(threadReferenceProxyImpl)) {
            suspendManager.freezeThread(threadReferenceProxyImpl);
        }
        a.debug("RestoreAfterResume SuspendContextImpl...");
        a.assertTrue(context.myResumedThreads == null);
        if (resumeData2.myResumedThreads != null) {
            resumeData2.myResumedThreads.forEach(ThreadReferenceProxyImpl::resume);
            context.myResumedThreads = resumeData2.myResumedThreads;
        }
    }

    public static Object prepareForResume(SuspendContextImpl context) {
        long l2 = b ^ 0x54A872255872L;
        SuspendManager suspendManager = context.getDebugProcess().getSuspendManager();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = context.getThread();
        ResumeData resumeData = new ResumeData(suspendManager.isFrozen(threadReferenceProxyImpl), context.myResumedThreads);
        if (resumeData.myIsFrozen) {
            suspendManager.unfreezeThread(threadReferenceProxyImpl);
        }
        a.debug("Resuming SuspendContextImpl...");
        if (context.myResumedThreads != null) {
            context.myResumedThreads.forEach(ThreadReferenceProxyImpl::suspend);
            context.myResumedThreads = null;
        }
        return resumeData;
    }

    public static SuspendContextImpl getEvaluatingContext(SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        for (SuspendContextImpl suspendContextImpl : suspendManager.getEventContexts()) {
            if (suspendContextImpl.isResumed() || !suspendContextImpl.isEvaluating() || suspendContextImpl.getThread() != thread) continue;
            return suspendContextImpl;
        }
        return null;
    }

    static {
        b = lb.a(-4344518922457870599L, 2745537217486142755L, MethodHandles.lookup().lookupClass()).a(121164550259643L);
        long l2 = b ^ 0x13D7F86EE116L;
        a = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendManagerUtil");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x5C7335497113L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/SuspendManagerUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/SuspendManagerUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendingContexts";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findContextByThread";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSuspendingContexts";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuspendingContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResumeData {
        final boolean myIsFrozen;
        final Set<ThreadReferenceProxyImpl> myResumedThreads;

        ResumeData(boolean isFrozen, Set<ThreadReferenceProxyImpl> resumedThreads) {
            this.myIsFrozen = isFrozen;
            this.myResumedThreads = resumedThreads;
        }
    }
}

