/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import b.a.lb;
import com.intellij.Patches;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.debugger.DefaultMethodInvoker;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodEvaluator
implements Evaluator {
    private static final Logger g;
    private final JVMName b;
    private final JVMName f;
    private final String h;
    private final Evaluator[] c;
    private final Evaluator e;
    private final boolean a;
    private final boolean d;
    private static final long i;

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, Evaluator[] argumentEvaluators) {
        this(objectEvaluator, className, methodName, signature, argumentEvaluators, false, false);
    }

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, Evaluator[] argumentEvaluators, boolean checkDefaultInterfaceMethod, boolean mustBeVararg) {
        this.e = DisableGC.create(objectEvaluator);
        this.b = className;
        this.h = methodName;
        this.f = signature;
        this.c = argumentEvaluators;
        this.a = checkDefaultInterfaceMethod;
        this.d = mustBeVararg;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        long l2 = i ^ 0x21C7FEF35216L;
        if (!context.getDebugProcess().isAttached()) {
            return null;
        }
        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
        boolean bl2 = this.e instanceof SuperEvaluator || this.e instanceof DisableGC && ((DisableGC)this.e).getDelegate() instanceof SuperEvaluator;
        Object object = this.e.evaluate(context);
        if (g.isDebugEnabled()) {
            g.debug("MethodEvaluator: object = " + object);
        }
        if (object == null) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
        }
        if (!(object instanceof ObjectReference) && !MethodEvaluator.a(object)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.evaluating.method", (Object[])new Object[]{this.h}));
        }
        ArrayList<Value> arrayList = new ArrayList<Value>(this.c.length);
        for (Evaluator object2 : this.c) {
            arrayList.add((Value)object2.evaluate(context));
        }
        try {
            Method method;
            Object object3 = null;
            if (object instanceof ObjectReference) {
                object3 = ((ObjectReference)object).referenceType();
            } else if (MethodEvaluator.a(object)) {
                object3 = (ReferenceType)object;
            }
            if (object3 == null) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{this.h})));
            }
            String string = this.f != null ? this.f.getName(debugProcessImpl) : null;
            String string2 = DebuggerUtilsEx.methodName(object3.name(), this.h, string);
            if (MethodEvaluator.a(object)) {
                Method method2;
                if (MethodEvaluator.a(object3) && (method2 = DebuggerUtils.findMethod((ReferenceType)object3, (String)this.h, (String)string)) != null && method2.isStatic()) {
                    if (object3 instanceof ClassType) {
                        return debugProcessImpl.invokeMethod((EvaluationContext)context, (ClassType)object3, method2, arrayList);
                    }
                    return debugProcessImpl.invokeMethod((EvaluationContext)context, (InterfaceType)object3, method2, arrayList);
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.static.method", (Object[])new Object[]{string2}));
            }
            ObjectReference objectReference = (ObjectReference)object;
            Object object2 = object3;
            if (bl2 && object3 instanceof ClassType) {
                object2 = ((ClassType)object3).superclass();
                Method method3 = method = this.b != null ? this.b.getName(debugProcessImpl) : null;
                if (object2 == null || method != null && !((String)((Object)method)).equals(object2.name())) {
                    object2 = debugProcessImpl.findClass(context, (String)((Object)method), context.getClassLoader());
                }
            }
            method = DebuggerUtils.findMethod((ReferenceType)object2, (String)this.h, (String)string);
            if (string == null) {
                if (method == null || method.argumentTypeNames().size() != arrayList.size()) {
                    for (Method method4 : object2.methodsByName(this.h)) {
                        if (method4.argumentTypeNames().size() != arrayList.size()) continue;
                        method = method4;
                        break;
                    }
                }
            } else if (this.d && method != null && !method.isVarArgs()) {
                for (Method method5 : object2.allMethods()) {
                    if (!method5.isVarArgs() || !method5.name().equals(this.h) || !method5.signature().equals(string)) continue;
                    method = method5;
                    break;
                }
            }
            if (method == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.instance.method", (Object[])new Object[]{string2}));
            }
            if (bl2) {
                return debugProcessImpl.invokeInstanceMethod(context, objectReference, method, arrayList, 2);
            }
            if (Patches.JDK_BUG_ID_8042123 && this.a && method.declaringType() instanceof InterfaceType) {
                try {
                    return MethodEvaluator.a(debugProcessImpl, context, objectReference, this.h);
                }
                catch (EvaluateException evaluateException) {
                    g.info((Throwable)evaluateException);
                }
            }
            return debugProcessImpl.invokeMethod((EvaluationContext)context, objectReference, method, arrayList);
        }
        catch (Exception exception) {
            g.debug((Throwable)exception);
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
        }
    }

    private static boolean a(Object object) {
        return object instanceof ClassType || object instanceof InterfaceType;
    }

    private static Value a(DebugProcess debugProcess, EvaluationContext evaluationContext, Value value, String string) throws EvaluateException {
        List<Method> list2;
        long l2 = i ^ 0x44DFF6F03F5CL;
        ClassType classType = ClassLoadingUtils.getHelperClass(DefaultMethodInvoker.class, evaluationContext);
        if (classType != null && !(list2 = classType.methodsByName("invoke")).isEmpty()) {
            return debugProcess.invokeMethod(evaluationContext, classType, list2.get(0), Arrays.asList(value, ((VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy()).mirrorOf(string)));
        }
        return null;
    }

    public String toString() {
        long l2 = i ^ 0x625F95DCA958L;
        return "call " + this.h;
    }

    static {
        i = lb.a(6599577887851678175L, -1432195710910586755L, MethodHandles.lookup().lookupClass()).a(48524289275273L);
        long l2 = i ^ 0x53529E6D33L;
        g = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.MethodEvaluator");
    }
}

