/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;

class NewArrayInstanceEvaluator
implements Evaluator {
    private static final Logger d;
    private final Evaluator a;
    private Evaluator b = null;
    private Evaluator c = null;
    private static final long e;

    NewArrayInstanceEvaluator(Evaluator arrayTypeEvaluator, Evaluator dimensionEvaluator, Evaluator initializerEvaluator) {
        this.a = arrayTypeEvaluator;
        this.b = dimensionEvaluator;
        this.c = initializerEvaluator;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        int n2;
        Object object;
        long l2 = e ^ 0x57CC6B691286L;
        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
        Object object2 = this.a.evaluate(context);
        if (!(object2 instanceof ArrayType)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.array.type.expected", (Object[])new Object[0]));
        }
        ArrayType arrayType = (ArrayType)object2;
        Object[] objectArray = null;
        if (this.b != null) {
            object = this.b.evaluate(context);
            if (!(object instanceof Value) || !DebuggerUtils.isNumeric((Value)((Value)object))) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.array.dimention.numeric.value.expected", (Object[])new Object[0]));
            }
            PrimitiveValue primitiveValue = (PrimitiveValue)object;
            n2 = primitiveValue.intValue();
        } else {
            object = this.c.evaluate(context);
            if (!(object instanceof Object[])) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.array.initializer", (Object[])new Object[0]));
            }
            objectArray = (Object[])object;
            n2 = objectArray.length;
        }
        object = DebuggerUtilsEx.mirrorOfArray(arrayType, n2, context);
        if (objectArray != null && objectArray.length > 0) {
            if (d.isDebugEnabled()) {
                d.debug("Setting initial values: dimension = " + n2 + "; array size is " + objectArray.length);
            }
            NewArrayInstanceEvaluator.a((ArrayReference)object, objectArray, context);
        }
        return object;
    }

    private static void a(ArrayReference arrayReference, Object[] objectArray, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        long l2 = e ^ 0x41BB53E38369L;
        ArrayType arrayType = (ArrayType)arrayReference.referenceType();
        DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
        try {
            if (arrayType.componentType() instanceof ArrayType) {
                ArrayType arrayType2 = (ArrayType)arrayType.componentType();
                int n2 = arrayReference.length();
                for (int i10 = 0; i10 < n2; ++i10) {
                    Object object = objectArray[i10];
                    if (object instanceof Value) {
                        arrayReference.setValue(i10, (Value)object);
                        continue;
                    }
                    ArrayReference arrayReference2 = (ArrayReference)arrayReference.getValue(i10);
                    Object[] objectArray2 = (Object[])object;
                    if (arrayReference2 == null) {
                        arrayReference2 = DebuggerUtilsEx.mirrorOfArray(arrayType2, objectArray2.length, evaluationContextImpl);
                        arrayReference.setValue(i10, (Value)arrayReference2);
                    }
                    NewArrayInstanceEvaluator.a(arrayReference2, objectArray2, evaluationContextImpl);
                }
            } else if (objectArray.length > 0) {
                arrayReference.setValues(new ArrayList<Object>(Arrays.asList(objectArray)));
            }
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            ReferenceType referenceType;
            try {
                referenceType = evaluationContextImpl.isAutoLoadClasses() ? debugProcessImpl.loadClass(evaluationContextImpl, classNotLoadedException.className(), arrayType.classLoader()) : null;
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException exception) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
            }
            if (referenceType != null) {
                NewArrayInstanceEvaluator.a(arrayReference, objectArray, evaluationContextImpl);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{classNotLoadedException.className()}));
        }
        catch (InvalidTypeException invalidTypeException) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.array.initializer.type", (Object[])new Object[0]));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.array.size", (Object[])new Object[0]));
        }
        catch (ClassCastException classCastException) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.initialize.array", (Object[])new Object[0]));
        }
    }

    static {
        e = lb.a(-3352521501522059128L, -5850530886338567701L, MethodHandles.lookup().lookupClass()).a(183175206952383L);
        long l2 = e ^ 0x6DCF59F52204L;
        d = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.NewArrayInstanceEvaluator");
    }
}

