/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SourceCodeChecker;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DebuggerContextUtil {
    private static final long a = lb.a(5881787068714751897L, -7808652255017288756L, MethodHandles.lookup().lookupClass()).a(59966153299096L);

    public static void setStackFrame(final DebuggerStateManager manager, final StackFrameProxyImpl stackFrame) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerContextImpl debuggerContextImpl = manager.getContext();
        final DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
        if (debuggerSession != null) {
            debuggerSession.getProcess().getManagerThread().schedule(new DebuggerCommandImpl(PrioritizedTask.Priority.HIGH){

                @Override
                protected void action() {
                    SuspendContextImpl suspendContextImpl = SuspendManagerUtil.findContextByThread(debuggerSession.getProcess().getSuspendManager(), stackFrame.threadProxy());
                    DebuggerContextImpl debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(debuggerSession, suspendContextImpl, stackFrame.threadProxy(), stackFrame);
                    DebuggerInvocationUtil.swingInvokeLater(debuggerSession.getProject(), () -> {
                        manager.setState(debuggerContextImpl, debuggerSession.getState(), DebuggerSession.Event.REFRESH, null);
                        SourceCodeChecker.checkSource(debuggerContextImpl);
                    });
                }
            });
        } else {
            manager.setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.REFRESH, null);
        }
    }

    public static void setThread(DebuggerStateManager contextManager, ThreadDescriptorImpl item) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerSession debuggerSession = contextManager.getContext().getDebuggerSession();
        DebuggerContextImpl debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(debuggerSession, item.getSuspendContext(), item.getThreadReference(), null);
        contextManager.setState(debuggerContextImpl, debuggerSession != null ? debuggerSession.getState() : DebuggerSession.State.DISPOSED, DebuggerSession.Event.CONTEXT, null);
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@NotNull DebuggerSession session, SuspendContextImpl suspendContext) {
        if (session == null) {
            DebuggerContextUtil.a(0);
        }
        DebuggerContextImpl debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(session, suspendContext, suspendContext != null ? suspendContext.getThread() : null, null);
        if (debuggerContextImpl == null) {
            DebuggerContextUtil.a(1);
        }
        return debuggerContextImpl;
    }

    public static SourcePosition findNearest(@NotNull DebuggerContextImpl context, @NotNull PsiElement psi, @NotNull PsiFile file) {
        if (context == null) {
            DebuggerContextUtil.a(2);
        }
        if (psi == null) {
            DebuggerContextUtil.a(3);
        }
        if (file == null) {
            DebuggerContextUtil.a(4);
        }
        if (psi instanceof PsiCompiledElement) {
            return null;
        }
        DebuggerSession debuggerSession = context.getDebuggerSession();
        if (debuggerSession != null) {
            try {
                XDebugSession xDebugSession = debuggerSession.getXDebugSession();
                if (xDebugSession != null) {
                    XSourcePosition xSourcePosition = xDebugSession.getCurrentPosition();
                    Editor editor = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)file.getProject())).getSelectedTextEditor(true);
                    if (editor != null && xSourcePosition != null && xSourcePosition.getFile().equals(file.getOriginalFile().getVirtualFile())) {
                        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)PositionUtil.getContextElement((StackFrameContext)context), PsiMethod.class, (boolean)false);
                        Collection collection = IdentifierHighlighterPass.getUsages((PsiElement)psi, (PsiElement)(psiMethod != null ? psiMethod : file), (boolean)false);
                        int n2 = xSourcePosition.getLine();
                        int n3 = -1;
                        int n4 = -1;
                        for (TextRange textRange : collection) {
                            int n5 = editor.offsetToLogicalPosition((int)textRange.getStartOffset()).line;
                            if (n5 > n3 && n5 < n2) {
                                n3 = n5;
                                n4 = textRange.getStartOffset();
                                continue;
                            }
                            if (n5 != n2) continue;
                            n4 = textRange.getStartOffset();
                            break;
                        }
                        if (n4 > -1) {
                            return SourcePosition.createFromOffset((PsiFile)file, (int)n4);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x5ABD9FE33CA7L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerContextUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerContextUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebuggerContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDebuggerContext";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findNearest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

